/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.model.style.MStyles;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.SelectionHelper;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class CreateStyleCommand
extends Command {
    private JRDesignStyle jrStyle;
    private JasperDesign jrDesign;
    private int index;

    public CreateStyleCommand(JasperDesign jd, JRDesignStyle style) {
        this.jrDesign = jd;
        this.jrStyle = style;
        this.index = -1;
    }

    public CreateStyleCommand(MStyles destNode, MStyle srcNode, int index) {
        this.jrDesign = destNode.getJasperDesign();
        this.index = index;
        if (srcNode != null && srcNode.getValue() != null) {
            this.jrStyle = (JRDesignStyle)srcNode.getValue().clone();
        }
    }

    public void execute() {
        if (this.jrStyle == null) {
            this.jrStyle = MStyle.createJRStyle(this.jrDesign);
        }
        if (this.jrStyle != null) {
            block6: {
                try {
                    if (this.index < 0 || this.index > this.jrDesign.getStylesList().size()) {
                        this.jrDesign.addStyle((JRStyle)this.jrStyle);
                    } else {
                        this.jrDesign.addStyle(this.index, (JRStyle)this.jrStyle);
                    }
                }
                catch (JRException e) {
                    e.printStackTrace();
                    if (!e.getMessage().startsWith("Duplicate declaration")) break block6;
                    String defaultName = ModelUtils.getDefaultName(this.jrDesign.getStylesMap(), "CopyOf_" + this.jrStyle.getName());
                    InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), Messages.CreateStyleCommand_style_name, Messages.CreateStyleCommand_style_name_dialog_text, defaultName, null);
                    if (dlg.open() != 0) break block6;
                    this.jrStyle.setName(dlg.getValue());
                    this.execute();
                }
            }
            SelectionHelper.setOutlineSelection(this.jrStyle);
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        this.jrDesign.removeStyle((JRStyle)this.jrStyle);
    }
}

