/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style.command;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.style.MStyles;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;

public class DeleteStyleCommand
extends Command {
    private JasperDesign jrDesign;
    private JRDesignStyle jrStyle;
    private int elementPosition = 0;
    private MReport reportNode;
    private List<ANode> elementsUsingStyle = null;

    public DeleteStyleCommand(MReport reportNode, JRDesignStyle style) {
        this.jrDesign = reportNode.getJasperDesign();
        this.jrStyle = style;
        this.reportNode = reportNode;
    }

    public DeleteStyleCommand(MStyles styleNode, JRDesignStyle style) {
        this.jrDesign = styleNode.getJasperDesign();
        this.jrStyle = style;
        this.reportNode = ModelUtils.getReport(styleNode);
    }

    public void execute() {
        if (this.reportNode != null) {
            this.elementsUsingStyle = this.reportNode.getUsedStyles().get(this.jrStyle.getName());
        }
        this.elementPosition = this.jrDesign.getStylesList().indexOf(this.jrStyle);
        this.jrDesign.removeStyle((JRStyle)this.jrStyle);
        if (this.elementsUsingStyle != null) {
            for (ANode node : this.elementsUsingStyle) {
                node.setStyle(null);
            }
        }
    }

    public boolean canUndo() {
        return this.jrDesign != null && this.jrStyle != null;
    }

    public void undo() {
        try {
            if (this.elementPosition < 0 || this.elementPosition > this.jrDesign.getStylesList().size()) {
                this.jrDesign.addStyle((JRStyle)this.jrStyle);
            } else {
                this.jrDesign.addStyle(this.elementPosition, (JRStyle)this.jrStyle);
            }
            if (this.elementsUsingStyle != null) {
                for (ANode node : this.elementsUsingStyle) {
                    node.setStyle((JRStyle)this.jrStyle);
                }
                this.elementsUsingStyle = null;
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

