/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style.command;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.model.style.MStyles;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;

public class ReorderStyleCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignStyle jrStyle;
    private JasperDesign jrDesign;

    public ReorderStyleCommand(MStyle child, MStyles parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrDesign = parent.getJasperDesign();
        this.jrStyle = (JRDesignStyle)child.getValue();
    }

    public void execute() {
        this.oldIndex = this.jrDesign.getStylesList().indexOf(this.jrStyle);
        try {
            this.jrDesign.removeStyle((JRStyle)this.jrStyle);
            if (this.newIndex < 0 || this.newIndex > this.jrDesign.getStylesList().size()) {
                this.jrDesign.addStyle((JRStyle)this.jrStyle);
            } else {
                this.jrDesign.addStyle(this.newIndex, (JRStyle)this.jrStyle);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void undo() {
        try {
            this.jrDesign.removeStyle((JRStyle)this.jrStyle);
            if (this.oldIndex < 0 || this.oldIndex > this.jrDesign.getStylesList().size()) {
                this.jrDesign.addStyle((JRStyle)this.jrStyle);
            } else {
                this.jrDesign.addStyle(this.oldIndex, (JRStyle)this.jrStyle);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

