/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.style.command;

import com.jaspersoft.studio.model.style.MConditionalStyle;
import com.jaspersoft.studio.model.style.MStyle;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;

public class ResetConditionalStyleCommand
extends Command {
    private MStyle oldStyle;
    private JasperDesign jrDesign;
    private JRDesignConditionalStyle newStyle;
    private JRDesignConditionalStyle oldDesignStyle;

    public ResetConditionalStyleCommand(JasperDesign jd, MStyle oldStyle) {
        this.jrDesign = jd;
        this.oldStyle = oldStyle;
        this.oldDesignStyle = (JRDesignConditionalStyle)oldStyle.getValue();
    }

    private void copyStyleAttributes(JRDesignConditionalStyle source, JRDesignConditionalStyle dest) {
        dest.setBackcolor(source.getOwnBackcolor());
        dest.setBlankWhenNull(source.isOwnBlankWhenNull());
        dest.setBold(source.isOwnBold());
        dest.setFill(source.getOwnFillValue());
        dest.setFontName(source.getOwnFontName());
        dest.setFontSize(source.getOwnFontsize());
        dest.setForecolor(source.getOwnForecolor());
        dest.setHorizontalTextAlign(source.getOwnHorizontalTextAlign());
        dest.setHorizontalImageAlign(source.getOwnHorizontalImageAlign());
        dest.setItalic(source.isOwnItalic());
        dest.setMarkup(source.getOwnMarkup());
        dest.setMode(source.getOwnModeValue());
        dest.setParentStyle(source.getStyle());
        dest.setPattern(source.getOwnPattern());
        dest.setPdfEmbedded(source.isOwnPdfEmbedded());
        dest.setPdfEncoding(source.getOwnPdfEncoding());
        dest.setPdfFontName(source.getOwnPdfFontName());
        dest.setRadius(source.getOwnRadius());
        dest.setRotation(source.getOwnRotationValue());
        dest.setScaleImage(source.getOwnScaleImageValue());
        dest.setStrikeThrough(source.isOwnStrikeThrough());
        dest.setUnderline(source.isOwnUnderline());
        dest.setVerticalTextAlign(source.getOwnVerticalTextAlign());
        dest.setVerticalImageAlign(source.getOwnVerticalImageAlign());
        dest.setConditionExpression(source.getConditionExpression());
    }

    public void execute() {
        this.newStyle = null;
        if (this.oldStyle == null) {
            return;
        }
        JRDesignConditionalStyle defaultValueStyle = MConditionalStyle.createJRStyle();
        JRDesignConditionalStyle dummyStyle = MConditionalStyle.createJRStyle();
        this.copyStyleAttributes(this.oldDesignStyle, dummyStyle);
        this.newStyle = this.oldDesignStyle;
        this.oldDesignStyle = dummyStyle;
        this.copyStyleAttributes(defaultValueStyle, this.newStyle);
    }

    public boolean canUndo() {
        return this.oldStyle != null && this.newStyle != null;
    }

    public void undo() {
        this.copyStyleAttributes(this.oldDesignStyle, this.newStyle);
        this.newStyle = null;
        this.oldDesignStyle = null;
    }
}

