/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.text;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.IPropertiesHolder;
import com.jaspersoft.studio.property.JSSStyleResolver;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.tabstops.TabStopsPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.FloatPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.PixelPropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.base.JRBaseParagraph;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MParagraph
extends APropertyNode
implements IPropertiesHolder {
    public static final long serialVersionUID = 10200L;
    private static IPropertyDescriptor[] descriptors;
    private static NamedEnumPropertyDescriptor<LineSpacingEnum> lineSpacingD;
    private APropertyNode pHolder;

    public MParagraph(ANode parent, JRBaseParagraph bParagraph) {
        if (parent.getValue() instanceof JRPropertiesHolder && parent instanceof APropertyNode) {
            this.pHolder = (APropertyNode)parent;
        }
        this.setJasperConfiguration(parent.getJasperConfiguration());
        this.setValue(bParagraph);
    }

    @Override
    public APropertyNode getPropertiesHolder() {
        return this.pHolder;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        lineSpacingD = new NamedEnumPropertyDescriptor<LineSpacingEnum>("lineSpacing", Messages.common_line_spacing, LineSpacingEnum.AT_LEAST, NullEnum.INHERITED);
        lineSpacingD.setDescription(Messages.MTextElement_line_spacing_description);
        desc.add((IPropertyDescriptor)lineSpacingD);
        FloatPropertyDescriptor lineSpacingSize = new FloatPropertyDescriptor("lineSpacingSize", Messages.MParagraph_lineSpacingSizeTitle);
        lineSpacingSize.setDescription(Messages.MParagraph_lineSpacingSizeDescription);
        desc.add((IPropertyDescriptor)lineSpacingSize);
        PixelPropertyDescriptor firstLineIdent = new PixelPropertyDescriptor("firstLineIndent", Messages.MParagraph_firstIdentTitle);
        firstLineIdent.setDescription(Messages.MParagraph_firstIdentDescription);
        desc.add((IPropertyDescriptor)firstLineIdent);
        PixelPropertyDescriptor leftIdent = new PixelPropertyDescriptor("leftIndent", Messages.MParagraph_leftIdentTitle);
        leftIdent.setDescription(Messages.MParagraph_leftIdentDescription);
        desc.add((IPropertyDescriptor)leftIdent);
        PixelPropertyDescriptor rightIdent = new PixelPropertyDescriptor("rightIndent", Messages.MParagraph_rightIdentTitle);
        rightIdent.setDescription(Messages.MParagraph_rightIdentDescription);
        desc.add((IPropertyDescriptor)rightIdent);
        PixelPropertyDescriptor spacingBefore = new PixelPropertyDescriptor("spacingBefore", Messages.MParagraph_spacingBeforeTitle);
        spacingBefore.setDescription(Messages.MParagraph_spacingBeforeDescription);
        desc.add((IPropertyDescriptor)spacingBefore);
        PixelPropertyDescriptor spacingAfter = new PixelPropertyDescriptor("spacingAfter", Messages.MParagraph_spacingAfterTitle);
        spacingAfter.setDescription(Messages.MParagraph_spacingAfterDescription);
        desc.add((IPropertyDescriptor)spacingAfter);
        PixelPropertyDescriptor tabStopWidth = new PixelPropertyDescriptor("tabStopWidth", Messages.MParagraph_tabStopWidthTitle);
        tabStopWidth.setDescription(Messages.MParagraph_tabStopWidthDescription);
        desc.add((IPropertyDescriptor)tabStopWidth);
        TabStopsPropertyDescriptor tabStops = new TabStopsPropertyDescriptor("tabStops", Messages.MParagraph_tabStopsTitle);
        tabStops.setDescription(Messages.MParagraph_tabStopsDescription);
        desc.add((IPropertyDescriptor)tabStops);
        tabStops.setCategory("Paragraph");
        lineSpacingD.setCategory("Paragraph");
        lineSpacingSize.setCategory("Paragraph");
        firstLineIdent.setCategory("Paragraph");
        leftIdent.setCategory("Paragraph");
        rightIdent.setCategory("Paragraph");
        spacingBefore.setCategory("Paragraph");
        spacingAfter.setCategory("Paragraph");
        tabStopWidth.setCategory("Paragraph");
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#paragraph");
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    public Object getPropertyActualValue(Object id) {
        JSSStyleResolver resolver = this.getStyleResolver();
        JRBaseParagraph jrElement = (JRBaseParagraph)this.getValue();
        if (jrElement != null) {
            if (id.equals("lineSpacing")) {
                LineSpacingEnum spacingEnum = resolver.getLineSpacing((JRParagraph)jrElement);
                return lineSpacingD.getIntValue(spacingEnum);
            }
            if (id.equals("lineSpacingSize")) {
                return resolver.getLineSpacingSize((JRParagraph)jrElement);
            }
            if (id.equals("firstLineIndent")) {
                return resolver.getFirstLineIndent((JRParagraph)jrElement);
            }
            if (id.equals("leftIndent")) {
                return resolver.getLeftIndent((JRParagraph)jrElement);
            }
            if (id.equals("rightIndent")) {
                return resolver.getRightIndent((JRParagraph)jrElement);
            }
            if (id.equals("spacingBefore")) {
                return resolver.getSpacingBefore((JRParagraph)jrElement);
            }
            if (id.equals("spacingAfter")) {
                return resolver.getSpacingAfter((JRParagraph)jrElement);
            }
            if (id.equals("tabStopWidth")) {
                return resolver.getTabStopWidth((JRParagraph)jrElement);
            }
        }
        return super.getPropertyActualValue(id);
    }

    public Object getPropertyValue(Object id) {
        JRBaseParagraph jrElement = (JRBaseParagraph)this.getValue();
        if (jrElement != null) {
            if (id.equals("lineSpacing")) {
                LineSpacingEnum ownLineSpacing = jrElement.getOwnLineSpacing();
                return ownLineSpacing != null ? lineSpacingD.getIntValue(jrElement.getOwnLineSpacing()) : null;
            }
            if (id.equals("lineSpacingSize")) {
                return jrElement.getOwnLineSpacingSize();
            }
            if (id.equals("firstLineIndent")) {
                return jrElement.getOwnFirstLineIndent();
            }
            if (id.equals("leftIndent")) {
                return jrElement.getOwnLeftIndent();
            }
            if (id.equals("rightIndent")) {
                return jrElement.getOwnRightIndent();
            }
            if (id.equals("spacingBefore")) {
                return jrElement.getOwnSpacingBefore();
            }
            if (id.equals("spacingAfter")) {
                return jrElement.getOwnSpacingAfter();
            }
            if (id.equals("tabStopWidth")) {
                return jrElement.getOwnTabStopWidth();
            }
            if (id.equals("tabStops")) {
                TabStop[] tabStops = jrElement.getTabStops();
                if (tabStops != null) {
                    return new ArrayList<TabStop>(Arrays.asList(tabStops));
                }
                return new ArrayList();
            }
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        JRBaseParagraph jrElement = (JRBaseParagraph)this.getValue();
        if (jrElement != null) {
            if (id.equals("lineSpacing")) {
                jrElement.setLineSpacing(lineSpacingD.getEnumValue(value));
            }
            if (id.equals("lineSpacingSize")) {
                jrElement.setLineSpacingSize((Float)value);
            }
            if (id.equals("firstLineIndent")) {
                jrElement.setFirstLineIndent((Integer)value);
            }
            if (id.equals("leftIndent")) {
                jrElement.setLeftIndent((Integer)value);
            }
            if (id.equals("rightIndent")) {
                jrElement.setRightIndent((Integer)value);
            }
            if (id.equals("spacingBefore")) {
                jrElement.setSpacingBefore((Integer)value);
            }
            if (id.equals("spacingAfter")) {
                jrElement.setSpacingAfter((Integer)value);
            }
            if (id.equals("tabStopWidth")) {
                jrElement.setTabStopWidth((Integer)value);
            }
            if (id.equals("tabStops")) {
                if (jrElement.getTabStops() != null) {
                    TabStop[] tabStopArray = jrElement.getTabStops();
                    int n = tabStopArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TabStop ts = tabStopArray[n2];
                        jrElement.removeTabStop(ts);
                        ++n2;
                    }
                }
                if (value instanceof List) {
                    for (TabStop ts : (List)value) {
                        jrElement.addTabStop(ts);
                    }
                }
            }
        }
    }

    @Override
    public HashMap<String, Object> getStylesDescriptors() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.getValue() == null) {
            return result;
        }
        JRBaseParagraph jrElement = (JRBaseParagraph)this.getValue();
        result.put("lineSpacing", jrElement.getOwnLineSpacing());
        result.put("lineSpacingSize", jrElement.getOwnLineSpacingSize());
        result.put("firstLineIndent", jrElement.getOwnFirstLineIndent());
        result.put("leftIndent", jrElement.getOwnLeftIndent());
        result.put("rightIndent", jrElement.getOwnRightIndent());
        result.put("spacingBefore", jrElement.getOwnSpacingBefore());
        result.put("spacingAfter", jrElement.getOwnSpacingAfter());
        result.put("tabStopWidth", jrElement.getOwnTabStopWidth());
        return result;
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaults = super.createDefaultsMap();
        defaults.put("lineSpacingSize", new DefaultValue(true));
        defaults.put("firstLineIndent", new DefaultValue(true));
        defaults.put("leftIndent", new DefaultValue(true));
        defaults.put("rightIndent", new DefaultValue(true));
        defaults.put("spacingBefore", new DefaultValue(true));
        defaults.put("spacingAfter", new DefaultValue(true));
        defaults.put("tabStopWidth", new DefaultValue(true));
        return defaults;
    }

    @Override
    public String getDisplayText() {
        return null;
    }

    @Override
    public ImageDescriptor getImagePath() {
        return null;
    }
}

