/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.text;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.IRotatable;
import com.jaspersoft.studio.model.MGraphicElementLineBox;
import com.jaspersoft.studio.model.text.MFont;
import com.jaspersoft.studio.model.text.MParagraph;
import com.jaspersoft.studio.properties.view.validation.ValidationError;
import com.jaspersoft.studio.property.JSSStyleResolver;
import com.jaspersoft.studio.property.descriptor.JRPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.RotationPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.TextHAlignPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.TextVAlignPropertyDescriptor;
import com.jaspersoft.studio.utils.ModelUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JRTextAlignment;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBaseParagraph;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.StyleResolver;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public abstract class MTextElement
extends MGraphicElementLineBox
implements IRotatable {
    public static final String PARAGRAPH = "paragraph";
    public static final long serialVersionUID = 10200L;
    private static TextHAlignPropertyDescriptor hAlignD;
    private static TextVAlignPropertyDescriptor vAlignD;
    private static RotationPropertyDescriptor rotationD;
    private MFont tFont;
    private MParagraph mParagraph;
    private StyleResolver sr;

    public MTextElement() {
    }

    public MTextElement(ANode parent, int newIndex) {
        super(parent, newIndex);
    }

    public MTextElement(ANode parent, JRDesignElement jrLine, int newIndex) {
        super(parent, jrLine, newIndex);
    }

    @Override
    public HashMap<String, Object> getStylesDescriptors() {
        HashMap<String, Object> result = super.getStylesDescriptors();
        if (this.getValue() == null) {
            return result;
        }
        JRDesignTextElement jrElement = (JRDesignTextElement)this.getValue();
        result.put(PARAGRAPH, this.getPropertyValue(PARAGRAPH));
        result.put("verticalTextAlignment", jrElement.getOwnVerticalTextAlign());
        result.put("horizontalTextAlignment", jrElement.getOwnHorizontalTextAlign());
        result.put("rotation", jrElement.getOwnRotationValue());
        result.put("markup", jrElement.getOwnMarkup());
        result.putAll(this.tFont.getStylesDescriptors());
        return result;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        RWComboBoxPropertyDescriptor markupD = new RWComboBoxPropertyDescriptor("markup", Messages.MTextElement_markup, ModelUtils.getMarkups(this.getJasperConfiguration()), NullEnum.INHERITED);
        markupD.setDescription(Messages.MTextElement_markup_description);
        desc.add((IPropertyDescriptor)markupD);
        hAlignD = new TextHAlignPropertyDescriptor("horizontalTextAlignment", Messages.common_horizontal_alignment, NullEnum.INHERITED);
        hAlignD.setDescription(Messages.MTextElement_horizontal_alignment_description);
        desc.add((IPropertyDescriptor)hAlignD);
        vAlignD = new TextVAlignPropertyDescriptor("verticalTextAlignment", Messages.common_vertical_alignment, NullEnum.INHERITED);
        vAlignD.setDescription(Messages.MTextElement_vertical_alignment_description);
        desc.add((IPropertyDescriptor)vAlignD);
        rotationD = new RotationPropertyDescriptor("rotation", Messages.common_rotation, NullEnum.INHERITED);
        rotationD.setDescription(Messages.MTextElement_rotation_description);
        desc.add((IPropertyDescriptor)rotationD);
        JRPropertyDescriptor paragraph = new JRPropertyDescriptor(PARAGRAPH, "Paragraph");
        desc.add((IPropertyDescriptor)paragraph);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#textElement");
        this.getMFont().createPropertyDescriptors(desc);
        paragraph.setCategory(Messages.MTextElement_text_properties_category);
        markupD.setCategory(Messages.MTextElement_text_properties_category);
        hAlignD.setCategory(Messages.MTextElement_text_properties_category);
        vAlignD.setCategory(Messages.MTextElement_text_properties_category);
        rotationD.setCategory(Messages.MTextElement_text_properties_category);
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("horizontalTextAlignment", new DefaultValue(null, true));
        defaultsMap.put("verticalTextAlignment", new DefaultValue(null, true));
        defaultsMap.put("rotation", new DefaultValue(null, true));
        defaultsMap.putAll(this.getMFont().getDefaultsPropertiesMap());
        return defaultsMap;
    }

    private MFont getMFont() {
        if (this.tFont == null) {
            this.tFont = new MFont((JRFont)this.getValue());
            this.tFont.setJasperConfiguration(this.getJasperConfiguration());
            this.setChildListener(this.tFont);
        }
        return this.tFont;
    }

    @Override
    public Object getPropertyActualValue(Object id) {
        Object val;
        JRDesignTextElement jrElement = (JRDesignTextElement)this.getValue();
        JSSStyleResolver resolver = this.getStyleResolver();
        if (id.equals("markup")) {
            return resolver.getMarkup((JRCommonText)jrElement);
        }
        if (id.equals("horizontalTextAlignment")) {
            if (hAlignD == null) {
                this.getPropertyDescriptors();
            }
            return hAlignD.getIntValue(resolver.getHorizontalTextAlign((JRTextAlignment)jrElement));
        }
        if (id.equals("verticalTextAlignment")) {
            if (vAlignD == null) {
                this.getPropertyDescriptors();
            }
            return vAlignD.getIntValue(resolver.getVerticalTextAlign((JRTextAlignment)jrElement));
        }
        if (id.equals("rotation")) {
            if (rotationD == null) {
                this.getPropertyDescriptors();
            }
            return rotationD.getIntValue(resolver.getRotationValue((JRCommonText)jrElement));
        }
        if (this.getMFont() != null && (val = this.tFont.getPropertyActualValue(id)) != null) {
            return val;
        }
        return super.getPropertyActualValue(id);
    }

    @Override
    public Object getPropertyValue(Object id) {
        Object val;
        JRDesignTextElement jrElement = (JRDesignTextElement)this.getValue();
        if (id.equals("markup")) {
            return jrElement.getOwnMarkup();
        }
        if (id.equals(PARAGRAPH)) {
            if (this.mParagraph == null) {
                this.mParagraph = new MParagraph((ANode)this, (JRBaseParagraph)jrElement.getParagraph());
                this.setChildListener(this.mParagraph);
            }
            return this.mParagraph;
        }
        if (id.equals("horizontalTextAlignment")) {
            HorizontalTextAlignEnum ownValue;
            if (hAlignD == null) {
                this.getPropertyDescriptors();
            }
            if ((ownValue = jrElement.getOwnHorizontalTextAlign()) == null) {
                return null;
            }
            return hAlignD.getIntValue(ownValue);
        }
        if (id.equals("verticalTextAlignment")) {
            VerticalTextAlignEnum ownValue;
            if (vAlignD == null) {
                this.getPropertyDescriptors();
            }
            if ((ownValue = jrElement.getOwnVerticalTextAlign()) == null) {
                return null;
            }
            return vAlignD.getIntValue(ownValue);
        }
        if (id.equals("rotation")) {
            RotationEnum ownValue;
            if (rotationD == null) {
                this.getPropertyDescriptors();
            }
            if ((ownValue = jrElement.getOwnRotationValue()) == null) {
                return null;
            }
            return rotationD.getIntValue(ownValue);
        }
        if (this.getMFont() != null && (val = this.tFont.getPropertyValue(id)) != null) {
            return val;
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        JRDesignTextElement jrElement = (JRDesignTextElement)this.getValue();
        if (id.equals("markup")) {
            jrElement.setMarkup((String)value);
        } else if (id.equals("horizontalTextAlignment")) {
            jrElement.setHorizontalTextAlign((HorizontalTextAlignEnum)hAlignD.getEnumValue(value));
        } else if (id.equals("verticalTextAlignment")) {
            VerticalTextAlignEnum va = (VerticalTextAlignEnum)vAlignD.getEnumValue(value);
            jrElement.setVerticalTextAlign(va);
        } else if (id.equals("rotation")) {
            jrElement.setRotation((RotationEnum)rotationD.getEnumValue(value));
        }
        this.getMFont().setPropertyValue(id, value);
        super.setPropertyValue(id, value);
    }

    @Override
    public HashSet<String> generateGraphicalProperties() {
        HashSet<String> result = super.generateGraphicalProperties();
        result.add("horizontalTextAlignment");
        result.add("rotation");
        result.add("lineSpacing");
        result.add("lineSpacingSize");
        result.add("firstLineIndent");
        result.add("leftIndent");
        result.add("rightIndent");
        result.add("spacingBefore");
        result.add("spacingAfter");
        result.add("tabStopWidth");
        result.add("verticalTextAlignment");
        result.add("isBold");
        result.add("isUnderline");
        result.add("isStrikeThrough");
        result.add("isItalic");
        result.add("fontSize");
        result.add("fontName");
        return result;
    }

    @Override
    public void trasnferProperties(JRElement target) {
        super.trasnferProperties(target);
        JRDesignTextElement jrSource = (JRDesignTextElement)this.getValue();
        JRDesignTextElement jrTarget = (JRDesignTextElement)target;
        jrTarget.setHorizontalTextAlign(jrSource.getOwnHorizontalTextAlign());
        jrTarget.setVerticalTextAlign(jrSource.getOwnVerticalTextAlign());
        jrTarget.setMarkup(this.getStringClone(jrSource.getOwnMarkup()));
        jrTarget.setRotation(jrSource.getOwnRotationValue());
        jrTarget.setBold(jrSource.isOwnBold());
        jrTarget.setItalic(jrSource.isOwnItalic());
        jrTarget.setUnderline(jrSource.isOwnUnderline());
        jrTarget.setStrikeThrough(jrSource.isOwnStrikeThrough());
        jrTarget.setPdfEmbedded(jrSource.isOwnPdfEmbedded());
        jrTarget.setFontName(this.getStringClone(jrSource.getOwnFontName()));
        jrTarget.setFontSize(jrSource.getOwnFontsize());
        jrTarget.setPdfFontName(this.getStringClone(jrSource.getOwnPdfFontName()));
        jrTarget.setPdfEncoding(this.getStringClone(jrSource.getOwnPdfEncoding()));
        JRBaseParagraph jrTargetParagraph = (JRBaseParagraph)jrTarget.getParagraph();
        JRBaseParagraph jrSourceParagraph = (JRBaseParagraph)jrSource.getParagraph();
        if (jrTargetParagraph != null && jrSourceParagraph != null) {
            jrTargetParagraph.setLineSpacing(jrSourceParagraph.getOwnLineSpacing());
            jrTargetParagraph.setLineSpacingSize(jrSourceParagraph.getOwnLineSpacingSize());
            jrTargetParagraph.setFirstLineIndent(jrSourceParagraph.getOwnFirstLineIndent());
            jrTargetParagraph.setLeftIndent(jrSourceParagraph.getOwnLeftIndent());
            jrTargetParagraph.setRightIndent(jrSourceParagraph.getOwnRightIndent());
            jrTargetParagraph.setSpacingAfter(jrSourceParagraph.getOwnSpacingAfter());
            jrTargetParagraph.setSpacingBefore(jrTargetParagraph.getOwnSpacingBefore());
            jrTargetParagraph.setTabStopWidth(jrSourceParagraph.getOwnTabStopWidth());
        }
    }

    @Override
    protected List<ValidationError> doValidation() {
        List<ValidationError> errors = super.doValidation();
        JRFont font = (JRFont)this.getValue();
        if (font.getOwnPdfFontName() != null || font.isOwnPdfEmbedded() != null && font.isOwnPdfEmbedded().booleanValue()) {
            if (errors == null) {
                errors = new ArrayList<ValidationError>();
            }
            ArrayList<String> props = new ArrayList<String>();
            props.add("isPdfEmbedded");
            errors.add(new ValidationError(props, Messages.MTextElement_pdfError));
        } else {
            JRStyle baseStyle;
            String inheritedFromStyle;
            if (this.sr == null) {
                this.sr = new StyleResolver((JasperReportsContext)this.getJasperConfiguration());
            }
            if ((inheritedFromStyle = this.getPdfFontName(baseStyle = this.sr.getBaseStyle((JRStyleContainer)font))) != null) {
                if (errors == null) {
                    errors = new ArrayList<ValidationError>();
                }
                ArrayList<String> props = new ArrayList<String>();
                props.add("style");
                errors.add(new ValidationError(props, MessageFormat.format(Messages.MTextElement_pdfErrorStyle, inheritedFromStyle)));
            }
        }
        return errors;
    }

    private String getPdfFontName(JRStyle style) {
        JRStyle baseStyle;
        if (style == null) {
            return null;
        }
        String ownPdfFontName = style.getOwnPdfFontName();
        if (ownPdfFontName != null || style.isOwnPdfEmbedded() != null && style.isOwnPdfEmbedded().booleanValue()) {
            return style.getName();
        }
        if (this.sr == null) {
            this.sr = new StyleResolver((JasperReportsContext)this.getJasperConfiguration());
        }
        if ((baseStyle = this.sr.getBaseStyle(style)) == null) {
            return null;
        }
        String pdfFontName = this.getPdfFontName(baseStyle);
        if (pdfFontName != null || baseStyle.isOwnPdfEmbedded() != null && baseStyle.isOwnPdfEmbedded().booleanValue()) {
            return baseStyle.getName();
        }
        return null;
    }
}

