/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.text;

import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.MHyperLink;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import com.jaspersoft.studio.model.text.MTextElement;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.JSSStyleResolver;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.NullCheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.pattern.PatternPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.SpinnerPropertyDescriptor;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.TextAdjustEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MTextField
extends MTextElement {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private MHyperLink mHyperLink;
    private static NamedEnumPropertyDescriptor<EvaluationTimeEnum> evaluationTimeD;
    private static NamedEnumPropertyDescriptor<TextAdjustEnum> textAdjustD;
    private IPropertyDescriptor[] descriptors;
    private RWComboBoxPropertyDescriptor evalGroupD;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("textfield");
        }
        return iconDescriptor;
    }

    public MTextField() {
    }

    public MTextField(ANode parent, JRTextField jrStaticText, int newIndex) {
        super(parent, newIndex);
        this.setValue(jrStaticText);
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    @Override
    protected void setGroupItems(String[] items) {
        super.setGroupItems(items);
        if (this.evalGroupD != null) {
            this.evalGroupD.setItems(items);
        }
    }

    @Override
    public JRDataset getElementDataset() {
        return this.getElementDataset(this);
    }

    private JRDataset getElementDataset(ANode node) {
        JRDesignDatasetRun datasetRun;
        APropertyNode pnode;
        MDatasetRun mdataset;
        if (node instanceof APropertyNode && (mdataset = (MDatasetRun)(pnode = (APropertyNode)node).getPropertyValue("datasetRun")) != null && (datasetRun = mdataset.getValue()) != null) {
            String dsname = datasetRun.getDatasetName();
            return (JRDataset)this.getJasperDesign().getDatasetMap().get(dsname);
        }
        ANode parent = node.getParent();
        if (parent != null) {
            return this.getElementDataset(parent);
        }
        if (this.getJasperDesign() != null) {
            return this.getJasperDesign().getMainDataset();
        }
        return null;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        evaluationTimeD = new NamedEnumPropertyDescriptor<EvaluationTimeEnum>("evaluationTime", Messages.common_evaluation_time, EvaluationTimeEnum.AUTO, NullEnum.NOTNULL);
        evaluationTimeD.setDescription(Messages.MTextField_evaluation_time_description);
        desc.add((IPropertyDescriptor)evaluationTimeD);
        textAdjustD = new NamedEnumPropertyDescriptor<TextAdjustEnum>("textAdjust", Messages.MTextField_MTextField_text_adjust_label, TextAdjustEnum.CUT_TEXT, NullEnum.NOTNULL);
        textAdjustD.setDescription(Messages.MTextField_MTextField_text_adjust_description);
        desc.add((IPropertyDescriptor)textAdjustD);
        this.evalGroupD = new RWComboBoxPropertyDescriptor("evaluationGroup", Messages.MTextField_evaluation_group, new String[]{""}, NullEnum.NULL);
        this.evalGroupD.setDescription(Messages.MTextField_evaluation_group_description);
        desc.add((IPropertyDescriptor)this.evalGroupD);
        NullCheckBoxPropertyDescriptor blankWhenNullD = new NullCheckBoxPropertyDescriptor("isBlankWhenNull", Messages.common_blank_when_null);
        blankWhenNullD.setDescription(Messages.MTextField_blank_when_null_description);
        desc.add((IPropertyDescriptor)blankWhenNullD);
        JRExpressionPropertyDescriptor exprD = new JRExpressionPropertyDescriptor("expression", Messages.common_expression);
        exprD.setDescription(Messages.MTextField_expression_description);
        desc.add((IPropertyDescriptor)exprD);
        exprD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#textFieldExpression"));
        JRExpressionPropertyDescriptor anchorNameExp = new JRExpressionPropertyDescriptor("anchorNameExpression", Messages.MTextField_anchorNameLabel);
        anchorNameExp.setDescription(Messages.MTextField_anchorNameDescription);
        desc.add((IPropertyDescriptor)anchorNameExp);
        JRExpressionPropertyDescriptor bookmarkLevelExp = new JRExpressionPropertyDescriptor("bookmarkLevelExpression", Messages.MTextField_bookmarkLevelExpression);
        bookmarkLevelExp.setDescription(Messages.MTextField_bookmarkLevelExpressionDescription);
        desc.add((IPropertyDescriptor)bookmarkLevelExp);
        SpinnerPropertyDescriptor bookmarkLevel = new SpinnerPropertyDescriptor("bookmarkLevel", Messages.MTextField_bookmarkLevelLabel);
        bookmarkLevel.setDescription(Messages.MTextField_bookmarkLevelDescription);
        bookmarkLevel.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#chart_bookmarkLevel"));
        desc.add((IPropertyDescriptor)bookmarkLevel);
        PatternPropertyDescriptor patternD = new PatternPropertyDescriptor("pattern", Messages.common_pattern);
        patternD.setDescription(Messages.MTextField_pattern_description);
        desc.add((IPropertyDescriptor)patternD);
        JRExpressionPropertyDescriptor pexprD = new JRExpressionPropertyDescriptor("patternExpression", Messages.MTextField_patternExpressionTitle);
        pexprD.setDescription("Pattern expression");
        desc.add((IPropertyDescriptor)pexprD);
        pexprD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#patternExpression"));
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#textField");
        if (this.mHyperLink == null) {
            this.mHyperLink = new MHyperLink(null);
        }
        this.mHyperLink.createPropertyDescriptors(desc);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#textField");
        patternD.setCategory(Messages.MTextField_textfield_category);
        exprD.setCategory(Messages.MTextField_textfield_category);
        evaluationTimeD.setCategory(Messages.MTextField_textfield_category);
        textAdjustD.setCategory(Messages.MTextField_textfield_category);
        this.evalGroupD.setCategory(Messages.MTextField_textfield_category);
        blankWhenNullD.setCategory(Messages.MTextField_textfield_category);
        pexprD.setCategory(Messages.MTextField_textfield_category);
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("evaluationTime", new DefaultValue(EvaluationTimeEnum.NOW, false));
        defaultsMap.put("textAdjust", new DefaultValue(TextAdjustEnum.CUT_TEXT, false));
        defaultsMap.put("isBlankWhenNull", new DefaultValue(Boolean.FALSE, false));
        defaultsMap.put("pattern", new DefaultValue(null, true));
        defaultsMap.putAll(new MHyperLink(null).getDefaultsPropertiesMap());
        return defaultsMap;
    }

    @Override
    public Object getPropertyActualValue(Object id) {
        JRDesignTextField jrElement = (JRDesignTextField)this.getValue();
        JSSStyleResolver resolver = this.getStyleResolver();
        if (id.equals("isBlankWhenNull")) {
            return resolver.isBlankWhenNull((JRTextField)jrElement);
        }
        if (id.equals("pattern")) {
            return resolver.getPattern((JRTextField)jrElement);
        }
        return super.getPropertyActualValue(id);
    }

    @Override
    public Object getPropertyValue(Object id) {
        JRDesignTextField jrElement = (JRDesignTextField)this.getValue();
        if (id.equals("expression")) {
            return ExprUtil.getExpression(jrElement.getExpression());
        }
        if (id.equals("patternExpression")) {
            return ExprUtil.getExpression(jrElement.getPatternExpression());
        }
        if (id.equals("evaluationTime")) {
            return jrElement.getEvaluationTimeValue();
        }
        if (id.equals("textAdjust")) {
            return textAdjustD.getIntValue(jrElement.getTextAdjust());
        }
        if (id.equals("isBlankWhenNull")) {
            return jrElement.isOwnBlankWhenNull();
        }
        if (id.equals("pattern")) {
            return jrElement.getOwnPattern();
        }
        if (id.equals("evaluationGroup")) {
            if (jrElement.getEvaluationGroup() != null) {
                return jrElement.getEvaluationGroup().getName();
            }
            return "";
        }
        if (id.equals("linkTarget")) {
            return jrElement.getLinkTarget();
        }
        if (id.equals("hyperlinkType")) {
            return jrElement.getLinkType();
        }
        if (id.equals("hyperlinkParameters")) {
            return jrElement.getHyperlinkParameters();
        }
        if (id.equals("hyperlinkAnchorExpression")) {
            return ExprUtil.getExpression(jrElement.getHyperlinkAnchorExpression());
        }
        if (id.equals("hyperlinkPageExpression")) {
            return ExprUtil.getExpression(jrElement.getHyperlinkPageExpression());
        }
        if (id.equals("hyperlinkReferenceExpression")) {
            return ExprUtil.getExpression(jrElement.getHyperlinkReferenceExpression());
        }
        if (id.equals("hyperlinkTooltipExpression")) {
            return ExprUtil.getExpression(jrElement.getHyperlinkTooltipExpression());
        }
        if (id.equals("hyperlinkWhenExpression")) {
            return ExprUtil.getExpression(jrElement.getHyperlinkWhenExpression());
        }
        if (id.equals("anchorNameExpression")) {
            return ExprUtil.getExpression(jrElement.getAnchorNameExpression());
        }
        if (id.equals("bookmarkLevelExpression")) {
            return ExprUtil.getExpression(jrElement.getBookmarkLevelExpression());
        }
        if (id.equals("bookmarkLevel")) {
            return jrElement.getBookmarkLevel();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        JRDesignTextField jrElement = (JRDesignTextField)this.getValue();
        if (id.equals("evaluationTime")) {
            EvaluationTimeEnum evalTime = (EvaluationTimeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])EvaluationTimeEnum.values(), (Object)value);
            jrElement.setEvaluationTime(evalTime);
            if (evalTime != null && !evalTime.equals((Object)EvaluationTimeEnum.GROUP)) {
                jrElement.setEvaluationGroup(null);
            }
        } else if (id.equals("textAdjust")) {
            jrElement.setTextAdjust(textAdjustD.getEnumValue(value));
        } else if (id.equals("evaluationGroup")) {
            jrElement.setEvaluationGroup(ModelUtils.getGroupForProperty(value, (JRDesignDataset)this.getElementDataset()));
        } else if (id.equals("expression")) {
            jrElement.setExpression(ExprUtil.setValues(jrElement.getExpression(), value));
            JRDesignExpression expression = (JRDesignExpression)jrElement.getExpression();
            if (expression != null) {
                this.removeListeners(expression);
                expression.getEventSupport().addPropertyChangeListener((PropertyChangeListener)new ExpressionNameChanged(this));
            }
        } else if (id.equals("patternExpression")) {
            jrElement.setPatternExpression(ExprUtil.setValues(jrElement.getPatternExpression(), value));
        } else if (id.equals("isBlankWhenNull")) {
            jrElement.setBlankWhenNull((Boolean)value);
        } else if (id.equals("pattern")) {
            if (Misc.isNullOrEmpty((String)((String)value))) {
                value = null;
            }
            jrElement.setPattern((String)value);
        } else if (id.equals("linkTarget")) {
            jrElement.setLinkTarget((String)value);
        } else if (id.equals("hyperlinkType")) {
            jrElement.setLinkType((String)value);
        } else if (id.equals("hyperlinkAnchorExpression")) {
            jrElement.setHyperlinkAnchorExpression(ExprUtil.setValues(jrElement.getHyperlinkAnchorExpression(), value));
        } else if (id.equals("hyperlinkPageExpression")) {
            jrElement.setHyperlinkPageExpression(ExprUtil.setValues(jrElement.getHyperlinkPageExpression(), value));
        } else if (id.equals("hyperlinkReferenceExpression")) {
            jrElement.setHyperlinkReferenceExpression(ExprUtil.setValues(jrElement.getHyperlinkReferenceExpression(), value));
        } else if (id.equals("hyperlinkWhenExpression")) {
            jrElement.setHyperlinkWhenExpression(ExprUtil.setValues(jrElement.getHyperlinkWhenExpression(), value));
        } else if (id.equals("hyperlinkTooltipExpression")) {
            jrElement.setHyperlinkTooltipExpression(ExprUtil.setValues(jrElement.getHyperlinkTooltipExpression(), value));
        } else if (id.equals("anchorNameExpression")) {
            jrElement.setAnchorNameExpression(ExprUtil.setValues(jrElement.getAnchorNameExpression(), value));
        } else if (id.equals("bookmarkLevelExpression")) {
            jrElement.setBookmarkLevelExpression(ExprUtil.setValues(jrElement.getBookmarkLevelExpression(), value));
        } else if (id.equals("bookmarkLevel")) {
            jrElement.setBookmarkLevel(value != null ? Integer.parseInt(value.toString()) : 0);
        } else if (id.equals("hyperlinkParameters")) {
            int n;
            int n2;
            JRHyperlinkParameter[] jRHyperlinkParameterArray;
            JRHyperlinkParameter[] oldParameters = jrElement.getHyperlinkParameters();
            JRHyperlinkParameter[] newParameters = (JRHyperlinkParameter[])value;
            if (oldParameters != null) {
                jRHyperlinkParameterArray = oldParameters;
                n2 = oldParameters.length;
                n = 0;
                while (n < n2) {
                    JRHyperlinkParameter prm = jRHyperlinkParameterArray[n];
                    jrElement.removeHyperlinkParameter(prm);
                    ++n;
                }
            }
            jRHyperlinkParameterArray = newParameters;
            n2 = newParameters.length;
            n = 0;
            while (n < n2) {
                JRHyperlinkParameter param = jRHyperlinkParameterArray[n];
                jrElement.addHyperlinkParameter(param);
                ++n;
            }
        } else {
            super.setPropertyValue(id, value);
        }
    }

    private void removeListeners(JRDesignExpression expression) {
        ArrayList<PropertyChangeListener> listenersToRemove = new ArrayList<PropertyChangeListener>();
        PropertyChangeListener[] propertyChangeListenerArray = expression.getEventSupport().getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener listener = propertyChangeListenerArray[n2];
            if (listener instanceof ExpressionNameChanged) {
                listenersToRemove.add(listener);
            }
            ++n2;
        }
        for (PropertyChangeListener listener : listenersToRemove) {
            expression.getEventSupport().removePropertyChangeListener(listener);
        }
    }

    @Override
    public void setValue(Object value) {
        JRDesignExpression expression;
        JRDesignTextField jrElement = (JRDesignTextField)this.getValue();
        if (jrElement != null && (expression = (JRDesignExpression)jrElement.getExpression()) != null) {
            this.removeListeners(expression);
        }
        super.setValue(value);
        jrElement = (JRDesignTextField)this.getValue();
        if (jrElement != null && (expression = (JRDesignExpression)jrElement.getExpression()) != null) {
            this.removeListeners(expression);
            expression.getEventSupport().addPropertyChangeListener((PropertyChangeListener)new ExpressionNameChanged(this));
        }
    }

    public JRDesignTextField createJRElement(JasperDesign jasperDesign, boolean applyDefault) {
        JRDesignTextField jrDesignTextField = new JRDesignTextField((JRDefaultStyleProvider)jasperDesign);
        jrDesignTextField.setX(0);
        jrDesignTextField.setY(0);
        jrDesignTextField.setExpression((JRExpression)new JRDesignExpression("\"".concat(Messages.MTextField_common_text_field).concat("\"")));
        if (applyDefault) {
            DefaultManager.INSTANCE.applyDefault(this.getClass(), (JRElement)jrDesignTextField);
        }
        return jrDesignTextField;
    }

    @Override
    public String getDisplayText() {
        JRTextField jrTextField;
        String p = this.getElementNameProperty();
        if (!Misc.isNullOrEmpty((String)p)) {
            return p;
        }
        if (this.getValue() != null && (jrTextField = (JRTextField)this.getValue()).getExpression() != null) {
            return jrTextField.getExpression().getText();
        }
        return MTextField.getIconDescriptor().getTitle();
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MTextField.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        JRTextField jrTextField;
        if (this.getValue() != null && (jrTextField = (JRTextField)this.getValue()).getExpression() != null) {
            return String.valueOf(MTextField.getIconDescriptor().getTitle()) + ": " + jrTextField.getExpression().getText();
        }
        return MTextField.getIconDescriptor().getToolTip();
    }

    @Override
    public HashSet<String> generateGraphicalProperties() {
        HashSet<String> result = super.generateGraphicalProperties();
        result.add("expression");
        return result;
    }

    @Override
    public void trasnferProperties(JRElement target) {
        super.trasnferProperties(target);
        JRDesignTextField jrSource = (JRDesignTextField)this.getValue();
        JRDesignTextField jrTarget = (JRDesignTextField)target;
        jrTarget.setBlankWhenNull(jrSource.isOwnBlankWhenNull());
        jrTarget.setPattern(this.getStringClone(jrSource.getOwnPattern()));
        jrTarget.setTextAdjust(jrSource.getTextAdjust());
    }

    @Override
    public HashMap<String, Object> getStylesDescriptors() {
        HashMap<String, Object> result = super.getStylesDescriptors();
        if (this.getValue() == null) {
            return result;
        }
        JRDesignTextField jrElement = (JRDesignTextField)this.getValue();
        result.put("pattern", jrElement.getOwnPattern());
        result.put("isBlankWhenNull", jrElement.isBlankWhenNull());
        return result;
    }

    private class ExpressionNameChanged
    implements PropertyChangeListener {
        private MTextField element;

        public ExpressionNameChanged(MTextField element) {
            this.element = element;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("text".equals(evt.getPropertyName()) && this.element != null) {
                this.element.getValue().getEventSupport().firePropertyChange("expression", evt.getOldValue(), evt.getNewValue());
            }
        }
    }
}

