/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.util;

import com.jaspersoft.studio.property.infoList.ElementDescription;
import com.jaspersoft.studio.property.itemproperty.desc.ItemPropertyDescriptor;
import com.jaspersoft.studio.utils.ExpressionInterpreter;
import java.util.List;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class ItemPropertyUtil {
    public static ItemProperty getProperty(List<ItemProperty> items, String name) {
        if (items != null) {
            for (ItemProperty it : items) {
                if (!it.getName().equals(name)) continue;
                return it;
            }
        }
        return null;
    }

    public static boolean hasValue(List<ItemProperty> items, String name) {
        ItemProperty p = ItemPropertyUtil.getProperty(items, name);
        return p != null && (!Misc.isNullOrEmpty((String)p.getValue()) || p.getValueExpression() != null && !Misc.isNullOrEmpty((String)p.getValueExpression().getText()));
    }

    public static void setProperty(StandardItem item, String key, ItemProperty ip) {
        StandardItemProperty sp;
        List props = item.getProperties();
        if (props != null && (sp = (StandardItemProperty)ItemPropertyUtil.getProperty(props, key)) != null) {
            if (ip == null) {
                item.removeItemProperty((ItemProperty)sp);
            } else {
                sp.setValue(ip.getValue());
                sp.setValueExpression(ip.getValueExpression());
            }
            return;
        }
        item.addItemProperty(ip);
    }

    public static void setupElementDescriptors(List<ElementDescription> elementDescriptions, List<IPropertyDescriptor> descriptors) {
        for (IPropertyDescriptor pd : descriptors) {
            if (!(pd instanceof ItemPropertyDescriptor)) continue;
            ((ItemPropertyDescriptor)pd).setElementDescriptions(elementDescriptions);
        }
    }

    public static Object getItemPropertyValue(StandardItemProperty ip, ExpressionInterpreter expIntr) {
        if (ip == null) {
            return null;
        }
        if (ip.getValueExpression() != null && expIntr != null) {
            return expIntr.interpretExpression(Misc.nvl((String)ip.getValueExpression().getText()));
        }
        if (ip.getValue() != null) {
            return ip.getValue();
        }
        return null;
    }

    public static Boolean getItemPropertyBoolean(StandardItemProperty ip, ExpressionInterpreter expIntr) {
        Object obj = ItemPropertyUtil.getItemPropertyValue(ip, expIntr);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String && !Misc.isNullOrEmpty((String)((String)obj))) {
            try {
                obj = Boolean.parseBoolean((String)obj);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return null;
    }

    public static String getItemPropertyString(StandardItemProperty ip, ExpressionInterpreter expIntr) {
        Object obj = ItemPropertyUtil.getItemPropertyValue(ip, expIntr);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public static Double getItemPropertyDouble(StandardItemProperty ip, ExpressionInterpreter expIntr) {
        Object obj = ItemPropertyUtil.getItemPropertyValue(ip, expIntr);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String && !Misc.isNullOrEmpty((String)((String)obj))) {
            try {
                obj = Double.parseDouble((String)obj);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        return null;
    }

    public static Integer getItemPropertyInteger(StandardItemProperty ip, ExpressionInterpreter expIntr) {
        Object obj = ItemPropertyUtil.getItemPropertyValue(ip, expIntr);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String && !Misc.isNullOrEmpty((String)((String)obj))) {
            try {
                obj = Integer.parseInt((String)obj);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return null;
    }
}

