/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.util;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NodeIconDescriptor
implements IIconDescriptor {
    private String ICON_TITLE = "<not-defined>";
    private String ICON_DESCRIPTION = "<not-defined>";
    private String ICON_TOOLTIP = "<not-defined>";
    private String ICON_16 = "icons/resources/genericelement-16.png";
    private String ICON_32 = "icons/resources/genericelement-32.png";
    private AbstractUIPlugin plugin;
    private static ResourceBundle resourceBundleIcons;

    public NodeIconDescriptor(String name) {
        this(name, (AbstractUIPlugin)JaspersoftStudioPlugin.getInstance());
    }

    public NodeIconDescriptor(String name, AbstractUIPlugin plugin) {
        this.plugin = plugin;
        if (name != null && !name.isEmpty()) {
            this.ICON_TITLE = this.getFromBundle(String.valueOf(name) + ".title", this.ICON_TITLE);
            this.ICON_DESCRIPTION = this.getFromBundle(String.valueOf(name) + ".description", this.ICON_DESCRIPTION);
            this.ICON_TOOLTIP = this.getFromBundle(String.valueOf(name) + ".description", this.ICON_TOOLTIP);
            this.ICON_16 = this.getFromBundle(String.valueOf(name) + ".icon16", this.ICON_16);
            this.ICON_32 = this.getFromBundle(String.valueOf(name) + ".icon32", this.ICON_32);
        }
    }

    public ResourceBundle getResourceBundleIcons() {
        return resourceBundleIcons;
    }

    public void setResourceBundleIcons(ResourceBundle resourceBundleIcons) {
        NodeIconDescriptor.resourceBundleIcons = resourceBundleIcons;
    }

    public ResourceBundle getResourceBundle(AbstractUIPlugin plugin) {
        if (this.getResourceBundleIcons() == null) {
            ResourceBundle inputStream = null;
            inputStream = ResourceBundle.getBundle("resources/icons", Locale.getDefault(), plugin.getClass().getClassLoader());
            this.setResourceBundleIcons(inputStream);
        }
        return this.getResourceBundleIcons();
    }

    private String getFromBundle(String key, String def) {
        String res = def;
        try {
            res = this.getResourceBundle(this.plugin).getString(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public NodeIconDescriptor(String title, String description, String toolTip, String icon16, String icon32) {
        this.ICON_TITLE = title;
        this.ICON_DESCRIPTION = description;
        this.ICON_TOOLTIP = toolTip;
        this.ICON_16 = icon16;
        this.ICON_32 = icon32;
    }

    @Override
    public String getDescription() {
        return this.ICON_DESCRIPTION;
    }

    @Override
    public ImageDescriptor getIcon16() {
        if (this.plugin != null) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)this.plugin.getBundle().getSymbolicName(), (String)this.ICON_16);
        }
        return JaspersoftStudioPlugin.getInstance().getImageDescriptor(this.ICON_16);
    }

    public String getIcon16Path() {
        return this.ICON_16;
    }

    @Override
    public ImageDescriptor getIcon32() {
        if (this.plugin != null) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)this.plugin.getBundle().getSymbolicName(), (String)this.ICON_32);
        }
        return JaspersoftStudioPlugin.getInstance().getImageDescriptor(this.ICON_32);
    }

    public String getIcon32Path() {
        return this.ICON_32;
    }

    @Override
    public String getTitle() {
        return this.ICON_TITLE;
    }

    @Override
    public String getToolTip() {
        return this.ICON_TOOLTIP;
    }
}

