/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.variable;

import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.IDragable;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.model.variable.VariableNameValidator;
import com.jaspersoft.studio.property.descriptor.classname.ClassTypeComboCellEditor;
import com.jaspersoft.studio.property.descriptor.classname.NClassTypePropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.combo.RWComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.JSSValidatedTextPropertyDescriptor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.property.section.widgets.SPClassTypeCombo;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MVariableSystem
extends APropertyNode
implements IDragable {
    public static final long serialVersionUID = 10200L;
    private static IIconDescriptor iconDescriptor;
    private static IPropertyDescriptor[] descriptors;
    private static VariableNameValidator validator;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("variable");
        }
        return iconDescriptor;
    }

    public MVariableSystem() {
        this.setEditable(false);
    }

    public MVariableSystem(ANode parent, JRDesignVariable jrVariable, int newIndex) {
        super(parent, newIndex);
        this.setEditable(false);
        this.setValue(jrVariable);
    }

    public JRDesignVariable getValue() {
        return (JRDesignVariable)super.getValue();
    }

    @Override
    public Color getForeground() {
        return UIUtils.getSystemColor((int)39);
    }

    @Override
    public String getDisplayText() {
        return this.getValue().getName();
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MVariableSystem.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return MVariableSystem.getIconDescriptor().getToolTip();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    @Override
    protected void postDescriptors(IPropertyDescriptor[] descriptors) {
        super.postDescriptors(descriptors);
        this.updateNameValidator();
    }

    protected void updateNameValidator() {
        if (validator == null) {
            validator = new VariableNameValidator();
        }
        validator.setTargetNode(this);
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        this.updateNameValidator();
        JSSValidatedTextPropertyDescriptor nameD = new JSSValidatedTextPropertyDescriptor((Object)"name", Messages.common_name, validator);
        nameD.setDescription(Messages.MVariableSystem_name_description);
        desc.add((IPropertyDescriptor)nameD);
        NClassTypePropertyDescriptor classD = new NClassTypePropertyDescriptor((Object)"valueClassName", Messages.common_value_class_name, ClassTypeComboCellEditor.DEFAULT_ITEMS){

            @Override
            public ASPropertyWidget<RWComboBoxPropertyDescriptor> createWidget(Composite parent, AbstractSection section) {
                SPClassTypeCombo<RWComboBoxPropertyDescriptor> classNameWidget = new SPClassTypeCombo<RWComboBoxPropertyDescriptor>(parent, section, this);
                classNameWidget.setClassesOfType(this.classes);
                classNameWidget.setReadOnly(this.readOnly);
                return classNameWidget;
            }
        };
        classD.setDescription(Messages.MVariableSystem_value_class_name_description);
        desc.add((IPropertyDescriptor)classD);
        classD.setHelpRefBuilder(new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#variable_class"));
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put("valueClassName", new DefaultValue("java.lang.String", false));
        return defaultsMap;
    }

    public Object getPropertyValue(Object id) {
        JRDesignVariable jrVariable = this.getValue();
        if (id.equals("name")) {
            return jrVariable.getName();
        }
        if (id.equals("valueClassName")) {
            return jrVariable.getValueClassName();
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName())) {
            JRDesignDataset d = ModelUtils.getDataset(this);
            JRDesignVariable jrVariable = this.getValue();
            if (d != null) {
                d.getVariablesMap().remove(evt.getOldValue());
                d.getVariablesMap().put(jrVariable.getName(), jrVariable);
            }
        }
        super.propertyChange(evt);
    }

    public void setPropertyValue(Object id, Object value) {
        if (!this.isEditable()) {
            return;
        }
        JRDesignVariable jrVariable = this.getValue();
        if (id.equals("name")) {
            if (!value.equals("")) {
                JRDesignDataset d = ModelUtils.getDataset(this);
                for (JRVariable p : d.getVariablesList()) {
                    if (p == jrVariable || !p.getName().equals(value)) continue;
                    return;
                }
                jrVariable.setName((String)value);
            }
        } else if (id.equals("valueClassName")) {
            jrVariable.setValueClassName((String)value);
        }
    }

    public static JRDesignVariable createJRVariable(JasperDesign jrDesign) {
        JRDesignVariable jrDesignVariable = new JRDesignVariable();
        jrDesignVariable.setSystemDefined(true);
        jrDesignVariable.setName(ModelUtils.getDefaultName(jrDesign.getVariablesMap(), "Variable_"));
        return jrDesignVariable;
    }
}

