/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.variable.command;

import com.jaspersoft.studio.model.command.ADatasetObjectDeleteCommand;
import com.jaspersoft.studio.model.variable.MVariable;
import com.jaspersoft.studio.model.variable.MVariables;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;

public class DeleteVariableCommand
extends ADatasetObjectDeleteCommand {
    private JRDesignVariable jrVariable;
    private JRSortField jrSortField;
    private int oldSortFieldindex = 0;

    public DeleteVariableCommand(MVariables destNode, MVariable srcNode) {
        this(srcNode.getJasperConfiguration(), destNode.getValue(), srcNode.getValue(), null);
    }

    public DeleteVariableCommand(JasperReportsConfiguration jContext, JRDesignDataset destNode, JRDesignVariable srcNode, Boolean canceled) {
        super(canceled);
        this.jContext = jContext;
        this.jd = jContext.getJasperDesign();
        this.jrDataset = destNode;
        this.jrVariable = srcNode;
        this.objectName = "$V{" + this.jrVariable.getName() + "}";
    }

    public void execute() {
        this.elementPosition = this.jrDataset.getVariablesList().indexOf(this.jrVariable);
        this.jrDataset.removeVariable((JRVariable)this.jrVariable);
        if (this.jrSortField == null) {
            for (JRSortField sf : this.jrDataset.getSortFieldsList()) {
                if (!sf.getType().equals((Object)SortFieldTypeEnum.VARIABLE) || !sf.getName().equals(this.jrVariable.getName())) continue;
                this.jrSortField = sf;
                break;
            }
        }
        if (this.jrSortField != null) {
            this.oldSortFieldindex = this.jrDataset.getSortFieldsList().indexOf(this.jrSortField);
            this.jrDataset.removeSortField(this.jrSortField);
        }
    }

    public boolean canUndo() {
        return this.jrDataset != null && this.jrVariable != null;
    }

    public void undo() {
        if (this.canceled == null || this.canceled.booleanValue()) {
            return;
        }
        try {
            if (this.elementPosition < 0 || this.elementPosition > this.jrDataset.getVariablesList().size()) {
                this.jrDataset.addVariable(this.jrVariable);
            } else {
                this.jrDataset.addVariable(this.elementPosition, this.jrVariable);
            }
            if (this.jrSortField != null) {
                if (this.oldSortFieldindex >= 0 && this.oldSortFieldindex < this.jrDataset.getSortFieldsList().size()) {
                    this.jrDataset.addSortField(this.oldSortFieldindex, this.jrSortField);
                } else {
                    this.jrDataset.addSortField(this.jrSortField);
                }
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean isOwnExpression(JRExpression expr) {
        return this.jrVariable.getExpression() == expr || this.jrVariable.getInitialValueExpression() == expr;
    }
}

