/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.model.variable.command;

import com.jaspersoft.studio.editor.outline.actions.HideDefaultVariablesAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.variable.MVariable;
import com.jaspersoft.studio.model.variable.MVariables;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import org.eclipse.gef.commands.Command;

public class ReorderVariableCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignVariable jrVariable;
    private JRDesignDataset jrDataset;
    private JasperReportsConfiguration jrContext;

    public ReorderVariableCommand(MVariable child, MVariables parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.jrContext = parent.getJasperConfiguration();
        this.newIndex = Math.max(0, newIndex);
        this.jrDataset = parent.getValue();
        this.jrVariable = child.getValue();
    }

    public ReorderVariableCommand(JRDesignVariable child, JRDesignDataset jrDataset, JasperReportsConfiguration jrContext, int newIndex) {
        super(Messages.common_reorder_elements);
        this.jrContext = jrContext;
        this.newIndex = Math.max(0, newIndex);
        this.jrDataset = jrDataset;
        this.jrVariable = child;
    }

    public void execute() {
        this.oldIndex = this.jrDataset.getVariablesList().indexOf(this.jrVariable);
        try {
            int i = 0;
            for (JRVariable v : this.jrDataset.getVariablesList()) {
                if (!v.isSystemDefined()) break;
                ++i;
            }
            boolean showDefaults = this.jrContext != null ? this.jrContext.getPropertyBoolean("showVariablesDefault", Boolean.TRUE) : true;
            boolean bl = showDefaults = showDefaults && !HideDefaultVariablesAction.areDefaultVariablesHidden(this.jrContext);
            if (!showDefaults) {
                this.newIndex += i;
            }
            this.newIndex = Math.max(this.newIndex, i);
            this.jrDataset.removeVariable((JRVariable)this.jrVariable);
            if (this.newIndex < 0 || this.newIndex > this.jrDataset.getVariablesList().size()) {
                this.jrDataset.addVariable(this.jrVariable);
            } else {
                this.jrDataset.addVariable(this.newIndex, this.jrVariable);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void undo() {
        try {
            this.jrDataset.removeVariable((JRVariable)this.jrVariable);
            if (this.oldIndex < 0 || this.oldIndex > this.jrDataset.getVariablesList().size()) {
                this.jrDataset.addVariable(this.jrVariable);
            } else {
                this.jrDataset.addVariable(this.oldIndex, this.jrVariable);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

