/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.bindings;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.plugin.ExtensionManager;
import com.jaspersoft.studio.preferences.bindings.BindingElement;
import com.jaspersoft.studio.preferences.bindings.BindingsPreferencePersistence;
import com.jaspersoft.studio.preferences.bindings.JSSKeySequence;
import com.jaspersoft.studio.preferences.bindings.JSSKeyStroke;
import com.jaspersoft.studio.preferences.bindings.KeySequenceText;
import com.jaspersoft.studio.preferences.bindings.PreferenceBindingElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.keys.IBindingService;

public class BindingsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int ITEMS_TO_SHOW = 12;
    private static final int COMMAND_NAME_COLUMN = 0;
    private static final int KEY_SEQUENCE_COLUMN = 1;
    private static final int CONTEXT_COLUMN = 2;
    private static int NUM_OF_COLUMNS = 3;
    private PatternFilter fPatternFilter;
    private CategoryFilterTree fFilteredTree;
    private Label commandNameValueLabel;
    private Text fBindingText;
    private StyledText fDescriptionText;
    private Label fWhenLabel;
    private Button removeBindingButton;
    private Button restoreBindingButton;
    private KeySequenceText fKeySequenceText;
    private TableViewer conflictViewer;
    private List<PreferenceBindingElement> input = null;

    protected Control createContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        page.setLayout((Layout)layout);
        this.fPatternFilter = new PatternFilter();
        this.createTree(page);
        this.createTreeControls(page);
        this.createDataControls(page);
        this.fill();
        this.applyDialogFont(page);
        GC gc = new GC((Drawable)this.fDescriptionText);
        gc.setFont(this.fDescriptionText.getFont());
        FontMetrics metrics = gc.getFontMetrics();
        gc.dispose();
        int height = metrics.getHeight() * 5;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.heightHint = height;
        gridData.widthHint = 200;
        gridData.minimumWidth = 200;
        this.fDescriptionText.setLayoutData((Object)gridData);
        return page;
    }

    private final void createDataControls(Composite parent) {
        Composite dataArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        dataArea.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        dataArea.setLayoutData((Object)gridData);
        Composite leftDataArea = new Composite(dataArea, 0);
        layout = new GridLayout(2, false);
        leftDataArea.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 128;
        gridData.horizontalAlignment = 4;
        leftDataArea.setLayoutData((Object)gridData);
        Label commandNameLabel = new Label(leftDataArea, 0);
        commandNameLabel.setText("Name");
        this.commandNameValueLabel = new Label(leftDataArea, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.commandNameValueLabel.setLayoutData((Object)gridData);
        Label commandDescriptionlabel = new Label(leftDataArea, 16384);
        commandDescriptionlabel.setText("Description");
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        commandDescriptionlabel.setLayoutData((Object)gridData);
        this.fDescriptionText = new StyledText(leftDataArea, 2634);
        this.fDescriptionText.setBackground(commandDescriptionlabel.getBackground());
        Label bindingLabel = new Label(leftDataArea, 0);
        bindingLabel.setText("Binding");
        this.fBindingText = new Text(leftDataArea, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 200;
        this.fBindingText.setLayoutData((Object)gridData);
        this.fKeySequenceText = new KeySequenceText(this.fBindingText);
        this.fKeySequenceText.setKeyStrokeLimit(4);
        this.fKeySequenceText.addPropertyChangeListener(new IPropertyChangeListener(){

            public final void propertyChange(PropertyChangeEvent event) {
                boolean somethingChanged = false;
                StructuredSelection selection = (StructuredSelection)BindingsPreferencePage.this.fFilteredTree.getViewer().getSelection();
                JSSKeySequence keySequence = BindingsPreferencePage.this.fKeySequenceText.getKeySequence();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    PreferenceBindingElement activeBinding = (PreferenceBindingElement)element;
                    if (!keySequence.isEqual(activeBinding.getTrigger())) {
                        somethingChanged = true;
                        activeBinding.setTrigger(keySequence);
                    }
                    ++n2;
                }
                if (somethingChanged) {
                    BindingsPreferencePage.this.fFilteredTree.getViewer().refresh();
                    BindingsPreferencePage.this.computeOverlappingBindings();
                    BindingsPreferencePage.this.fBindingText.setSelection(BindingsPreferencePage.this.fBindingText.getTextLimit());
                }
            }
        });
        Label whenLabel = new Label(leftDataArea, 0);
        whenLabel.setText("When");
        this.fWhenLabel = new Label(leftDataArea, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 200;
        this.fWhenLabel.setLayoutData((Object)gridData);
        Group rightDataArea = new Group(dataArea, 0);
        layout = new GridLayout(1, false);
        rightDataArea.setLayout((Layout)layout);
        gridData = new GridData(4, 4, true, true);
        rightDataArea.setLayoutData((Object)gridData);
        rightDataArea.setText("Conflicts");
        this.conflictViewer = new TableViewer((Composite)rightDataArea, 68100);
        Table table = this.conflictViewer.getTable();
        table.setHeaderVisible(true);
        TableColumn bindingStudioNameColumn = new TableColumn(table, 16384);
        bindingStudioNameColumn.setText("Binding");
        bindingStudioNameColumn.setWidth(100);
        TableColumn bindingNameColumn = new TableColumn(table, 16384);
        bindingNameColumn.setText("Conflicting Binding");
        bindingNameColumn.setWidth(100);
        TableColumn bindingContextNameColumn = new TableColumn(table, 16384);
        bindingContextNameColumn.setText("Origin");
        bindingContextNameColumn.setWidth(100);
        gridData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(35));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(35));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        table.setLayout((Layout)tableLayout);
        this.conflictViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.conflictViewer.setLabelProvider((IBaseLabelProvider)new BindingElementLabelProvider(this){

            @Override
            public String getColumnText(Object o, int index) {
                BindingConflict conflict = (BindingConflict)o;
                if (index == 0) {
                    return conflict.jssElementName;
                }
                if (index == 1) {
                    return conflict.bidningConflict;
                }
                return conflict.isPlatformConflict ? "Eclipse" : "Jaspersoft Studio";
            }
        });
        this.conflictViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    BindingConflict selectedEntry = (BindingConflict)sel.getFirstElement();
                    BindingsPreferencePage.this.fFilteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)selectedEntry.jssElement));
                    BindingsPreferencePage.this.fFilteredTree.getViewer().getControl().redraw();
                }
            }
        });
    }

    private void createTree(Composite parent) {
        this.fPatternFilter = new PatternFilter();
        this.fFilteredTree = new CategoryFilterTree(parent, 67588, this.fPatternFilter);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        this.fFilteredTree.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.fFilteredTree.setLayoutData(gridData);
        TreeViewer viewer = this.fFilteredTree.getViewer();
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        Object layoutData = tree.getLayoutData();
        if (layoutData instanceof GridData) {
            gridData = (GridData)layoutData;
            int itemHeight = tree.getItemHeight();
            if (itemHeight > 1) {
                gridData.heightHint = 12 * itemHeight;
            }
        }
        BindingModelComparator comparator = new BindingModelComparator();
        viewer.setComparator((ViewerComparator)comparator);
        TreeColumn commandNameColumn = new TreeColumn(tree, 16384, 0);
        commandNameColumn.setText("Name");
        tree.setSortColumn(commandNameColumn);
        tree.setSortDirection(comparator.isAscending() ? 128 : 1024);
        commandNameColumn.addSelectionListener((SelectionListener)new ResortColumn(comparator, commandNameColumn, viewer, 0));
        TreeColumn triggerSequenceColumn = new TreeColumn(tree, 16384, 1);
        triggerSequenceColumn.setText("Binding");
        triggerSequenceColumn.addSelectionListener((SelectionListener)new ResortColumn(comparator, triggerSequenceColumn, viewer, 1));
        TreeColumn whenColumn = new TreeColumn(tree, 16384, 2);
        whenColumn.setText("When");
        whenColumn.addSelectionListener((SelectionListener)new ResortColumn(comparator, whenColumn, viewer, 2));
        viewer.setContentProvider((IContentProvider)new ModelContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new BindingElementLabelProvider());
        this.fFilteredTree.getPatternFilter().setIncludeLeadingWildcard(true);
        TreeColumn[] columns = viewer.getTree().getColumns();
        columns[0].setWidth(240);
        columns[1].setWidth(130);
        columns[2].setWidth(130);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BindingsPreferencePage.this.updateInformationPanel();
            }
        });
    }

    private void updateInformationPanel() {
        PreferenceBindingElement binding;
        ISelection selection = this.fFilteredTree.getViewer().getSelection();
        if (selection != null && (binding = (PreferenceBindingElement)((IStructuredSelection)selection).getFirstElement()) != null) {
            this.commandNameValueLabel.setText(binding.getName());
            this.fDescriptionText.setText(binding.getDescription());
            this.fWhenLabel.setText(binding.getContext());
            JSSKeyStroke[] keyStrokes = binding.getTrigger().getKeyStrokes();
            this.fKeySequenceText.setKeySequence(JSSKeySequence.getInstance(keyStrokes));
            this.removeBindingButton.setEnabled(true);
            this.restoreBindingButton.setEnabled(true);
            this.fBindingText.setEnabled(true);
            return;
        }
        this.commandNameValueLabel.setText("");
        this.fDescriptionText.setText("");
        this.fWhenLabel.setText("");
        this.fKeySequenceText.setKeySequence(JSSKeySequence.getInstance(new JSSKeyStroke[0]));
        this.removeBindingButton.setEnabled(false);
        this.restoreBindingButton.setEnabled(false);
        this.fBindingText.setEnabled(false);
    }

    private final Control createTreeControls(Composite parent) {
        Composite treeControls = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        treeControls.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        treeControls.setLayoutData((Object)gridData);
        this.removeBindingButton = new Button(treeControls, 8);
        gridData = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        this.removeBindingButton.setText("Unbind Command");
        gridData.widthHint = Math.max(widthHint, this.removeBindingButton.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        this.removeBindingButton.setLayoutData((Object)gridData);
        this.removeBindingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                StructuredSelection selection = (StructuredSelection)BindingsPreferencePage.this.fFilteredTree.getViewer().getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    PreferenceBindingElement selectedElement = (PreferenceBindingElement)element;
                    selectedElement.setTrigger(JSSKeySequence.getInstance(new JSSKeyStroke[0]));
                    ++n2;
                }
                BindingsPreferencePage.this.fFilteredTree.getViewer().refresh();
                BindingsPreferencePage.this.updateInformationPanel();
                BindingsPreferencePage.this.computeOverlappingBindings();
            }
        });
        this.restoreBindingButton = new Button(treeControls, 8);
        gridData = new GridData();
        widthHint = this.convertHorizontalDLUsToPixels(61);
        this.restoreBindingButton.setText("Restore Default");
        gridData.widthHint = Math.max(widthHint, this.restoreBindingButton.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        this.restoreBindingButton.setLayoutData((Object)gridData);
        this.restoreBindingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                StructuredSelection selection = (StructuredSelection)BindingsPreferencePage.this.fFilteredTree.getViewer().getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    PreferenceBindingElement selectedElement = (PreferenceBindingElement)element;
                    selectedElement.setTrigger(selectedElement.getDefault());
                    ++n2;
                }
                BindingsPreferencePage.this.fFilteredTree.getViewer().refresh();
                BindingsPreferencePage.this.updateInformationPanel();
                BindingsPreferencePage.this.computeOverlappingBindings();
            }
        });
        return treeControls;
    }

    private List<BindingConflict> getPartialMatches() {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        HashMap<KeyStroke, Binding> firstTokenBindings = new HashMap<KeyStroke, Binding>();
        ArrayList<BindingConflict> result = new ArrayList<BindingConflict>();
        Binding[] bindingArray = bindingService.getBindings();
        int n = bindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Binding binding = bindingArray[n2];
            if (binding.getTriggerSequence().getTriggers().length > 0) {
                KeyStroke eclipseKeyStroke = (KeyStroke)binding.getTriggerSequence().getTriggers()[0];
                firstTokenBindings.put(eclipseKeyStroke, binding);
            }
            ++n2;
        }
        for (PreferenceBindingElement element : this.input) {
            KeyStroke[] keystrokes = element.getTrigger().getEclipseKeyStrokes();
            if (keystrokes.length <= 0) continue;
            KeyStroke[] keyStrokeArray = keystrokes;
            int n3 = keystrokes.length;
            int eclipseKeyStroke = 0;
            while (eclipseKeyStroke < n3) {
                KeyStroke keystroke = keyStrokeArray[eclipseKeyStroke];
                Binding searchBinding = (Binding)firstTokenBindings.get(keystroke);
                if (searchBinding != null && searchBinding.getParameterizedCommand() != null) {
                    try {
                        String platformName = searchBinding.getParameterizedCommand().getName();
                        String conflictSequence = searchBinding.getTriggerSequence().format();
                        BindingConflict conflict = new BindingConflict(element, platformName, conflictSequence, true);
                        result.add(conflict);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaspersoftStudioPlugin.getInstance().logError(ex);
                    }
                }
                ++eclipseKeyStroke;
            }
        }
        ArrayList<PreferenceBindingElement> sortedElements = new ArrayList<PreferenceBindingElement>(this.input);
        Collections.sort(sortedElements, new Comparator<PreferenceBindingElement>(){

            @Override
            public int compare(PreferenceBindingElement o1, PreferenceBindingElement o2) {
                return o1.getTrigger().getSize() - o2.getTrigger().getSize();
            }
        });
        int i = 0;
        while (i < sortedElements.size() - 1) {
            PreferenceBindingElement baseElement = (PreferenceBindingElement)sortedElements.get(i);
            int j = i + 1;
            while (j < sortedElements.size()) {
                PreferenceBindingElement currentElement = (PreferenceBindingElement)sortedElements.get(j);
                if (currentElement.contains(baseElement)) {
                    String platformName = currentElement.getName();
                    String conflictSequence = currentElement.getTrigger().format();
                    BindingConflict conflict = new BindingConflict(baseElement, platformName, conflictSequence, false);
                    result.add(conflict);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private void computeOverlappingBindings() {
        List<BindingConflict> conflicts = this.getPartialMatches();
        this.conflictViewer.setInput(conflicts);
    }

    private void fill() {
        this.input = new ArrayList<PreferenceBindingElement>();
        for (BindingElement binding : ExtensionManager.getContributedBindings().values()) {
            HashMap<String, JSSKeySequence> preferencesBindings = BindingsPreferencePersistence.getPreferenceBindings();
            JSSKeySequence preferenceSequence = preferencesBindings.get(binding.getId());
            if (preferenceSequence == null) {
                preferenceSequence = binding.getDefault();
            }
            this.input.add(new PreferenceBindingElement(binding, preferenceSequence));
        }
        this.fFilteredTree.getViewer().setInput(this.input);
        TreeItem[] items = this.fFilteredTree.getViewer().getTree().getItems();
        if (items.length > 0 && items[0].getData() != null) {
            StructuredSelection firstElementSelection = new StructuredSelection(items[0].getData());
            this.fFilteredTree.getViewer().setSelection((ISelection)firstElementSelection);
        }
        this.updateInformationPanel();
        this.computeOverlappingBindings();
    }

    public void init(IWorkbench workbench) {
    }

    public void applyData(Object data) {
        BindingsPreferencePersistence.writeBindingsToPreferences(this.input);
    }

    public boolean performOk() {
        BindingsPreferencePersistence.writeBindingsToPreferences(this.input);
        return super.performOk();
    }

    protected final void performDefaults() {
        super.performDefaults();
        for (PreferenceBindingElement model : this.input) {
            model.setTrigger(model.getDefault());
        }
        this.fFilteredTree.getViewer().refresh();
        this.updateInformationPanel();
        this.computeOverlappingBindings();
    }

    private class BindingConflict {
        private String jssElementName;
        private PreferenceBindingElement jssElement;
        private String bidningConflict;
        private boolean isPlatformConflict;

        public BindingConflict(PreferenceBindingElement jssElement, String bindingConflictName, String bindingConflictSequence, boolean isPlatformConflict) {
            this.jssElement = jssElement;
            this.jssElementName = jssElement.getName();
            this.bidningConflict = String.valueOf(bindingConflictName) + "(" + bindingConflictSequence + ")";
            this.isPlatformConflict = isPlatformConflict;
        }
    }

    private class BindingElementLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private BindingElementLabelProvider() {
        }

        public String getText(Object element) {
            String rc = this.getColumnText(element, 0);
            if (rc == null) {
                rc = super.getText(element);
            }
            StringBuffer buf = new StringBuffer(rc);
            int i = 1;
            while (i < NUM_OF_COLUMNS) {
                String text = this.getColumnText(element, i);
                if (text != null) {
                    buf.append(' ');
                    buf.append(text);
                }
                ++i;
            }
            return buf.toString();
        }

        public String getColumnText(Object element, int index) {
            PreferenceBindingElement bindingElement = (PreferenceBindingElement)element;
            switch (index) {
                case 0: {
                    return bindingElement.getName();
                }
                case 1: {
                    JSSKeySequence seq = bindingElement.getTrigger();
                    return seq == null ? "" : seq.format();
                }
                case 2: {
                    String context = bindingElement.getContext();
                    return context == null ? "" : context;
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    private final class BindingModelComparator
    extends ViewerComparator {
        private LinkedList<Integer> sortColumns = new LinkedList();
        private boolean ascending = true;

        public BindingModelComparator() {
            int i = 0;
            while (i < NUM_OF_COLUMNS) {
                this.sortColumns.add(new Integer(i));
                ++i;
            }
        }

        public int getSortColumn() {
            return this.sortColumns.getFirst();
        }

        public void setSortColumn(int column) {
            if (column == this.getSortColumn()) {
                return;
            }
            Integer sortColumn = new Integer(column);
            this.sortColumns.remove(sortColumn);
            this.sortColumns.addFirst(sortColumn);
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }

        public final int compare(Viewer viewer, Object a, Object b) {
            int result = 0;
            Iterator i = this.sortColumns.iterator();
            while (i.hasNext() && result == 0) {
                int column = (Integer)i.next();
                result = this.compareColumn(viewer, a, b, column);
            }
            return this.ascending ? result : -1 * result;
        }

        private int compareColumn(Viewer viewer, Object a, Object b, int columnNumber) {
            IBaseLabelProvider baseLabel = ((TreeViewer)viewer).getLabelProvider();
            if (baseLabel instanceof ITableLabelProvider) {
                ITableLabelProvider tableProvider = (ITableLabelProvider)baseLabel;
                String e1p = tableProvider.getColumnText(a, columnNumber);
                String e2p = tableProvider.getColumnText(b, columnNumber);
                if (e1p != null && e2p != null) {
                    return e1p.compareTo(e2p);
                }
            }
            return 0;
        }
    }

    protected class CategoryFilterTree
    extends FilteredTree {
        protected CategoryFilterTree(Composite parent, int treeStyle, PatternFilter filter) {
            super(parent, treeStyle, filter, true);
            this.setQuickSelectionMode(true);
        }
    }

    private class ModelContentProvider
    implements ITreeContentProvider {
        private ModelContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                return ((List)parentElement).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof List;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class ResortColumn
    extends SelectionAdapter {
        private final BindingModelComparator comparator;
        private final TreeColumn treeColumn;
        private final TreeViewer viewer;
        private final int column;

        private ResortColumn(BindingModelComparator comparator, TreeColumn treeColumn, TreeViewer viewer, int column) {
            this.comparator = comparator;
            this.treeColumn = treeColumn;
            this.viewer = viewer;
            this.column = column;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.comparator.getSortColumn() == this.column) {
                this.comparator.setAscending(!this.comparator.isAscending());
                this.viewer.getTree().setSortDirection(this.comparator.isAscending() ? 128 : 1024);
            } else {
                this.viewer.getTree().setSortColumn(this.treeColumn);
                this.comparator.setSortColumn(this.column);
            }
            try {
                this.viewer.getTree().setRedraw(false);
                this.viewer.refresh();
            }
            finally {
                this.viewer.getTree().setRedraw(true);
            }
        }
    }
}

