/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.bindings;

import java.util.HashSet;
import java.util.Locale;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.formatting.IKeyFormatter;
import org.eclipse.jface.bindings.keys.formatting.KeyFormatterFactory;
import org.eclipse.jface.util.Util;

public class JSSKeyStroke
extends Trigger {
    private static HashSet<Integer> modifierKeys = JSSKeyStroke.getModifierKeys();
    public static final int NO_KEY = 0;
    private final int naturalKey;

    public static final JSSKeyStroke getInstance(int naturalKey) {
        return new JSSKeyStroke(naturalKey);
    }

    public static final JSSKeyStroke getInstance(String string) throws ParseException {
        String token;
        if (string == null) {
            throw new NullPointerException("Cannot parse a null string");
        }
        IKeyLookup lookup = KeyLookupFactory.getDefault();
        int naturalKey = lookup.formalModifierLookup(token = string.toUpperCase(Locale.ENGLISH));
        if (naturalKey == 0) {
            Integer simpleKey = null;
            try {
                simpleKey = lookup.formalKeyLookupInteger(token);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                simpleKey = token.charAt(0);
            }
            int n = naturalKey = simpleKey != null ? simpleKey : 0;
        }
        if (naturalKey == 0) {
            throw new ParseException("Cannot create key stroke with duplicate or non-existent modifier key: " + token);
        }
        return new JSSKeyStroke(naturalKey);
    }

    protected JSSKeyStroke(int naturalKey) {
        this.naturalKey = naturalKey;
    }

    public final int compareTo(Object object) {
        if (!(object instanceof JSSKeyStroke)) {
            return -1;
        }
        JSSKeyStroke keyStroke = (JSSKeyStroke)((Object)object);
        return Util.compare((int)this.naturalKey, (int)keyStroke.naturalKey);
    }

    public boolean equals(Object object) {
        if (!(object instanceof JSSKeyStroke)) {
            return false;
        }
        JSSKeyStroke keyStroke = (JSSKeyStroke)((Object)object);
        return this.naturalKey == keyStroke.naturalKey;
    }

    public String format() {
        IKeyFormatter formatter = KeyFormatterFactory.getDefault();
        if (this.isModifier()) {
            String formattedKey = formatter.format(KeyStroke.getInstance((int)this.naturalKey, (int)0));
            if (formattedKey.endsWith("+")) {
                formattedKey = formattedKey.substring(0, formattedKey.length() - 1);
            }
            return formattedKey;
        }
        return formatter.format(KeyStroke.getInstance((int)0, (int)this.naturalKey));
    }

    public boolean isModifier() {
        return modifierKeys.contains(this.naturalKey);
    }

    public final int getNaturalKey() {
        return this.naturalKey;
    }

    public int hashCode() {
        return this.naturalKey;
    }

    public String toString() {
        IKeyFormatter formatter = KeyFormatterFactory.getFormalKeyFormatter();
        if (this.isModifier()) {
            String formattedKey = formatter.format(KeyStroke.getInstance((int)this.naturalKey, (int)0));
            if (formattedKey.endsWith("+")) {
                formattedKey = formattedKey.substring(0, formattedKey.length() - 1);
            }
            return formattedKey;
        }
        return formatter.format(KeyStroke.getInstance((int)0, (int)this.naturalKey));
    }

    private static HashSet<Integer> getModifierKeys() {
        HashSet<Integer> modifierKeyTable = new HashSet<Integer>();
        Integer alt = new Integer(65536);
        Integer command = new Integer(0x400000);
        Integer ctrl = new Integer(262144);
        Integer shift = new Integer(131072);
        modifierKeyTable.add(alt);
        modifierKeyTable.add(command);
        modifierKeyTable.add(ctrl);
        modifierKeyTable.add(shift);
        modifierKeyTable.add(Util.isMac() ? command : ctrl);
        modifierKeyTable.add(shift);
        modifierKeyTable.add(alt);
        modifierKeyTable.add(Util.isMac() ? ctrl : command);
        return modifierKeyTable;
    }
}

