/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.bindings;

import com.jaspersoft.studio.preferences.bindings.JSSKeySequence;
import com.jaspersoft.studio.preferences.bindings.JSSKeyStroke;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public final class KeySequenceText {
    private static final String EMPTY_STRING = "";
    public static final int INFINITE = -1;
    public static final String P_KEY_SEQUENCE = "org.eclipse.jface.bindings.keys.KeySequenceText.KeySequence";
    public static final List<JSSKeyStroke> TRAPPED_KEYS;
    private final KeyTrapListener keyFilter = new KeyTrapListener();
    private JSSKeySequence keySequence = JSSKeySequence.getInstance();
    private Collection<IPropertyChangeListener> listeners = null;
    private int maxStrokes = -1;
    private final Text text;
    private final UpdateSequenceListener updateSequenceListener = new UpdateSequenceListener();

    static {
        TreeSet<JSSKeyStroke> trappedKeys = new TreeSet<JSSKeyStroke>();
        trappedKeys.add(KeySequenceText.convertAcceleratorToKeyStroke(9));
        trappedKeys.add(KeySequenceText.convertAcceleratorToKeyStroke(131081));
        trappedKeys.add(KeySequenceText.convertAcceleratorToKeyStroke(8));
        trappedKeys.add(KeySequenceText.convertAcceleratorToKeyStroke(127));
        ArrayList trappedKeyList = new ArrayList(trappedKeys);
        TRAPPED_KEYS = Collections.unmodifiableList(trappedKeyList);
    }

    public KeySequenceText(Text wrappedText) {
        this.text = wrappedText;
        if (Util.isMac()) {
            final Font font = new Font((Device)this.text.getDisplay(), "Lucida Grande", 13, 0);
            this.text.setFont(font);
            this.text.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    font.dispose();
                }
            });
        }
        this.text.addListener(2, (Listener)this.keyFilter);
        this.text.addListener(1, (Listener)this.keyFilter);
        final TraversalFilterManager traversalFilterManager = new TraversalFilterManager();
        this.text.addFocusListener((FocusListener)traversalFilterManager);
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                traversalFilterManager.dispose();
            }
        });
        this.text.addModifyListener((ModifyListener)this.updateSequenceListener);
    }

    public final void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<IPropertyChangeListener>(1);
        }
        this.listeners.add(listener);
    }

    public void clear() {
        JSSKeySequence oldKeySequence = this.keySequence;
        this.keySequence = JSSKeySequence.getInstance();
        this.text.setText(EMPTY_STRING);
        this.firePropertyChangeEvent(oldKeySequence);
    }

    private HashSet<JSSKeyStroke> getSelectKeystrokes(JSSKeyStroke[] keyStrokes) {
        int nSelectedStrokes;
        HashSet<JSSKeyStroke> result = new HashSet<JSSKeyStroke>();
        String selectedStrokes = this.text.getSelectionText().trim();
        int n = nSelectedStrokes = selectedStrokes.isEmpty() ? 0 : selectedStrokes.split(" ").length;
        if (nSelectedStrokes > 0) {
            Point selection = this.text.getSelection();
            int start = selection.x;
            String strokesBefore = this.text.getText().substring(0, start).trim();
            int nStrokesBefore = strokesBefore.isEmpty() ? 0 : strokesBefore.split(" ").length;
            int i = 0;
            while (i < nSelectedStrokes) {
                if (i + nStrokesBefore < keyStrokes.length) {
                    result.add(keyStrokes[i + nStrokesBefore]);
                }
                ++i;
            }
        }
        return result;
    }

    private final int deleteSelection(JSSKeyStroke[] keyStrokes, boolean allowIncomplete, JSSKeyStroke[][] deletedKeyStrokes) {
        int nSelectedStrokes;
        Point selection = this.text.getSelection();
        int start = selection.x;
        int keyStrokesLength = keyStrokes.length;
        String selectedStrokes = this.text.getSelectionText().trim();
        int n = nSelectedStrokes = selectedStrokes.isEmpty() ? 0 : selectedStrokes.split(" ").length;
        if (nSelectedStrokes == 0) {
            deletedKeyStrokes[0] = keyStrokes;
            String strokesBefore = this.text.getText().substring(0, this.text.getCaretPosition());
            int nStrokesBefore = strokesBefore.split(" ").length;
            return nStrokesBefore;
        }
        String strokesBefore = this.text.getText().substring(0, start).trim();
        int nStrokesBefore = strokesBefore.isEmpty() ? 0 : strokesBefore.split(" ").length;
        int nStrokeAfter = keyStrokesLength - nStrokesBefore - nSelectedStrokes;
        int newLength = keyStrokesLength - nSelectedStrokes;
        deletedKeyStrokes[0] = new JSSKeyStroke[newLength];
        JSSKeyStroke[] keyStrokeResult = new JSSKeyStroke[newLength];
        if (nStrokesBefore > 0) {
            System.arraycopy(keyStrokes, 0, keyStrokeResult, 0, nStrokesBefore);
        }
        if (nStrokeAfter > 0) {
            System.arraycopy(keyStrokes, nStrokesBefore + nSelectedStrokes, keyStrokeResult, nStrokesBefore, nStrokeAfter);
        }
        System.arraycopy(keyStrokeResult, 0, deletedKeyStrokes[0], 0, newLength);
        return nStrokesBefore;
    }

    protected final void firePropertyChangeEvent(JSSKeySequence oldKeySequence) {
        if (this.listeners != null) {
            Iterator<IPropertyChangeListener> listenerItr = this.listeners.iterator();
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, P_KEY_SEQUENCE, (Object)oldKeySequence, (Object)this.getKeySequence());
            while (listenerItr.hasNext()) {
                IPropertyChangeListener listener = listenerItr.next();
                listener.propertyChange(event);
            }
        }
    }

    public JSSKeySequence getKeySequence() {
        return this.keySequence;
    }

    private String getText() {
        return this.text.getText();
    }

    private boolean hasSelection() {
        return this.text.getSelectionCount() > 0;
    }

    public void insert(JSSKeyStroke stroke) {
        JSSKeyStroke[] newKeyStrokes;
        JSSKeySequence keySequence = this.getKeySequence();
        JSSKeyStroke[] oldKeyStrokes = keySequence.getKeyStrokes();
        if (!keySequence.isEmpty()) {
            int newKeyStrokesLength = oldKeyStrokes.length - 1;
            newKeyStrokes = new JSSKeyStroke[newKeyStrokesLength];
            System.arraycopy(oldKeyStrokes, 0, newKeyStrokes, 0, newKeyStrokesLength);
        } else {
            newKeyStrokes = oldKeyStrokes;
        }
        JSSKeyStroke[][] deletedKeyStrokes = new JSSKeyStroke[1][];
        int index = this.deleteSelection(newKeyStrokes, true, deletedKeyStrokes);
        if (index == -1) {
            index = 0;
        }
        JSSKeyStroke[] keyStrokes = this.insertStrokeAt(newKeyStrokes, stroke, index);
        this.keyFilter.clearInsertionIndex();
        this.setKeySequence(JSSKeySequence.getInstance(keyStrokes));
    }

    private final JSSKeyStroke[] insertStrokeAt(JSSKeyStroke[] keyStrokes, JSSKeyStroke stroke, int index) {
        JSSKeyStroke currentStroke;
        int keyStrokesLength = keyStrokes.length;
        JSSKeyStroke jSSKeyStroke = currentStroke = index >= keyStrokesLength ? null : keyStrokes[index];
        if (currentStroke != null) {
            int naturalKey = stroke.getNaturalKey();
            keyStrokes[index] = JSSKeyStroke.getInstance(naturalKey);
            return keyStrokes;
        }
        JSSKeyStroke[] newKeyStrokes = new JSSKeyStroke[keyStrokesLength + 1];
        System.arraycopy(keyStrokes, 0, newKeyStrokes, 0, index);
        newKeyStrokes[index] = stroke;
        if (index < keyStrokesLength) {
            System.arraycopy(keyStrokes, index, newKeyStrokes, index + 1, keyStrokesLength - index);
        }
        return newKeyStrokes;
    }

    private final JSSKeyStroke[] appenStrokeAt(JSSKeyStroke[] keyStrokes, JSSKeyStroke stroke, int index) {
        int keyStrokesLength = keyStrokes.length;
        JSSKeyStroke[] newKeyStrokes = new JSSKeyStroke[keyStrokesLength + 1];
        if (index >= 0 && index < keyStrokesLength) {
            System.arraycopy(keyStrokes, 0, newKeyStrokes, 0, index);
            newKeyStrokes[index] = stroke;
            System.arraycopy(keyStrokes, index, newKeyStrokes, index + 1, keyStrokesLength - index);
        } else {
            System.arraycopy(keyStrokes, 0, newKeyStrokes, 0, index);
            newKeyStrokes[keyStrokesLength] = stroke;
        }
        return newKeyStrokes;
    }

    private static final JSSKeyStroke convertAcceleratorToKeyStroke(int accelerator) {
        int modifierKeys = accelerator & SWT.MODIFIER_MASK;
        return JSSKeyStroke.getInstance(modifierKeys);
    }

    private boolean isCursorInLastPosition() {
        return this.text.getSelection().y >= this.getText().length();
    }

    public final void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (listener == null || this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void setKeySequence(JSSKeySequence newKeySequence) {
        String newString;
        String currentString;
        JSSKeyStroke[] oldKeyStrokes;
        JSSKeySequence oldKeySequence = this.keySequence;
        if (newKeySequence == null) {
            this.text.setText(EMPTY_STRING);
        } else {
            this.keySequence = newKeySequence;
        }
        if (this.maxStrokes != -1 && this.maxStrokes < (oldKeyStrokes = this.keySequence.getKeyStrokes()).length) {
            JSSKeyStroke[] newKeyStrokes = new JSSKeyStroke[this.maxStrokes];
            System.arraycopy(oldKeyStrokes, 0, newKeyStrokes, 0, this.maxStrokes);
            this.keySequence = JSSKeySequence.getInstance(newKeyStrokes);
        }
        if (!(currentString = this.getText()).equals(newString = this.keySequence.format())) {
            this.text.removeModifyListener((ModifyListener)this.updateSequenceListener);
            this.text.setText(this.keySequence.format());
            this.text.addModifyListener((ModifyListener)this.updateSequenceListener);
            this.text.setSelection(this.getText().length());
        }
        this.firePropertyChangeEvent(oldKeySequence);
    }

    public int getKeyStrokeLimit() {
        return this.maxStrokes;
    }

    public void setKeyStrokeLimit(int keyStrokeLimit) {
        if (keyStrokeLimit <= 0 && keyStrokeLimit != -1) {
            throw new IllegalArgumentException();
        }
        this.maxStrokes = keyStrokeLimit;
        this.setKeySequence(this.getKeySequence());
    }

    private class KeyTrapListener
    implements Listener {
        private int insertionIndex = -1;

        private KeyTrapListener() {
        }

        void clearInsertionIndex() {
            this.insertionIndex = -1;
        }

        private final JSSKeyStroke[] deleteKeyStroke(JSSKeyStroke[] keyStrokes) {
            this.clearInsertionIndex();
            if (KeySequenceText.this.hasSelection()) {
                JSSKeyStroke[][] deletedKeyStrokes = new JSSKeyStroke[1][];
                KeySequenceText.this.deleteSelection(keyStrokes, true, deletedKeyStrokes);
                return deletedKeyStrokes[0];
            }
            int caretPosition = KeySequenceText.this.text.getCaretPosition();
            String[] strokes = KeySequenceText.this.text.getText().split(" ");
            int index = keyStrokes.length - 1;
            int parsedText = 0;
            String[] stringArray = strokes;
            int n = strokes.length;
            int n2 = 0;
            while (n2 < n) {
                String stroke = stringArray[n2];
                if (caretPosition < (parsedText += stroke.length() + 1)) {
                    index = caretPosition;
                    break;
                }
                ++caretPosition;
                ++n2;
            }
            if (keyStrokes.length > 0 && keyStrokes.length < index) {
                int newKeyStrokesLength = index;
                JSSKeyStroke[] newKeyStrokes = new JSSKeyStroke[newKeyStrokesLength];
                System.arraycopy(keyStrokes, 0, newKeyStrokes, 0, newKeyStrokesLength);
                return newKeyStrokes;
            }
            return keyStrokes;
        }

        public void handleEvent(Event event) {
            JSSKeyStroke[] keyStrokes = KeySequenceText.this.getKeySequence().getKeyStrokes();
            if (event.type == 1) {
                keyStrokes = this.handleKeyDown(event, keyStrokes);
            }
            KeySequenceText.this.setKeySequence(JSSKeySequence.getInstance(keyStrokes));
            event.doit = false;
        }

        private JSSKeyStroke[] handleKeyDown(Event event, JSSKeyStroke[] keyStrokes) {
            if ((event.character == '\b' || event.character == '\u007f') && event.stateMask == 0) {
                return this.deleteKeyStroke(keyStrokes);
            }
            return this.insertKeyStroke(event, keyStrokes);
        }

        private final JSSKeyStroke[] insertKeyStroke(Event event, JSSKeyStroke[] keyStrokes) {
            int key = SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)event);
            JSSKeyStroke[] strokes = this.convertAcceleratorToKeyStroke(key);
            JSSKeyStroke[] newStrokes = keyStrokes;
            JSSKeyStroke[] jSSKeyStrokeArray = strokes;
            int n = strokes.length;
            int n2 = 0;
            while (n2 < n) {
                JSSKeyStroke stroke = jSSKeyStrokeArray[n2];
                if (stroke.getNaturalKey() != 0) {
                    newStrokes = this.insertKeyStroke(stroke, keyStrokes);
                }
                ++n2;
            }
            return newStrokes;
        }

        public JSSKeyStroke[] convertAcceleratorToKeyStroke(int accelerator) {
            int modifierKeys = accelerator & SWT.MODIFIER_MASK;
            if (accelerator == modifierKeys) {
                return new JSSKeyStroke[]{JSSKeyStroke.getInstance(modifierKeys)};
            }
            int naturalKey = accelerator - modifierKeys;
            return new JSSKeyStroke[]{JSSKeyStroke.getInstance(modifierKeys), JSSKeyStroke.getInstance(naturalKey)};
        }

        private final JSSKeyStroke[] insertKeyStroke(JSSKeyStroke stroke, JSSKeyStroke[] keyStrokes) {
            if (16777299 == stroke.getNaturalKey() || 16777298 == stroke.getNaturalKey() || 16777300 == stroke.getNaturalKey()) {
                return keyStrokes;
            }
            if (KeySequenceText.this.hasSelection()) {
                HashSet<JSSKeyStroke> selectedStrokes = KeySequenceText.this.getSelectKeystrokes(keyStrokes);
                JSSKeyStroke[] jSSKeyStrokeArray = keyStrokes;
                int n = keyStrokes.length;
                int n2 = 0;
                while (n2 < n) {
                    JSSKeyStroke keyStroke = jSSKeyStrokeArray[n2];
                    if (keyStroke.equals((Object)stroke) && !selectedStrokes.contains((Object)stroke)) {
                        return keyStrokes;
                    }
                    ++n2;
                }
                JSSKeyStroke[][] deletedKeyStrokes = new JSSKeyStroke[1][];
                this.insertionIndex = KeySequenceText.this.deleteSelection(keyStrokes, true, deletedKeyStrokes);
                keyStrokes = deletedKeyStrokes[0];
                if (stroke.isModifier()) {
                    this.insertionIndex = 0;
                }
                keyStrokes = KeySequenceText.this.appenStrokeAt(keyStrokes, stroke, this.insertionIndex);
                this.clearInsertionIndex();
            } else {
                JSSKeyStroke[] jSSKeyStrokeArray = keyStrokes;
                int n = keyStrokes.length;
                int n3 = 0;
                while (n3 < n) {
                    JSSKeyStroke keyStroke = jSSKeyStrokeArray[n3];
                    if (keyStroke.equals((Object)stroke)) {
                        return keyStrokes;
                    }
                    ++n3;
                }
                if (stroke.isModifier()) {
                    keyStrokes = KeySequenceText.this.appenStrokeAt(keyStrokes, stroke, 0);
                    this.clearInsertionIndex();
                } else if (keyStrokes.length == 0 || this.insertionIndex >= keyStrokes.length || KeySequenceText.this.isCursorInLastPosition()) {
                    keyStrokes = KeySequenceText.this.insertStrokeAt(keyStrokes, stroke, keyStrokes.length);
                    this.clearInsertionIndex();
                } else {
                    JSSKeyStroke[][] deletedKeyStrokes = new JSSKeyStroke[1][];
                    this.insertionIndex = KeySequenceText.this.deleteSelection(keyStrokes, true, deletedKeyStrokes);
                    keyStrokes = deletedKeyStrokes[0];
                    keyStrokes = KeySequenceText.this.insertStrokeAt(keyStrokes, stroke, this.insertionIndex);
                    this.clearInsertionIndex();
                }
            }
            return keyStrokes;
        }
    }

    private class TraversalFilter
    implements Listener {
        private TraversalFilter() {
        }

        public void handleEvent(Event event) {
            switch (event.detail) {
                case 0: 
                case 2: 
                case 4: 
                case 128: 
                case 256: 
                case 512: {
                    event.type = 0;
                    event.doit = false;
                    break;
                }
                case 8: 
                case 16: {
                    if ((event.stateMask & (SWT.MODIFIER_MASK ^ 0x20000)) == 0) break;
                    event.type = 0;
                    event.doit = false;
                }
            }
        }
    }

    private class TraversalFilterManager
    implements FocusListener {
        private TraversalFilter filter;
        private boolean filtering;

        private TraversalFilterManager() {
            this.filter = new TraversalFilter();
            this.filtering = false;
        }

        public void focusGained(FocusEvent event) {
            Display.getCurrent().addFilter(31, (Listener)this.filter);
            this.filtering = true;
        }

        public void focusLost(FocusEvent event) {
            Display.getCurrent().removeFilter(31, (Listener)this.filter);
            this.filtering = false;
        }

        public void dispose() {
            if (this.filtering) {
                Display.getCurrent().removeFilter(31, (Listener)this.filter);
            }
        }
    }

    private class UpdateSequenceListener
    implements ModifyListener {
        private UpdateSequenceListener() {
        }

        public void modifyText(ModifyEvent event) {
            try {
                JSSKeySequence originalSequence = KeySequenceText.this.getKeySequence();
                String contents = KeySequenceText.this.getText();
                JSSKeySequence newSequence = JSSKeySequence.getInstance(contents);
                if (!originalSequence.equals(newSequence)) {
                    KeySequenceText.this.setKeySequence(newSequence);
                }
            }
            catch (ParseException parseException) {
                KeySequenceText.this.setKeySequence(KeySequenceText.this.getKeySequence());
            }
        }
    }
}

