/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.editor.table;

import com.jaspersoft.studio.messages.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class TableFieldEditor
extends FieldEditor {
    protected Table table;
    private Composite buttonBox;
    protected Button addButton;
    protected Button duplicateButton;
    protected Button removeButton;
    protected Button upButton;
    protected Button downButton;
    protected SelectionListener selectionListener;
    private final String[] columnNames;
    private final int[] columnWidths;

    public Table getTable() {
        return this.table;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    protected TableFieldEditor() {
        this.columnNames = new String[0];
        this.columnWidths = new int[0];
    }

    protected TableFieldEditor(String name, String labelText, String[] columnNames, int[] columnWidths, Composite parent) {
        this.init(name, labelText);
        this.columnNames = columnNames;
        this.columnWidths = columnWidths;
        this.createControl(parent);
    }

    protected abstract String createList(String[][] var1);

    protected abstract String[][] parseString(String var1);

    protected abstract String[] getNewInputObject();

    protected void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, Messages.common_add);
        this.duplicateButton = this.createPushButton(box, Messages.common_duplicate);
        this.removeButton = this.createPushButton(box, Messages.common_delete);
        this.upButton = this.createPushButton(box, Messages.common_up);
        this.downButton = this.createPushButton(box, Messages.common_down);
    }

    protected Button getAddButton() {
        return this.addButton;
    }

    protected Button getDuplicateButton() {
        return this.duplicateButton;
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    protected Button getUpButton() {
        return this.upButton;
    }

    protected Button getDownButton() {
        return this.downButton;
    }

    protected Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(key);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.table.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == TableFieldEditor.this.addButton) {
                    TableFieldEditor.this.addPressed();
                } else if (widget == TableFieldEditor.this.duplicateButton) {
                    TableFieldEditor.this.duplicatePressed();
                } else if (widget == TableFieldEditor.this.removeButton) {
                    TableFieldEditor.this.removePressed();
                } else if (widget == TableFieldEditor.this.upButton) {
                    TableFieldEditor.this.upPressed();
                } else if (widget == TableFieldEditor.this.downButton) {
                    TableFieldEditor.this.downPressed();
                } else if (widget == TableFieldEditor.this.table) {
                    TableFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.minimumWidth = 500;
        gridData.heightHint = 500;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.table = this.getTableControl(composite);
        gd = new GridData(1808);
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.table.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(composite);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.table != null) {
            String s = this.getPreferenceStore().getString(this.getPreferenceName());
            String[][] array = this.parseString(s);
            int i = 0;
            while (i < array.length) {
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(array[i]);
                ++i;
            }
        }
    }

    protected void doLoadDefault() {
        if (this.table != null) {
            this.table.removeAll();
            String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            String[][] array = this.parseString(s);
            int i = 0;
            while (i < array.length) {
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(array[i]);
                ++i;
            }
        }
    }

    protected void doStore() {
        TableItem[] items = this.table.getItems();
        String[][] commands = new String[items.length][];
        int i = 0;
        while (i < items.length) {
            commands[i] = new String[this.columnNames.length];
            TableItem item = items[i];
            int j = 0;
            while (j < this.columnNames.length) {
                commands[i][j] = item.getText(j);
                ++j;
            }
            ++i;
        }
        String s = this.createList(commands);
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TableFieldEditor.this.addButton = null;
                    TableFieldEditor.this.duplicateButton = null;
                    TableFieldEditor.this.removeButton = null;
                    TableFieldEditor.this.upButton = null;
                    TableFieldEditor.this.downButton = null;
                    TableFieldEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public Table getTableControl(Composite parent) {
        if (this.table == null) {
            this.table = new Table(parent, 68354);
            this.table.setFont(parent.getFont());
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.addSelectionListener(this.getSelectionListener());
            this.table.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TableFieldEditor.this.table = null;
                }
            });
            String[] stringArray = this.columnNames;
            int n = this.columnNames.length;
            int n2 = 0;
            while (n2 < n) {
                String columnName = stringArray[n2];
                TableColumn tableColumn = new TableColumn(this.table, 16384);
                tableColumn.setText(columnName);
                tableColumn.setWidth(100);
                ++n2;
            }
            if (this.columnNames.length > 0) {
                TableLayout layout = new TableLayout();
                if (this.columnNames.length > 1) {
                    int i = 0;
                    while (i < this.columnNames.length - 1) {
                        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(0, this.columnWidths[i], false));
                        ++i;
                    }
                }
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, this.columnWidths[this.columnNames.length - 1], true));
                this.table.setLayout((Layout)layout);
            }
            final TableEditor editor = new TableEditor(this.table);
            editor.horizontalAlignment = 16384;
            editor.grabHorizontal = true;
            this.table.addListener(8, new Listener(){

                public void handleEvent(Event event) {
                    TableFieldEditor.this.handleTableDoubleClick();
                    Rectangle clientArea = TableFieldEditor.this.table.getClientArea();
                    Point pt = new Point(event.x, event.y);
                    int index = TableFieldEditor.this.table.getTopIndex();
                    while (index < TableFieldEditor.this.table.getItemCount()) {
                        boolean visible = false;
                        final TableItem item = TableFieldEditor.this.table.getItem(index);
                        int i = 0;
                        while (i < TableFieldEditor.this.table.getColumnCount()) {
                            Rectangle rect = item.getBounds(i);
                            if (rect.contains(pt)) {
                                final int column = i;
                                final Text text = new Text((Composite)TableFieldEditor.this.table, 0);
                                Listener textListener = new Listener(){

                                    public void handleEvent(Event e) {
                                        switch (e.type) {
                                            case 16: {
                                                item.setText(column, text.getText());
                                                text.dispose();
                                                break;
                                            }
                                            case 31: {
                                                switch (e.detail) {
                                                    case 4: {
                                                        item.setText(column, text.getText());
                                                    }
                                                    case 2: {
                                                        text.dispose();
                                                        e.doit = false;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                };
                                if (TableFieldEditor.this.isFieldEditable(i, index)) {
                                    text.addListener(16, textListener);
                                    text.addListener(31, textListener);
                                    editor.setEditor((Control)text, item, i);
                                    text.setText(item.getText(i));
                                    text.selectAll();
                                    text.setFocus();
                                }
                                return;
                            }
                            if (!visible && rect.intersects(clientArea)) {
                                visible = true;
                            }
                            ++i;
                        }
                        if (!visible) {
                            return;
                        }
                        ++index;
                    }
                }
            });
        }
        return this.table;
    }

    protected void handleTableDoubleClick() {
    }

    protected boolean isFieldEditable(int col, int row) {
        return true;
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    protected void addPressed() {
        this.setPresentsDefaultValue(false);
        String[] newInputObject = this.getNewInputObject();
        if (newInputObject != null) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(newInputObject);
            this.selectionChanged();
            this.table.showColumn(this.table.getColumn(0));
            this.table.showItem(tableItem);
            this.table.showSelection();
        }
    }

    protected void duplicatePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.table.getSelectionIndex();
        if (index >= 0) {
            TableItem[] selection = this.table.getSelection();
            Assert.isTrue((selection.length >= 1 ? 1 : 0) != 0);
            int i = 0;
            while (i < selection.length) {
                String[] values = new String[this.columnNames.length];
                int j = 0;
                while (j < this.columnNames.length) {
                    values[j] = j == 0 ? String.valueOf(selection[i].getText(j)) + "_copy" : selection[i].getText(j);
                    ++j;
                }
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(values);
                ++i;
            }
        }
        this.table.setSelection(this.table.getItemCount());
        this.table.showItem(this.table.getItem(this.table.getItemCount() - 1));
        this.table.showSelection();
        this.table.showColumn(this.table.getColumn(0));
        this.selectionChanged();
    }

    protected void removePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.table.getSelectionIndex();
        if (index >= 0) {
            this.table.remove(index);
            this.selectionChanged();
        }
    }

    protected void upPressed() {
        this.swap(true);
    }

    protected void downPressed() {
        this.swap(false);
    }

    protected void selectionChanged() {
        int index = this.table.getSelectionIndex();
        int size = this.table.getItemCount();
        if (this.duplicateButton != null) {
            this.duplicateButton.setEnabled(index >= 0);
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(index >= 0 && this.isRemovable(index));
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(size > 1 && index > 0 && this.isSortable(index));
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1 && this.isSortable(index));
        }
    }

    protected boolean isRemovable(int row) {
        return true;
    }

    protected boolean isSortable(int row) {
        return true;
    }

    public void setFocus() {
        if (this.table != null) {
            this.table.setFocus();
        }
    }

    private void swap(boolean up) {
        int target;
        this.setPresentsDefaultValue(false);
        int index = this.table.getSelectionIndex();
        int n = target = up ? index - 1 : index + 1;
        if (index >= 0) {
            TableItem[] selection = this.table.getSelection();
            Assert.isTrue((selection.length == 1 ? 1 : 0) != 0);
            String[] values = new String[this.columnNames.length];
            int j = 0;
            while (j < this.columnNames.length) {
                values[j] = selection[0].getText(j);
                ++j;
            }
            this.table.remove(index);
            TableItem tableItem = new TableItem(this.table, 0, target);
            tableItem.setText(values);
            this.table.setSelection(target);
        }
        this.selectionChanged();
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTableControl(parent).setEnabled(enabled);
        if (this.addButton != null) {
            this.addButton.setEnabled(enabled);
        }
        if (this.duplicateButton != null) {
            this.duplicateButton.setEnabled(enabled);
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(enabled);
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(enabled);
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(enabled);
        }
    }
}

