/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.editor.text;

import com.jaspersoft.studio.messages.Messages;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class TextFieldEditor
extends FieldEditor {
    public static final int VALIDATE_ON_KEY_STROKE = 0;
    public static final int VALIDATE_ON_FOCUS_LOST = 1;
    public static int UNLIMITED = -1;
    private boolean isValid;
    protected String oldValue;
    private Text textField;
    private int textLimit = UNLIMITED;
    private String errorMessage;
    private boolean emptyStringAllowed = true;
    private boolean isNullAllowed = false;
    private int validateStrategy = 0;
    private Button bIsNull;

    public TextFieldEditor(String name, String labelText, int width, int strategy, boolean isNullAllowed, Composite parent) {
        this.init(name, labelText);
        this.isNullAllowed = isNullAllowed;
        this.setValidateStrategy(strategy);
        this.isValid = false;
        this.errorMessage = "Field contains an invalid value";
        this.createControl(parent);
    }

    public TextFieldEditor(String name, String labelText, int width, Composite parent) {
        this(name, labelText, width, 0, false, parent);
    }

    public TextFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, UNLIMITED, parent);
    }

    public TextFieldEditor(String name, String labelText, boolean isNullAllowed, Composite parent) {
        this(name, labelText, UNLIMITED, 0, isNullAllowed, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected boolean checkState() {
        boolean result = false;
        if (this.isNullAllowedAndSet()) {
            result = true;
        } else {
            String txt;
            if (this.emptyStringAllowed) {
                result = true;
            }
            if (this.textField == null) {
                result = false;
            }
            result = (txt = this.textField.getText()).trim().length() > 0 || this.emptyStringAllowed;
            boolean bl = result = result && this.doCheckState();
        }
        if (result) {
            this.clearErrorMessage();
        } else {
            this.showErrorMessage(this.errorMessage);
        }
        return result;
    }

    protected boolean doCheckState() {
        return true;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.textField = this.getTextControl(parent);
        GridData gd = new GridData(1808);
        if (this.isNullAllowed) {
            gd.horizontalSpan = 2;
        }
        this.textField.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.textField != null) {
            IPreferenceStore pstore = this.getPreferenceStore();
            String value = pstore.getString(this.getPreferenceName());
            if (this.isNullAllowed && this.bIsNull != null) {
                if (pstore instanceof ScopedPreferenceStore) {
                    try {
                        Method m = this.getPrivateInternalGet(pstore.getClass());
                        if (m != null) {
                            value = (String)m.invoke((Object)pstore, this.getPreferenceName());
                        }
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                this.bIsNull.setSelection(value == null);
                this.textField.setEnabled(value != null);
            }
            this.textField.setText(Misc.nvl((String)value));
            this.oldValue = value;
        }
    }

    private Method getPrivateInternalGet(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            Method m = clazz.getDeclaredMethod("internalGet", String.class);
            if (m != null) {
                m.setAccessible(true);
                return m;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.getPrivateInternalGet(clazz.getSuperclass());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void doLoadDefault() {
        if (this.textField != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            if (this.isNullAllowed && this.bIsNull != null) {
                this.bIsNull.setSelection(value == null);
                this.textField.setEnabled(value != null);
            }
            this.textField.setText(Misc.nvl((String)value));
        }
        this.valueChanged();
    }

    protected void doStore() {
        IPreferenceStore pstore = this.getPreferenceStore();
        if (this.isNullAllowedAndSet()) {
            if (pstore instanceof EclipsePreferences) {
                ((EclipsePreferences)pstore).remove(this.getPreferenceName());
            } else if (pstore instanceof ScopedPreferenceStore) {
                IEclipsePreferences[] iEclipsePreferencesArray = ((ScopedPreferenceStore)pstore).getPreferenceNodes(true);
                int n = iEclipsePreferencesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEclipsePreferences ep = iEclipsePreferencesArray[n2];
                    ep.remove(this.getPreferenceName());
                    ++n2;
                }
            } else {
                pstore.setValue(this.getPreferenceName(), null);
            }
        } else {
            pstore.setValue(this.getPreferenceName(), this.textField.getText());
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getNumberOfControls() {
        if (this.isNullAllowed) {
            return 2;
        }
        return 1;
    }

    public String getStringValue() {
        if (this.isNullAllowedAndSet()) {
            return null;
        }
        if (this.textField != null) {
            return this.textField.getText();
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    protected boolean isNullAllowedAndSet() {
        return this.isNullAllowed && this.bIsNull != null && this.bIsNull.getSelection();
    }

    public Text getTextControl() {
        return this.textField;
    }

    public Text getTextControl(Composite parent) {
        if (this.textField == null) {
            if (this.isNullAllowed) {
                this.bIsNull = new Button(parent, 32);
                this.bIsNull.setText(Messages.TextFieldEditor_setToNullCheckbox);
                this.bIsNull.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TextFieldEditor.this.textField.setEnabled(!TextFieldEditor.this.bIsNull.getSelection());
                        TextFieldEditor.this.textField.setText("");
                    }
                });
            }
            this.textField = new Text(parent, 2626);
            this.textField.setFont(parent.getFont());
            switch (this.validateStrategy) {
                case 0: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent e) {
                            TextFieldEditor.this.valueChanged();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent e) {
                            TextFieldEditor.this.valueChanged();
                        }
                    });
                    break;
                }
                case 1: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            TextFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            TextFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent e) {
                            TextFieldEditor.this.valueChanged();
                            TextFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
                }
            }
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TextFieldEditor.this.textField = null;
                }
            });
            if (this.textLimit > 0) {
                this.textField.setTextLimit(this.textLimit);
            }
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }

    public boolean isEmptyStringAllowed() {
        return this.emptyStringAllowed;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    public void setEmptyStringAllowed(boolean b) {
        this.emptyStringAllowed = b;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public void setFocus() {
        if (this.textField != null) {
            this.textField.setFocus();
        }
    }

    public void setStringValue(String value) {
        if (this.textField != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.textField.getText();
            if (!this.oldValue.equals(value)) {
                this.textField.setText(value);
                this.valueChanged();
            }
        }
    }

    public void setTextLimit(int limit) {
        this.textLimit = limit;
        if (this.textField != null) {
            this.textField.setTextLimit(limit);
        }
    }

    public void setValidateStrategy(int value) {
        Assert.isTrue((value == 1 || value == 0 ? 1 : 0) != 0);
        this.validateStrategy = value;
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.errorMessage);
    }

    protected void valueChanged() {
        String newValue;
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid);
        }
        if (!(newValue = this.textField.getText()).equals(this.oldValue)) {
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTextControl(parent).setEnabled(enabled);
        this.bIsNull.setEnabled(enabled);
    }
}

