/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.fonts;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.SimpleFontFace;
import net.sf.jasperreports.engine.fonts.SimpleFontFamily;
import org.apache.batik.svggen.font.table.NameTable;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class FontImporter {
    public static void analyzeFolder(List<FontFamily> fontFamilies, File destDir, IProgressMonitor monitor) {
        JasperReportsConfiguration jConfig = JasperReportsConfiguration.getDefaultInstance();
        HashMap<String, FontFamily> fams = new HashMap<String, FontFamily>();
        for (FontFamily ff : fontFamilies) {
            fams.put(ff.getName(), ff);
        }
        for (File f : FileUtils.listFiles((File)destDir, (String[])new String[]{"ttf", "TTF", "OTF", "otf", "SVG", "svg", "eot", "EOT", "WOFF", "woff"}, (boolean)true)) {
            monitor.setTaskName("Analyzing font: " + f.getName());
            String fname = f.getName().trim().toLowerCase();
            if (fname.endsWith(".ttf") || fname.endsWith(".otf")) {
                try {
                    Font font = Font.createFont(0, f);
                    FontFamily ff = (FontFamily)fams.get(font.getFamily());
                    if (ff == null) {
                        ff = new SimpleFontFamily((JasperReportsContext)jConfig);
                        fontFamilies.add(ff);
                        ((SimpleFontFamily)ff).setName(font.getFamily());
                        ((SimpleFontFamily)ff).setPdfEncoding("Identity-H");
                        fams.put(font.getFamily(), ff);
                    }
                    SimpleFontFace fontFace = new SimpleFontFace((JasperReportsContext)jConfig);
                    fontFace.setTtf(f.getAbsolutePath());
                    try {
                        org.apache.batik.svggen.font.Font bfont = org.apache.batik.svggen.font.Font.create((String)f.getAbsolutePath());
                        NameTable nt = bfont.getNameTable();
                        String subFamily = nt.getRecord((short)2).toLowerCase();
                        if (subFamily.contains("bold") && subFamily.contains("italic")) {
                            ((SimpleFontFamily)ff).setBoldItalicFace(fontFace);
                        } else if (subFamily.equals("italic")) {
                            ((SimpleFontFamily)ff).setItalicFace(fontFace);
                        } else if (subFamily.equals("bold")) {
                            ((SimpleFontFamily)ff).setBoldFace(fontFace);
                        } else {
                            ((SimpleFontFamily)ff).setNormalFace(fontFace);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (font.isBold() && font.isItalic()) {
                            ((SimpleFontFamily)ff).setBoldItalicFace(fontFace);
                        } else if (font.isBold()) {
                            ((SimpleFontFamily)ff).setBoldFace(fontFace);
                        } else if (font.isItalic()) {
                            ((SimpleFontFamily)ff).setItalicFace(fontFace);
                        } else if (font.isPlain()) {
                            ((SimpleFontFamily)ff).setNormalFace(fontFace);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (FontFormatException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (fname.endsWith(".svg")) {
                System.out.println(f.getAbsolutePath());
            } else if (fname.endsWith(".eot")) {
                System.out.println(f.getAbsolutePath());
            } else if (fname.endsWith(".woff")) {
                System.out.println(f.getAbsolutePath());
            }
            if (!monitor.isCanceled()) continue;
            return;
        }
    }
}

