/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.fonts;

import com.ibm.icu.lang.UScript;
import com.jaspersoft.studio.messages.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.fonts.FontSetFamily;
import net.sf.jasperreports.engine.fonts.SimpleFontSet;
import net.sf.jasperreports.engine.fonts.SimpleFontSetFamily;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FontSetFamilyDialog
extends ATitledDialog {
    private SimpleFontSetFamily fsf;
    private SimpleFontSet fs;
    private static String[] uCodes;
    private org.eclipse.swt.widgets.List incl;
    private org.eclipse.swt.widgets.List excl;

    public FontSetFamilyDialog(Shell parentShell, SimpleFontSet fs, SimpleFontSetFamily fsf) {
        super(parentShell);
        this.setTitle(Messages.FontSetFamilyDialog_0);
        this.setDefaultSize(400, 400);
        this.fs = fs;
        this.fsf = fsf;
    }

    public SimpleFontSetFamily getValue() {
        return this.fsf;
    }

    public boolean close() {
        this.fsf.setIncludedScripts(this.incl.getItemCount() > 0 ? Arrays.asList(this.incl.getItems()) : null);
        this.fsf.setExcludedScripts(this.excl.getItemCount() > 0 ? Arrays.asList(this.excl.getItems()) : null);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        cmp.setLayout((Layout)new GridLayout(2, false));
        new Label(cmp, 0).setText(Messages.FontSetFamilyDialog_1);
        Text txt = new Text(cmp, 2056);
        txt.setLayoutData((Object)new GridData(768));
        txt.setText(Misc.nvl((String)this.fsf.getFamilyName()));
        Button bPrimary = new Button(cmp, 32);
        bPrimary.setText(Messages.FontSetFamilyDialog_2);
        bPrimary.setToolTipText(Messages.FontSetFamilyDialog_3);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        bPrimary.setLayoutData((Object)gd);
        bPrimary.setSelection(this.fsf.isPrimary());
        if (this.fsf.isPrimary()) {
            bPrimary.setEnabled(false);
        } else {
            bPrimary.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (FontSetFamily item : FontSetFamilyDialog.this.fs.getFamilies()) {
                        if (item.getFamilyName().equals(FontSetFamilyDialog.this.fsf.getFamilyName())) {
                            FontSetFamilyDialog.this.fsf.setPrimary(true);
                            continue;
                        }
                        ((SimpleFontSetFamily)item).setPrimary(false);
                    }
                }
            });
        }
        this.incl = this.createFilter(cmp, Messages.FontSetFamilyDialog_4, Messages.FontSetFamilyDialog_5, this.fsf.getIncludedScripts());
        this.excl = this.createFilter(cmp, Messages.FontSetFamilyDialog_6, Messages.FontSetFamilyDialog_7, this.fsf.getExcludedScripts());
        return cmp;
    }

    private org.eclipse.swt.widgets.List createFilter(Composite cmp, String label, String toolTip, List<String> scripts) {
        Label lbl = new Label(cmp, 0);
        lbl.setText(label);
        lbl.setLayoutData((Object)new GridData(2));
        lbl.setToolTipText(toolTip);
        Composite c = new Composite(cmp, 0);
        c.setLayoutData((Object)new GridData(768));
        GridLayout l = new GridLayout(2, false);
        l.marginWidth = 0;
        l.marginHeight = 0;
        l.verticalSpacing = 0;
        c.setLayout((Layout)l);
        final org.eclipse.swt.widgets.List lst = new org.eclipse.swt.widgets.List(c, 2818);
        lst.setToolTipText(toolTip);
        GridData gd = new GridData();
        gd.heightHint = 70;
        gd.widthHint = 150;
        gd.verticalSpan = 2;
        lst.setLayoutData((Object)gd);
        if (!Misc.isNullOrEmpty(scripts)) {
            lst.setItems(scripts.toArray(new String[scripts.size()]));
        }
        final Button bAdd = new Button(c, 8);
        bAdd.setText(Messages.common_add);
        gd = new GridData();
        gd.widthHint = 70;
        bAdd.setLayoutData((Object)gd);
        bAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] vals;
                UScriptDialog d = new UScriptDialog(bAdd.getShell());
                if (d.open() == 0 && !Misc.isNullOrEmpty((Object[])(vals = d.getValues()))) {
                    String[] items = lst.getItems();
                    ArrayList<String> all = new ArrayList<String>(Arrays.asList(items));
                    Object[] objectArray = vals;
                    int n = vals.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object v = objectArray[n2];
                        if (!all.contains(v)) {
                            all.add((String)v);
                        }
                        ++n2;
                    }
                    lst.setItems(all.toArray(new String[all.size()]));
                }
            }
        });
        final Button bDel = new Button(c, 8);
        bDel.setText(Messages.common_delete);
        gd = new GridData(2);
        gd.widthHint = 70;
        bDel.setLayoutData((Object)gd);
        bDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                lst.remove(lst.getSelectionIndices());
            }
        });
        lst.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bDel.setEnabled(lst.getSelectionCount() > 0);
            }
        });
        bDel.setEnabled(lst.getSelectionCount() > 0);
        return lst;
    }

    private static String[] getUCodes() {
        if (uCodes == null) {
            ArrayList<String> ucodes = new ArrayList<String>();
            int i = 0;
            while (i < 200) {
                String uc = UScript.getName((int)i);
                if (!Misc.isNullOrEmpty((String)uc)) {
                    ucodes.add(UScript.getName((int)i));
                }
                ++i;
            }
            uCodes = ucodes.toArray(new String[ucodes.size()]);
        }
        return uCodes;
    }

    class UScriptDialog
    extends ATitledDialog {
        private String[] values;

        public String[] getValues() {
            return this.values;
        }

        protected UScriptDialog(Shell parentShell) {
            super(parentShell);
            this.setTitle(Messages.FontSetFamilyDialog_8);
            this.setDefaultSize(400, 400);
        }

        protected Control createDialogArea(Composite parent) {
            Composite c = (Composite)super.createDialogArea(parent);
            final org.eclipse.swt.widgets.List lst = new org.eclipse.swt.widgets.List(c, 2818);
            lst.setLayoutData((Object)new GridData(1808));
            lst.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UScriptDialog.this.values = lst.getSelection();
                }
            });
            lst.setItems(FontSetFamilyDialog.getUCodes());
            return super.createDialogArea(parent);
        }
    }
}

