/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.fonts;

import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.fonts.FontImporter;
import com.jaspersoft.studio.preferences.fonts.FontURLPage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import net.sf.jasperreports.eclipse.util.HttpUtils;
import net.sf.jasperreports.eclipse.util.ZipFilter;
import net.sf.jasperreports.engine.fonts.FontFamily;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Async;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.concurrent.FutureCallback;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class FontURLWizard
extends Wizard {
    private FontURLPage page0;
    private List<FontFamily> fontFamilies = new ArrayList<FontFamily>();
    public static File storage = ConfigurationManager.getStorage("fonts");

    public FontURLWizard(List<FontFamily> fontFamilies) {
        this.setWindowTitle("Fonts");
        this.setNeedsProgressMonitor(true);
        this.fontFamilies = fontFamilies;
    }

    public List<FontFamily> getFonts() {
        return this.fontFamilies;
    }

    public void addPages() {
        this.page0 = new FontURLPage();
        this.addPage((IWizardPage)this.page0);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.JRRuntimeURLWizard_1, -1);
                    try {
                        File path = null;
                        try {
                            path = net.sf.jasperreports.eclipse.util.FileUtils.createTempDir((String)"jssfonts");
                            this.fetch(path, monitor, FontURLWizard.this.page0.getValue());
                            monitor.setTaskName("create destination directory");
                            File destDir = new File(storage, "fonts");
                            monitor.setTaskName("move to destingation directory " + destDir);
                            if (destDir.exists()) {
                                File[] fileArray = path.listFiles();
                                int n = fileArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    File f = fileArray[n2];
                                    try {
                                        File df = new File(destDir, f.getName());
                                        if (df.exists()) {
                                            df.delete();
                                        }
                                        FileUtils.moveFileToDirectory((File)f, (File)destDir, (boolean)true);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    ++n2;
                                }
                            } else {
                                FileUtils.moveDirectory((File)path, (File)destDir);
                            }
                            FontImporter.analyzeFolder(FontURLWizard.this.fontFamilies, destDir, monitor);
                        }
                        catch (Exception e) {
                            if (path != null) {
                                path.delete();
                            }
                            throw e;
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }

                private void fetch(final File toDir, final IProgressMonitor monitor, String url) throws Exception {
                    Executor exec = Executor.newInstance();
                    URI fullURI = new URI(url);
                    HttpUtils.setupProxy((Executor)exec, (URI)fullURI);
                    HttpHost proxy = HttpUtils.getUnauthProxy((Executor)exec, (URI)fullURI);
                    Request req = Request.Get((String)url);
                    if (proxy != null) {
                        req.viaProxy(proxy);
                    }
                    Future future = Async.newInstance().use(exec).execute(req, (ResponseHandler)new ResponseHandler<Content>(){

                        public Content handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                            StatusLine statusLine = response.getStatusLine();
                            HttpEntity entity = response.getEntity();
                            if (statusLine.getStatusCode() >= 300) {
                                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                            }
                            if (entity == null) {
                                throw new ClientProtocolException("Response contains no content");
                            }
                            net.sf.jasperreports.eclipse.util.FileUtils.unZip((InputStream)entity.getContent(), (File)toDir, (IProgressMonitor)monitor, (ZipFilter)new ZipFilter(){

                                public boolean isNecessary(String[] pathComponents) {
                                    String fname = pathComponents[pathComponents.length - 1].toLowerCase();
                                    return fname.endsWith(".ttf") || fname.endsWith(".otf") || fname.endsWith(".svg") || fname.endsWith(".eot") || fname.endsWith(".woff");
                                }
                            });
                            return null;
                        }
                    }, (FutureCallback)new FutureCallback<Content>(){

                        public void failed(Exception ex) {
                            ex.printStackTrace();
                        }

                        public void completed(Content content) {
                        }

                        public void cancelled() {
                        }
                    });
                    while (!future.isDone() && !future.isCancelled()) {
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                        if (!monitor.isCanceled()) continue;
                        future.cancel(true);
                        return;
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            this.page0.setErrorMessage(e.getCause().getMessage());
            return false;
        }
        catch (InterruptedException e) {
            this.page0.setErrorMessage(e.getMessage());
            return false;
        }
        return true;
    }
}

