/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.fonts.utils;

import com.jaspersoft.studio.preferences.fonts.utils.BoldStyler;
import com.jaspersoft.studio.preferences.util.PreferencesUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wb.swt.ResourceManager;

public class FontUtils {
    public static final StyledString.Styler KEYWORDS_STYLER;
    public static final StyledString.Styler PARAMETER_STYLER;
    public static final StyledString.Styler VARIABLE_STYLER;
    public static final StyledString.Styler FIELD_STYLER;
    public static final StyledString.Styler CLASSTYPE_STYLER;
    public static String separator;

    static {
        JFaceResources.getColorRegistry().put("PARAMETER_DARKRED_COLOR", new RGB(127, 0, 83));
        JFaceResources.getColorRegistry().put("PARAMETER_RED_COLOR", new RGB(190, 39, 39));
        JFaceResources.getColorRegistry().put("VARIABLE_BLUE_COLOR", new RGB(41, 41, 255));
        JFaceResources.getColorRegistry().put("FIELD_GREEN_COLOR", new RGB(39, 144, 39));
        JFaceResources.getColorRegistry().put("GRAY_CLASS_TYPE", new RGB(143, 143, 143));
        KEYWORDS_STYLER = new BoldStyler("PARAMETER_DARKRED_COLOR", null);
        PARAMETER_STYLER = new BoldStyler("PARAMETER_RED_COLOR", null);
        VARIABLE_STYLER = StyledString.createColorRegistryStyler((String)"VARIABLE_BLUE_COLOR", null);
        FIELD_STYLER = StyledString.createColorRegistryStyler((String)"FIELD_GREEN_COLOR", null);
        CLASSTYPE_STYLER = StyledString.createColorRegistryStyler((String)"GRAY_CLASS_TYPE", null);
        separator = "__________________";
    }

    public static StyledString.Styler getKeywordStyler() {
        JFaceResources.getColorRegistry().put("PARAMETER_KEYWORD_COLOR", new RGB(206, 92, 0));
        return new BoldStyler("PARAMETER_KEYWORD_COLOR", null);
    }

    public static String[] stringToItems(List<String[]> fontsList, boolean useSeparator) {
        ArrayList<String> itemsList = new ArrayList<String>();
        int index = 0;
        while (index < fontsList.size()) {
            String[] fonts;
            String[] stringArray = fonts = fontsList.get(index);
            int n = fonts.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                itemsList.add(element);
                ++n2;
            }
            if (index + 1 != fontsList.size() && fonts.length > 0 && useSeparator) {
                itemsList.add(separator);
            }
            ++index;
        }
        String[] result = new String[itemsList.size()];
        return itemsList.toArray(result);
    }

    public static String[] stringToItems(List<String[]> fontsList) {
        return FontUtils.stringToItems(fontsList, true);
    }

    public static Font getEditorsFont(JasperReportsConfiguration jconfig) {
        String fontDataStr = null;
        if (jconfig != null) {
            fontDataStr = jconfig.getProperty("internalEditorsFont", FontUtils.getTextEditorFontDataAsString());
        }
        if (fontDataStr == null) {
            fontDataStr = PreferencesUtils.getJaspersoftStudioPrefStore().getString("internalEditorsFont");
        }
        FontData[] fontDataArray = PreferenceConverter.basicGetFontData(fontDataStr);
        return ResourceManager.getFont((String)fontDataArray[0].getName(), (int)fontDataArray[0].getHeight(), (int)fontDataArray[0].getStyle());
    }

    public static FontData getTextEditorFontData() {
        FontData textFontData = PreferenceConverter.getFontData((IPreferenceStore)PreferenceConstants.getPreferenceStore(), (String)"org.eclipse.jface.textfont");
        return textFontData;
    }

    public static String getTextEditorFontDataAsString() {
        FontData editorTextFontData = FontUtils.getTextEditorFontData();
        if (editorTextFontData != null) {
            return PreferenceConverter.getStoredRepresentation((FontData[])new FontData[]{editorTextFontData});
        }
        return null;
    }
}

