/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.fonts.wizard;

import com.jaspersoft.studio.messages.Messages;
import java.io.File;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.fonts.SimpleFontFace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FontFaceFragment {
    private SimpleFontFace fontFace;
    private static String lastLocation;

    protected FontFaceFragment(SimpleFontFace fontFace) {
        this.fontFace = fontFace;
    }

    public Composite createDialogArea(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(3, false));
        Text txt = this.createFileField(cmp, Messages.FontFaceFragment_1, "ttf");
        txt.setText(Misc.nvl((String)this.fontFace.getTtf()));
        txt.setToolTipText(Misc.nvl((String)this.fontFace.getTtf()));
        txt = this.createFileField(cmp, Messages.FontFaceFragment_3, "eot");
        txt.setText(Misc.nvl((String)this.fontFace.getEot()));
        txt.setToolTipText(Misc.nvl((String)this.fontFace.getEot()));
        txt = this.createFileField(cmp, Messages.FontFaceFragment_5, "svg");
        txt.setText(Misc.nvl((String)this.fontFace.getSvg()));
        txt.setToolTipText(Misc.nvl((String)this.fontFace.getSvg()));
        txt = this.createFileField(cmp, Messages.FontFaceFragment_7, "woff");
        txt.setText(Misc.nvl((String)this.fontFace.getWoff()));
        txt.setToolTipText(Misc.nvl((String)this.fontFace.getWoff()));
        new Label(cmp, 0).setText(Messages.FontFaceFragment_0);
        final Combo txtPdf = new Combo(cmp, 2048);
        txtPdf.setItems(new String[]{"Courier", "Courier-Bold", "Courier-BoldOblique", "Courier-Oblique", "Helvetica", "Helvetica-Bold", "Helvetica-BoldOblique", "Helvetica-Oblique", "Symbol", "Times-Roman", "Times-Bold", "Times-BoldItalic", "Times-Italic", "ZapfDingbats", "STSong-Light", "Mhei-Medium", "MSung-Light", "HeiseiKakuGo-W5", "HeiseiMin-W3", "HYGoThic-Medium", "HYSMyeongJo-Medium"});
        txtPdf.setText(Misc.nvl((String)this.fontFace.getPdf()));
        txtPdf.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String fname = txtPdf.getText();
                if (fname.trim().isEmpty()) {
                    fname = null;
                }
                FontFaceFragment.this.fontFace.setPdf(fname);
            }
        });
        return cmp;
    }

    private Text createFileField(Composite composite, String name, final String type) {
        new Label(composite, 0).setText(String.valueOf(name) + " (." + type + ")");
        final Text txt = new Text(composite, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        txt.setLayoutData((Object)gd);
        txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String selected = txt.getText();
                if (selected.trim().isEmpty()) {
                    selected = null;
                }
                if (type.equals("ttf")) {
                    FontFaceFragment.this.fontFace.setTtf(selected, false);
                } else if (type.equals("eot")) {
                    FontFaceFragment.this.fontFace.setEot(selected);
                } else if (type.equals("svg")) {
                    FontFaceFragment.this.fontFace.setSvg(selected);
                } else if (type.equals("woff")) {
                    FontFaceFragment.this.fontFace.setWoff(selected);
                }
            }
        });
        Button button = new Button(composite, 8);
        button.setText(Messages.FontFamilyPage_browseButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(Display.getDefault().getActiveShell(), 4096);
                fd.setText(Messages.FontFamilyPage_browseDialogTitle);
                FontFaceFragment.setupLastLocation(fd);
                String font = null;
                if (type.equals("ttf")) {
                    font = FontFaceFragment.this.fontFace.getTtf();
                } else if (type.equals("eot")) {
                    font = FontFaceFragment.this.fontFace.getEot();
                } else if (type.equals("svg")) {
                    font = FontFaceFragment.this.fontFace.getSvg();
                } else if (type.equals("woff")) {
                    font = FontFaceFragment.this.fontFace.getWoff();
                }
                if (font != null) {
                    fd.setFilterPath(font.substring(0, font.lastIndexOf(File.separatorChar)));
                }
                fd.setFilterExtensions(new String[]{"*." + type + ";*." + type.toUpperCase(), "*.*"});
                String selected = fd.open();
                FontFaceFragment.setLastLocation(fd, selected);
                if (selected != null) {
                    selected = selected.trim();
                    if (type.equals("ttf")) {
                        FontFaceFragment.this.fontFace.setTtf(selected, false);
                    } else if (type.equals("eot")) {
                        FontFaceFragment.this.fontFace.setEot(selected);
                    } else if (type.equals("svg")) {
                        FontFaceFragment.this.fontFace.setSvg(selected);
                    } else if (type.equals("woff")) {
                        FontFaceFragment.this.fontFace.setWoff(selected);
                    }
                    txt.setText(Misc.nvl((String)selected));
                    txt.setToolTipText(Misc.nvl((String)selected));
                }
            }
        });
        return txt;
    }

    public static String setupLastLocation(FileDialog dialog) {
        if (lastLocation == null) {
            lastLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        dialog.setFilterPath(lastLocation);
        return lastLocation;
    }

    public static void setLastLocation(FileDialog dialog, String selected) {
        if (!Misc.isNullOrEmpty((String)selected)) {
            lastLocation = selected.substring(0, selected.lastIndexOf(File.separatorChar));
        } else if (!Misc.isNullOrEmpty((String)dialog.getFileName())) {
            lastLocation = dialog.getFileName();
        }
    }
}

