/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.fonts.wizard;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.fonts.wizard.FontFaceFragment;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.SimpleFontFace;
import net.sf.jasperreports.engine.fonts.SimpleFontFamily;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FontFamilyPage
extends JSSHelpWizardPage {
    private static final String BOLDITALIC = "BOLDITALIC";
    private static final String ITALIC = "ITALIC";
    private static final String BOLD = "BOLD";
    private static final String NORMAL = "normal";
    private SimpleFontFamily fontFamily;
    private Text dsname;
    private Button embedepdf;
    private Combo pdfenc;
    private Button bIsVisible;

    public FontFamilyPage(FontFamily fontFamily) {
        super("fontfamilypage");
        this.setTitle(Messages.FontFamilyPage_dialogTitle);
        this.setDescription(Messages.FontFamilyPage_dialogSubtitle);
        this.fontFamily = (SimpleFontFamily)fontFamily;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        new Label(composite, 0).setText(Messages.FontFamilyPage_familyNameLabel);
        this.dsname = new Text(composite, 2048);
        this.dsname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String dstext = FontFamilyPage.this.dsname.getText();
                if (dstext == null || dstext.trim().equals("")) {
                    FontFamilyPage.this.setErrorMessage(Messages.WizardDatasetNewPage_validation_not_null);
                    FontFamilyPage.this.setPageComplete(false);
                } else {
                    FontFamilyPage.this.setPageComplete(true);
                    FontFamilyPage.this.setErrorMessage(null);
                    FontFamilyPage.this.setMessage(FontFamilyPage.this.getDescription());
                    FontFamilyPage.this.fontFamily.setName(dstext);
                }
            }
        });
        this.dsname.setLayoutData((Object)new GridData(768));
        this.bIsVisible = new Button(composite, 32);
        this.bIsVisible.setText(Messages.FontFamilyPage_0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.bIsVisible.setLayoutData((Object)gd);
        this.bIsVisible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontFamilyPage.this.fontFamily.setVisible(!FontFamilyPage.this.bIsVisible.getSelection());
            }
        });
        CTabFolder tabFolder = new CTabFolder(composite, 0x800880);
        tabFolder.setLayoutData((Object)new GridData(1808));
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        tabFolder.setLayoutData((Object)gd);
        tabFolder.setLayout((Layout)new GridLayout(1, false));
        this.createFileField(tabFolder, Messages.FontFamilyPage_normalLabel, NORMAL);
        tabFolder.setSelection(0);
        this.createFileField(tabFolder, Messages.FontFamilyPage_boldLabel, BOLD);
        this.createFileField(tabFolder, Messages.FontFamilyPage_italicLabel, ITALIC);
        this.createFileField(tabFolder, Messages.FontFamilyPage_boldItalicLabel, BOLDITALIC);
        Group gr = new Group(composite, 0);
        gr.setText(Messages.FontFamilyPage_pdfGroup);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gr.setLayoutData((Object)gd);
        gr.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)gr, 0);
        label.setText(Messages.FontFamilyPage_pdfHintText);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        new Label((Composite)gr, 0).setText(Messages.FontFamilyPage_pdfEncodingLabel);
        this.pdfenc = new Combo((Composite)gr, 2052);
        this.pdfenc.setItems(ModelUtils.getPDFEncodings());
        this.pdfenc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = FontFamilyPage.this.pdfenc.getSelectionIndex();
                if (index > -1 && index < FontFamilyPage.this.pdfenc.getItemCount()) {
                    String pdfencod = ModelUtils.getPDFEncoding2key(FontFamilyPage.this.pdfenc.getItem(index));
                    FontFamilyPage.this.fontFamily.setPdfEncoding(pdfencod.isEmpty() ? null : pdfencod);
                }
            }
        });
        this.pdfenc.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String pdfencod = FontFamilyPage.this.pdfenc.getText();
                pdfencod = pdfencod.isEmpty() ? null : ModelUtils.getPDFEncoding2key(pdfencod);
                FontFamilyPage.this.fontFamily.setPdfEncoding(pdfencod);
            }
        });
        this.embedepdf = new Button((Composite)gr, 32);
        this.embedepdf.setText(Messages.FontFamilyPage_pdfEmbeddedLabel);
        this.embedepdf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontFamilyPage.this.fontFamily.setPdfEmbedded(Boolean.valueOf(FontFamilyPage.this.embedepdf.getSelection()));
            }
        });
        this.fillWidgets();
    }

    private FontFaceFragment createFileField(CTabFolder tabFolder, String name, String type) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(name);
        SimpleFontFace fontFace = new SimpleFontFace((JasperReportsContext)JasperReportsConfiguration.getDefaultInstance());
        if (type.equals(NORMAL)) {
            fontFace = (SimpleFontFace)Misc.nvl((Object)((SimpleFontFace)this.fontFamily.getNormalFace()), (Object)fontFace);
            this.fontFamily.setNormalFace(fontFace);
        } else if (type.equals(BOLD)) {
            fontFace = (SimpleFontFace)Misc.nvl((Object)((SimpleFontFace)this.fontFamily.getBoldFace()), (Object)fontFace);
            this.fontFamily.setBoldFace(fontFace);
        } else if (type.equals(ITALIC)) {
            fontFace = (SimpleFontFace)Misc.nvl((Object)((SimpleFontFace)this.fontFamily.getItalicFace()), (Object)fontFace);
            this.fontFamily.setItalicFace(fontFace);
        } else if (type.equals(BOLDITALIC)) {
            fontFace = (SimpleFontFace)Misc.nvl((Object)((SimpleFontFace)this.fontFamily.getBoldItalicFace()), (Object)fontFace);
            this.fontFamily.setBoldItalicFace(fontFace);
        }
        FontFaceFragment fontFaceDialog = new FontFaceFragment(fontFace);
        Composite cmp = fontFaceDialog.createDialogArea((Composite)tabFolder);
        bptab.setControl((Control)cmp);
        return fontFaceDialog;
    }

    private void fillWidgets() {
        this.dsname.setText(this.fontFamily.getName());
        this.setPageComplete(this.fontFamily.getName() != null);
        this.bIsVisible.setSelection(!this.fontFamily.isVisible());
        String pdfEncoding = this.fontFamily.getPdfEncoding();
        int pdfEncodingIndex = ModelUtils.getPDFEncodingIndex(ModelUtils.getKey4PDFEncoding(pdfEncoding));
        this.pdfenc.select(pdfEncodingIndex >= 0 ? pdfEncodingIndex : 0);
        if (pdfEncodingIndex < 0 && pdfEncoding != null) {
            this.pdfenc.setText(pdfEncoding);
        }
        if (this.fontFamily.isPdfEmbedded() != null) {
            this.embedepdf.setSelection(this.fontFamily.isPdfEmbedded().booleanValue());
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_FONT_EXTENSION;
    }
}

