/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.theme;

import com.jaspersoft.studio.preferences.theme.UITheme;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;

public abstract class ATheme {
    protected Map<String, String> properties = new HashMap<String, String>();
    private String name;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void put(String key, String value) {
        this.properties.put(key, value);
    }

    protected void addProperty(String id, String value) {
        this.properties.put(id, value);
    }

    public static ATheme load(IPreferenceStore store, String n) {
        String[] lines;
        UITheme theme = new UITheme();
        theme.setName(n);
        String t = store.getString("com.jaspersoft.studio.theme.ui." + n);
        if (t == null || t.isEmpty()) {
            return null;
        }
        String[] stringArray = lines = t.split("\n");
        int n2 = lines.length;
        int n3 = 0;
        while (n3 < n2) {
            String line = stringArray[n3];
            String[] prop = line.split("=");
            if (prop != null && prop.length == 2) {
                theme.put(prop[0], prop[1]);
            }
            ++n3;
        }
        return theme;
    }

    public void save(IPreferenceStore store) {
        String value = "";
        for (String key : this.properties.keySet()) {
            value = String.valueOf(value) + key + "=" + this.properties.get(key) + "\n";
        }
        store.setValue("com.jaspersoft.studio.theme.ui." + this.name, value);
    }

    public void apply(IPreferenceStore store) {
        for (String key : this.properties.keySet()) {
            store.setValue(key, this.properties.get(key));
        }
    }

    public abstract Composite createControl(Composite var1, IPreferenceStore var2);
}

