/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.theme;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.theme.ATheme;
import com.jaspersoft.studio.preferences.theme.DarkTheme;
import com.jaspersoft.studio.preferences.theme.LightTheme;
import com.jaspersoft.studio.preferences.theme.TComboEditor;
import com.jaspersoft.studio.preferences.util.FieldEditorOverlayPage;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;

public class ThemesPreferencePage
extends FieldEditorOverlayPage {
    public static final String P_THEME_UI = "com.jaspersoft.studio.theme.ui";
    public static final String P_THEMES_UI = "com.jaspersoft.studio.themes.ui";
    private SelectionAdapter comboListener;
    public static final String PAGE_ID = "com.jaspersoft.studio.preferences.theme.ThemesPreferencePage.property";
    private TComboEditor comboeditor;
    private Button bdel;
    private Composite tcontrol;

    public ThemesPreferencePage() {
        super(1);
        this.setPreferenceStore(JaspersoftStudioPlugin.getInstance().getPreferenceStore());
        this.setMessage(Messages.ThemesPreferencePage_themsTitle);
    }

    @Override
    public void createFieldEditors() {
        Composite cmp = new Composite(this.getFieldEditorParent(), 0);
        String[][] tmatrix = this.getThemes4Combo();
        this.comboeditor = new TComboEditor(P_THEME_UI, Messages.ThemesPreferencePage_themesLabel, tmatrix, cmp){

            protected void doLoad() {
                super.doLoad();
                ThemesPreferencePage.this.setButtonsEnabled();
            }
        };
        this.addField((FieldEditor)this.comboeditor);
        cmp.setLayout((Layout)new GridLayout(3, false));
        Composite bcmp = new Composite(cmp, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        bcmp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        bcmp.setLayoutData((Object)gd);
        Button bnew = new Button(bcmp, 8);
        bnew.setText(Messages.ThemesPreferencePage_newButton);
        bnew.setLayoutData((Object)new GridData(768));
        bnew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ATheme theme;
                String themes = ThemesPreferencePage.this.getPreferenceStore().getString(ThemesPreferencePage.P_THEMES_UI);
                NewDialog dialog = new NewDialog(Display.getDefault().getActiveShell());
                dialog.create();
                if (dialog.open() == 0 && (theme = ATheme.load(ThemesPreferencePage.this.getPreferenceStore(), ThemesPreferencePage.this.comboeditor.getValue())) != null) {
                    theme.setName(dialog.getThemename());
                    ThemesPreferencePage.this.getPreferenceStore().setValue(ThemesPreferencePage.P_THEMES_UI, String.valueOf(themes) + ";" + dialog.getThemename());
                    theme.save(ThemesPreferencePage.this.getPreferenceStore());
                    ThemesPreferencePage.this.comboeditor.refresh(ThemesPreferencePage.this.getThemes4Combo());
                    ThemesPreferencePage.this.comboeditor.setSelection(dialog.getThemename());
                }
            }
        });
        this.bdel = new Button(bcmp, 8);
        this.bdel.setText(Messages.ThemesPreferencePage_removeButton);
        this.bdel.setLayoutData((Object)new GridData(768));
        this.bdel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ATheme theme = ATheme.load(ThemesPreferencePage.this.getPreferenceStore(), ThemesPreferencePage.this.comboeditor.getValue());
                if (theme != null) {
                    String[] tms;
                    String themes = ThemesPreferencePage.this.getPreferenceStore().getString(ThemesPreferencePage.P_THEMES_UI);
                    String value = "";
                    String[] stringArray = tms = themes.split(";");
                    int n = tms.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String t = stringArray[n2];
                        if (!t.equals(theme.getName())) {
                            if (!value.isEmpty()) {
                                value = String.valueOf(value) + ";";
                            }
                            value = String.valueOf(value) + t;
                        }
                        ++n2;
                    }
                    ThemesPreferencePage.this.getPreferenceStore().setValue(ThemesPreferencePage.P_THEMES_UI, value);
                    ThemesPreferencePage.this.getPreferenceStore().setValue(ThemesPreferencePage.P_THEME_UI, "light");
                    ThemesPreferencePage.this.comboeditor.refresh(ThemesPreferencePage.this.getThemes4Combo());
                }
            }
        });
        this.createThemeWidgets(this.getTheme(), cmp);
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ATheme theme;
                if (event.getProperty().equals(ThemesPreferencePage.P_THEME_UI) && (theme = ATheme.load(ThemesPreferencePage.this.getPreferenceStore(), (String)event.getNewValue())) != null) {
                    theme.apply(ThemesPreferencePage.this.getPreferenceStore());
                }
            }
        });
        this.comboListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThemesPreferencePage.this.setButtonsEnabled();
            }
        };
        this.comboeditor.addSelectionListener((SelectionListener)this.comboListener);
        super.createFieldEditors();
    }

    private void createThemeWidgets(ATheme theme, Composite cmp) {
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.tcontrol = theme.createControl(cmp, this.getPreferenceStore());
        this.tcontrol.setLayoutData((Object)gd);
        cmp.layout(true);
    }

    private String[][] getThemes4Combo() {
        String themes = this.getPreferenceStore().getString(P_THEMES_UI);
        String[] tms = themes.split(";");
        String[][] tmatrix = new String[tms.length][2];
        int i = 0;
        while (i < tms.length) {
            tmatrix[i][0] = tms[i];
            tmatrix[i][1] = tms[i];
            ++i;
        }
        return tmatrix;
    }

    public void dispose() {
        if (this.comboeditor != null && this.comboListener != null) {
            this.comboeditor.removeSelectionListener((SelectionListener)this.comboListener);
        }
        super.dispose();
    }

    private ATheme getTheme() {
        return (ATheme)Misc.nvl((Object)ATheme.load(this.getPreferenceStore(), this.getPreferenceStore().getString(P_THEME_UI)), (Object)new LightTheme());
    }

    public static void getDefaults(IPreferenceStore store) {
        LightTheme lt = new LightTheme();
        lt.save(store);
        DarkTheme dt = new DarkTheme();
        dt.save(store);
        store.setDefault(P_THEMES_UI, String.valueOf(lt.getName()) + ";" + dt.getName());
        store.setDefault(P_THEME_UI, lt.getName());
    }

    public void init(IWorkbench workbench) {
    }

    public String getPageId() {
        return PAGE_ID;
    }

    private void setButtonsEnabled() {
        Composite cmp = this.tcontrol.getParent();
        ATheme theme = ATheme.load(this.getPreferenceStore(), this.comboeditor.getValue());
        if (theme != null) {
            this.bdel.setEnabled(!theme.getName().equals("light") && !theme.getName().equals("dark"));
            this.tcontrol.dispose();
            this.createThemeWidgets(theme, cmp);
        }
    }

    class NewDialog
    extends Dialog {
        private String themename;
        private Text tname;

        public NewDialog(Shell shell) {
            super(shell);
            this.themename = Messages.ThemesPreferencePage_themeExampleName;
        }

        public String getThemename() {
            return this.themename;
        }

        public void setThemename(String themename) {
            this.themename = themename;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.ThemesPreferencePage_newThemeDialogTitle);
        }

        protected Control createDialogArea(Composite parent) {
            Composite cmp = new Composite(parent, 0);
            cmp.setLayout((Layout)new GridLayout(2, false));
            cmp.setLayoutData((Object)new GridData(1808));
            new Label(cmp, 0).setText(Messages.ThemesPreferencePage_newThemeNameLabel);
            this.tname = new Text(cmp, 2048);
            GridData gd = new GridData(768);
            gd.horizontalIndent = 16;
            this.tname.setLayoutData((Object)gd);
            return cmp;
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            DataBindingContext binding = new DataBindingContext();
            ControlDecoration controlDecoration = new ControlDecoration((Control)this.tname, 16512);
            controlDecoration.setDescriptionText(Messages.ThemesPreferencePage_duplicateName);
            FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
            controlDecoration.setImage(fieldDecoration.getImage());
            binding.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tname), PojoProperties.value((String)"themename").observe((Object)this), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new StringRequiredValidator(Messages.ThemesPreferencePage_enternameMessage, controlDecoration, this.getButton(0))), null);
            return control;
        }
    }

    class StringRequiredValidator
    implements IValidator {
        private String[] themes;
        private final String errorText;
        private final ControlDecoration controlDecoration;
        private Button okButton;

        public StringRequiredValidator(String errorText, ControlDecoration controlDecoration, Button okButton) {
            this.themes = ThemesPreferencePage.this.getPreferenceStore().getString(ThemesPreferencePage.P_THEMES_UI).split(";");
            this.okButton = okButton;
            this.errorText = errorText;
            this.controlDecoration = controlDecoration;
        }

        public IStatus validate(Object value) {
            if (value instanceof String) {
                String text = (String)value;
                if (text.trim().length() == 0) {
                    this.controlDecoration.show();
                    this.okButton.setEnabled(false);
                    return ValidationStatus.error((String)this.errorText);
                }
                String[] stringArray = this.themes;
                int n = this.themes.length;
                int n2 = 0;
                while (n2 < n) {
                    String t = stringArray[n2];
                    if (t.equals(value)) {
                        this.controlDecoration.show();
                        this.okButton.setEnabled(false);
                        return ValidationStatus.error((String)this.errorText);
                    }
                    ++n2;
                }
            }
            this.okButton.setEnabled(true);
            this.controlDecoration.hide();
            return Status.OK_STATUS;
        }
    }
}

