/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.util;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.Properties;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;

public class JRContextPrefStore
extends EventManager
implements IPreferenceStore {
    private JasperReportsConfiguration jConfig;
    private Properties defaultProperties;
    private boolean dirty = false;

    public JRContextPrefStore(JasperReportsConfiguration jConfig) {
        this.jConfig = jConfig;
        this.defaultProperties = new Properties();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.addListenerObject(listener);
    }

    public boolean contains(String name) {
        return this.jConfig.getProperties().containsKey(name) || this.defaultProperties.containsKey(name);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        Object[] finalListeners = this.getListeners();
        if (!(finalListeners.length <= 0 || oldValue != null && oldValue.equals(newValue))) {
            final PropertyChangeEvent pe = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            int i = 0;
            while (i < finalListeners.length) {
                final IPropertyChangeListener l = (IPropertyChangeListener)finalListeners[i];
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(JFaceResources.getString((String)"PreferenceStore.changeError")){

                    public void run() {
                        l.propertyChange(pe);
                    }
                });
                ++i;
            }
        }
    }

    public boolean getBoolean(String name) {
        Boolean pboolean = this.jConfig.getPropertyBoolean(name);
        if (pboolean != null) {
            return pboolean;
        }
        return false;
    }

    public boolean getDefaultBoolean(String name) {
        Object p = this.defaultProperties.get(name);
        if (p != null) {
            if (p instanceof String) {
                return Boolean.parseBoolean((String)p);
            }
            if (p instanceof Boolean) {
                return (Boolean)p;
            }
        }
        return false;
    }

    public double getDefaultDouble(String name) {
        Object p = this.defaultProperties.get(name);
        if (p != null) {
            if (p instanceof String) {
                try {
                    return Double.parseDouble((String)p);
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (p instanceof Double) {
                return (Double)p;
            }
        }
        return 0.0;
    }

    public float getDefaultFloat(String name) {
        Object p = this.defaultProperties.get(name);
        if (p != null) {
            if (p instanceof String) {
                try {
                    return Float.parseFloat((String)p);
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (p instanceof Float) {
                return ((Float)p).floatValue();
            }
        }
        return 0.0f;
    }

    public int getDefaultInt(String name) {
        Object p = this.defaultProperties.get(name);
        if (p != null) {
            if (p instanceof String) {
                try {
                    return Integer.parseInt((String)p);
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (p instanceof Integer) {
                return (Integer)p;
            }
        }
        return 0;
    }

    public long getDefaultLong(String name) {
        Object p = this.defaultProperties.get(name);
        if (p != null) {
            if (p instanceof String) {
                try {
                    return Long.parseLong((String)p);
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (p instanceof Long) {
                return (Long)p;
            }
        }
        return 0L;
    }

    public String getDefaultString(String name) {
        Object p = this.defaultProperties.get(name);
        if (p != null) {
            if (p instanceof String) {
                return (String)p;
            }
            return p.toString();
        }
        return null;
    }

    public double getDouble(String name) {
        if (name == null) {
            return 0.0;
        }
        Double val = this.jConfig.getPropertyDouble(name);
        if (val != null) {
            return val;
        }
        return 0.0;
    }

    public float getFloat(String name) {
        if (name == null) {
            return 0.0f;
        }
        Float val = this.jConfig.getPropertyFloat(name);
        if (val != null) {
            return val.floatValue();
        }
        return 0.0f;
    }

    public int getInt(String name) {
        if (name == null) {
            return 0;
        }
        Integer val = this.jConfig.getPropertyInteger(name);
        if (val != null) {
            return val;
        }
        return 0;
    }

    public long getLong(String name) {
        if (name == null) {
            return 0L;
        }
        Long val = this.jConfig.getPropertyLong(name);
        if (val != null) {
            return val;
        }
        return 0L;
    }

    public String getString(String name) {
        if (name == null) {
            return null;
        }
        return Misc.nvl((String)this.jConfig.getProperty(name));
    }

    public boolean isDefault(String name) {
        return !this.jConfig.getProperties().containsKey(name) && this.defaultProperties.containsKey(name);
    }

    public boolean needsSaving() {
        return this.dirty;
    }

    public void putValue(String name, String value) {
        String oldValue = this.getString(name);
        if (oldValue == null || !oldValue.equals(value)) {
            this.setValue(name, value);
            this.dirty = true;
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.removeListenerObject(listener);
    }

    public void setDefault(String name, double value) {
        Assert.isTrue((name != null ? 1 : 0) != 0);
        this.defaultProperties.put(name, Double.toString(value));
    }

    public void setDefault(String name, float value) {
        Assert.isTrue((name != null ? 1 : 0) != 0);
        this.defaultProperties.put(name, Float.toString(value));
    }

    public void setDefault(String name, int value) {
        Assert.isTrue((name != null ? 1 : 0) != 0);
        this.defaultProperties.put(name, Integer.toString(value));
    }

    public void setDefault(String name, long value) {
        Assert.isTrue((name != null ? 1 : 0) != 0);
        this.defaultProperties.put(name, Long.toString(value));
    }

    public void setDefault(String name, String defaultObject) {
        Assert.isTrue((name != null ? 1 : 0) != 0);
        if (defaultObject != null) {
            this.defaultProperties.put(name, defaultObject.toString());
        }
    }

    public void setDefault(String name, boolean value) {
        Assert.isTrue((name != null ? 1 : 0) != 0);
        this.defaultProperties.put(name, Boolean.toString(value));
    }

    public void setToDefault(String name) {
        if (!this.jConfig.getProperties().containsKey(name)) {
            return;
        }
        String oldValue = this.jConfig.getProperties().get(name);
        this.jConfig.getProperties().remove(name);
        this.dirty = true;
        Object newValue = null;
        if (this.defaultProperties != null) {
            newValue = this.defaultProperties.get(name);
        }
        this.firePropertyChangeEvent(name, oldValue, newValue);
    }

    public void setValue(String name, double value) {
        double oldValue = this.getDouble(name);
        if (oldValue != value) {
            this.jConfig.setProperty(name, Double.toString(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, new Double(oldValue), new Double(value));
        }
    }

    public void setValue(String name, float value) {
        float oldValue = this.getFloat(name);
        if (oldValue != value) {
            this.jConfig.setProperty(name, Float.toString(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, new Float(oldValue), new Float(value));
        }
    }

    public void setValue(String name, int value) {
        int oldValue = this.getInt(name);
        if (oldValue != value) {
            this.jConfig.setProperty(name, Integer.toString(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, new Integer(oldValue), new Integer(value));
        }
    }

    public void setValue(String name, long value) {
        long oldValue = this.getLong(name);
        if (oldValue != value) {
            this.jConfig.setProperty(name, Long.toString(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, new Long(oldValue), new Long(value));
        }
    }

    public void setValue(String name, String value) {
        String oldValue = this.getString(name);
        if (oldValue != value) {
            this.jConfig.setProperty(name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, boolean value) {
        boolean oldValue = this.getBoolean(name);
        if (oldValue != value) {
            this.jConfig.setProperty(name, Boolean.toString(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, new Boolean(oldValue), new Boolean(value));
        }
    }
}

