/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.preferences.util;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import java.io.IOException;
import java.util.Properties;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;

public final class PreferencesUtils {
    public static final String NET_SF_JASPERREPORTS_JRPROPERTIES = "net.sf.jasperreports.JRPROPERTIES";

    public static void storeJasperReportsProperty(String key, String value) {
        Properties jrProperties = PreferencesUtils.loadJasperReportsProperties();
        if (jrProperties != null) {
            jrProperties.setProperty(key, value);
            PreferencesUtils.getJaspersoftStudioPrefStore().setValue(NET_SF_JASPERREPORTS_JRPROPERTIES, FileUtils.getPropertyAsString((Properties)jrProperties));
        } else {
            JaspersoftStudioPlugin.getInstance().logError(NLS.bind((String)Messages.PreferencesUtils_CannotStoreJRPropertyError, (Object)key), null);
        }
    }

    public static void storeJasperReportsProperty(String[] key, String[] value) {
        Assert.isNotNull((Object)key);
        Assert.isNotNull((Object)value);
        Assert.isTrue((key.length == value.length ? 1 : 0) != 0);
        Properties jrProperties = PreferencesUtils.loadJasperReportsProperties();
        if (jrProperties != null) {
            int i = 0;
            while (i < key.length) {
                jrProperties.setProperty(key[i], value[i]);
                ++i;
            }
            PreferencesUtils.getJaspersoftStudioPrefStore().setValue(NET_SF_JASPERREPORTS_JRPROPERTIES, FileUtils.getPropertyAsString((Properties)jrProperties));
        } else {
            JaspersoftStudioPlugin.getInstance().logError(NLS.bind((String)Messages.PreferencesUtils_CannotStoreJRPropertyError, (Object[])key), null);
        }
    }

    public static String getJasperReportsProperty(String key) {
        Properties jrProperties = PreferencesUtils.loadJasperReportsProperties();
        if (jrProperties != null) {
            return jrProperties.getProperty(key);
        }
        JaspersoftStudioPlugin.getInstance().logError(NLS.bind((String)Messages.PreferencesUtils_CannotReadJRPropertyError, (Object)key), null);
        return null;
    }

    public static IPreferenceStore getJaspersoftStudioPrefStore() {
        return JaspersoftStudioPlugin.getInstance().getPreferenceStore();
    }

    public static Properties loadJasperReportsProperties(String propertiesString) {
        try {
            return FileUtils.load((String)propertiesString);
        }
        catch (IOException e) {
            JaspersoftStudioPlugin.getInstance().logError(Messages.PreferencesUtils_CannotLoadJRPRopertiesError, e);
            return null;
        }
    }

    private static Properties loadJasperReportsProperties() {
        try {
            return FileUtils.load((String)PreferencesUtils.getJaspersoftStudioPrefStore().getString(NET_SF_JASPERREPORTS_JRPROPERTIES));
        }
        catch (IOException e) {
            JaspersoftStudioPlugin.getInstance().logError(Messages.PreferencesUtils_CannotLoadJRPRopertiesError, e);
            return null;
        }
    }
}

