/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.prm;

import com.jaspersoft.studio.prm.ParameterSet;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.CastorHelper;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.preference.IPreferenceStore;
import org.exolab.castor.mapping.Mapping;
import org.xml.sax.InputSource;

public class ParameterSetProvider {
    private JasperReportsConfiguration jrConfig;
    private ParameterSet prmSet;

    public ParameterSetProvider(JasperReportsConfiguration jrConfig) {
        this.jrConfig = jrConfig;
        this.init();
    }

    public static Mapping getMapping() {
        Mapping mapping = new Mapping();
        mapping.loadMapping(new InputSource(ParameterSetProvider.class.getResourceAsStream("/com/jaspersoft/studio/prm/ParameterSet.xml")));
        return mapping;
    }

    private void init() {
        this.prmSet = null;
        String setName = this.jrConfig.getProperty("com.jaspersoft.studio.parameterset");
        this.prmSet = ParameterSetProvider.getParameterSet(setName, (IPreferenceStore)this.jrConfig.getPrefStore());
    }

    public static ParameterSet getParameterSet(String setName, IPreferenceStore pstore) {
        String tmp;
        if (!Misc.isNullOrEmpty((String)setName) && !Misc.isNullOrEmpty((String)(tmp = pstore.getString("com.jaspersoft.studio.parameterset." + setName)))) {
            try {
                tmp = Misc.decodeBase64String((String)tmp, (String)"ISO-8859-1");
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            try {
                tmp = "<?xml version=\"1.0\"?>\n" + tmp;
                return (ParameterSet)CastorHelper.read((InputStream)new ByteArrayInputStream(tmp.getBytes()), (Mapping)ParameterSetProvider.getMapping());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void storeParameterSet(ParameterSet pset, IPreferenceStore pstore) {
        if (pset != null) {
            try {
                String prmset = Misc.encodeBase64String((String)CastorHelper.write((Object)pset, (Mapping)ParameterSetProvider.getMapping()), (String)"ISO-8859-1");
                pstore.setValue("com.jaspersoft.studio.parameterset." + pset.getName(), prmset);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void reset() {
        this.init();
        this.initParameterValues(this.jrConfig.getJRParameters());
    }

    public void initParameterValues(Map<String, Object> prmMap) {
        if (this.prmSet == null) {
            return;
        }
    }

    public void addParameters(ParameterSet set, JasperDesign jd) {
        for (JRDesignParameter p : set.getParameters()) {
            if (jd.getParametersMap().containsKey(p)) continue;
            try {
                jd.addParameter((JRParameter)p.clone());
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        }
    }
}

