/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.prm.dialog;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.MReportRoot;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.model.util.ReportFactory;
import com.jaspersoft.studio.prm.ParameterSet;
import com.jaspersoft.studio.property.dataset.fields.PropertiesDialog;
import com.jaspersoft.studio.property.dataset.fields.table.TColumn;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.IEditElement;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.ParameterEvaluationTimeEnum;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ParameterSetDialog
extends ATitledDialog {
    private int indx = -1;
    private ParameterSet prmSet;
    private Text text;
    private Table table;
    private EditButton<JRDesignParameter> eBtn;
    private MDataset mdataset;
    private List<TColumn> tcolumns = new ArrayList<TColumn>();
    private JasperReportsConfiguration jrConfig;

    public ParameterSetDialog(Shell parentShell, Table table) {
        this(parentShell, -1, new ParameterSet(), table);
    }

    public ParameterSetDialog(Shell parentShell, int indx, ParameterSet prmSet, Table table) {
        super(parentShell);
        this.prmSet = prmSet;
        this.indx = indx;
        this.table = table;
        this.setTitle("Parameter Set");
        this.setDescription("");
        this.setDefaultSize(600, 600);
    }

    public boolean close() {
        this.jrConfig.dispose();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.common_name);
        int style = 2048;
        if (this.prmSet.isBuiltIn()) {
            style |= 8;
        }
        this.text = new Text(composite, style);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.setText(Misc.nvl((String)this.prmSet.getName()));
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ParameterSetDialog.this.setName();
            }
        });
        if (!this.prmSet.isBuiltIn()) {
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParameterSetDialog.this.setName();
                }
            });
        }
        this.createTable(composite);
        ParameterSetDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createTable(final Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        cmp.setLayoutData((Object)gd);
        Label lbl = new Label(cmp, 0);
        lbl.setText("Parameters");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        lbl.setLayoutData((Object)gd);
        TableViewer viewer = new TableViewer(cmp, 68356);
        this.createColumns(viewer);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setInput(this.prmSet.getParameters());
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ParameterSetDialog.this.eBtn.push();
            }
        });
        gd = new GridData(1808);
        gd.verticalSpan = 5;
        gd.grabExcessHorizontalSpace = true;
        table.setLayoutData((Object)gd);
        cmp = new Composite(cmp, 0);
        cmp.setLayout((Layout)new GridLayout());
        gd = new GridData(2);
        gd.widthHint = 80;
        cmp.setLayoutData((Object)gd);
        new NewButton().createNewButtons(cmp, viewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                PropertiesDialog<JRDesignParameter> d = new PropertiesDialog<JRDesignParameter>(parent.getShell(), new JRDesignParameter(), ParameterSetDialog.this.tcolumns, MParameter.getIconDescriptor().getDescription(), ParameterSetDialog.this.jrConfig);
                if (d.open() == 0) {
                    return d.getElement();
                }
                return null;
            }
        });
        new ListOrderButtons().createOrderButtons(cmp, viewer);
        this.eBtn = new EditButton();
        this.eBtn.createEditButtons(cmp, viewer, new IEditElement<JRDesignParameter>(){

            @Override
            public void editElement(List<JRDesignParameter> input, int pos) {
                JRDesignParameter prm = input.get(pos);
                PropertiesDialog<JRDesignParameter> d = new PropertiesDialog<JRDesignParameter>(parent.getShell(), (JRDesignParameter)prm.clone(), ParameterSetDialog.this.tcolumns, MParameter.getIconDescriptor().getDescription(), ParameterSetDialog.this.jrConfig);
                if (d.open() == 0) {
                    input.set(pos, d.getElement());
                }
            }
        });
        new DeleteButton().createDeleteButton(cmp, viewer);
    }

    private void createColumns(TableViewer viewer) {
        TableViewerColumn colFirstName = new TableViewerColumn(viewer, 0);
        colFirstName.getColumn().setWidth(200);
        colFirstName.getColumn().setText("Name");
        colFirstName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                JRDesignParameter p = (JRDesignParameter)element;
                return p.getName();
            }
        });
        colFirstName = new TableViewerColumn(viewer, 0);
        colFirstName.getColumn().setWidth(200);
        colFirstName.getColumn().setText("Description");
        colFirstName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                JRDesignParameter p = (JRDesignParameter)element;
                return p.getDescription();
            }
        });
        JasperDesign jd = new JasperDesign();
        this.jrConfig = JasperReportsConfiguration.getDefaultJRConfig();
        this.jrConfig.setJasperDesign(jd);
        MReportRoot node = new MReportRoot(this.jrConfig, (Object)jd);
        MReport report = new MReport((ANode)node, this.jrConfig);
        this.mdataset = new MDataset((ANode)report, jd.getMainDesignDataset(), -1);
        ReportFactory.createDataset(this.mdataset, jd.getMainDesignDataset(), true);
        this.createNameColumn();
        this.createIsForPrompt();
        this.createTypeColumn();
        this.createNestedTypeColumn();
        this.createDescriptionColumn();
        this.createDefaultExpression();
        this.createEvaluationTime();
        this.createPropertiesColumn();
    }

    private void setValidationError(String message) {
        this.getButton(0).setEnabled(message == null);
        this.setDescription(message);
    }

    public ParameterSet getPValue() {
        return this.prmSet;
    }

    protected void setName() {
        this.setValidationError(null);
        String pname = this.text.getText();
        if (pname.isEmpty()) {
            this.setValidationError("Name can't be empty");
            return;
        }
        int i = 0;
        while (i < this.table.getItemCount()) {
            TableItem ti = this.table.getItem(i);
            if (ti.getText(0).equals(pname) && i != this.indx) {
                this.setValidationError("This name already exists, please select another one");
                return;
            }
            ++i;
        }
        this.prmSet.setName(pname);
    }

    private void createNameColumn() {
        TColumn c = new TColumn();
        c.setPropertyName("name");
        c.setLabel(Messages.ParametersTable_name);
        c.setDescription(Messages.MParameterSystem_name_description);
        c.setValue(this.mdataset);
        this.tcolumns.add(c);
    }

    private void createIsForPrompt() {
        TColumn c = new TColumn();
        c.setPropertyName("forPrompting");
        c.setLabel(Messages.ParametersTable_isForPrompt);
        c.setDescription(Messages.MParameter_is_for_prompting_description);
        c.setPropertyType(Boolean.TYPE.getName());
        this.tcolumns.add(c);
    }

    private void createTypeColumn() {
        TColumn c = new TColumn();
        c.setPropertyName("valueClassName");
        c.setLabel(Messages.ParametersTable_class);
        c.setDescription(Messages.MParameterSystem_class_description);
        c.setPropertyType(Class.class.getName());
        this.tcolumns.add(c);
    }

    private void createNestedTypeColumn() {
        TColumn c = new TColumn();
        c.setPropertyName("nestedTypeName");
        c.setLabel(Messages.MParameter_nested_type_name);
        c.setDescription(Messages.MParameter_nested_type_name_description);
        c.setPropertyType(Class.class.getName());
        this.tcolumns.add(c);
    }

    private void createDefaultExpression() {
        TColumn c = new TColumn();
        c.setPropertyName("defaultValueExpression");
        c.setLabel(Messages.MParameter_default_value_expression);
        c.setDescription(Messages.MParameter_default_value_expression_description);
        c.setPropertyType(JRDesignExpression.class.getName());
        c.setValue(this.mdataset);
        this.tcolumns.add(c);
    }

    private void createDescriptionColumn() {
        TColumn c = new TColumn();
        c.setPropertyName("description");
        c.setLabel(Messages.ParametersTable_description);
        c.setDescription(Messages.MParameter_description_description);
        c.setValue(this.mdataset.getValue());
        this.tcolumns.add(c);
    }

    private void createEvaluationTime() {
        TColumn c = new TColumn();
        c.setPropertyName("evaluationTime");
        c.setLabel(Messages.common_evaluation_time);
        c.setDescription(Messages.MParameter_3);
        c.setValue(this.mdataset.getValue());
        c.setPropertyType(ParameterEvaluationTimeEnum.class.getName());
        this.tcolumns.add(c);
    }

    private void createPropertiesColumn() {
        TColumn c = new TColumn();
        c.setPropertyName("properties");
        c.setLabel(Messages.common_properties);
        c.setDescription(Messages.MParameter_properties_description);
        c.setPropertyType(JRPropertiesMap.class.getName());
        c.setType("properties");
        c.setValue(this.mdataset);
        this.tcolumns.add(c);
    }
}

