/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;

public class ResetValueCommand
extends Command {
    protected Object propertyName;
    protected Object undoValue;
    protected IPropertySource target;
    private List<Command> commands;

    public ResetValueCommand() {
        super(Messages.ResetValueCommand_restore_default_value);
    }

    public boolean canExecute() {
        boolean answer = false;
        if (this.target != null && this.propertyName != null) {
            answer = this.target.isPropertySet(this.propertyName);
            if (this.target instanceof IPropertySource2) {
                answer = answer && ((IPropertySource2)this.target).isPropertyResettable(this.propertyName);
            }
        }
        return answer;
    }

    public void execute() {
        this.undoValue = this.target.getPropertyValue(this.propertyName);
        if (this.undoValue instanceof IPropertySource) {
            this.undoValue = ((IPropertySource)this.undoValue).getEditableValue();
        }
        this.redo();
    }

    public void setTarget(IPropertySource propSource) {
        this.target = propSource;
    }

    public void redo() {
        this.target.resetPropertyValue(this.propertyName);
        if (this.commands == null) {
            this.commands = JaspersoftStudioPlugin.getPostSetValueManager().postSetValue(this.target, this.propertyName, this.target.getPropertyValue(this.propertyName), this.undoValue);
        }
        if (this.commands != null) {
            for (Command c : this.commands) {
                c.execute();
            }
        }
    }

    public void setPropertyId(Object pName) {
        this.propertyName = pName;
    }

    public void undo() {
        if (this.commands != null) {
            for (Command c : this.commands) {
                c.undo();
            }
        }
        this.target.setPropertyValue(this.propertyName, this.undoValue);
    }
}

