/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.color.chooser;

import com.jaspersoft.studio.messages.Messages;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.ResourceManager;

public class ColorPreviewWidget
extends Composite {
    private RGB oldColor = null;
    private int alphaOldColor = 255;
    private RGB newColor = null;
    private int alphaNewColor = 255;
    private Composite colorComposite;
    private Composite additionalComponents;
    private Label oldColorLabel;

    public ColorPreviewWidget(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        Composite left = new Composite((Composite)this, 0);
        left.setLayout((Layout)new GridLayout(1, false));
        left.setLayoutData((Object)new GridData(1040));
        Composite right = new Composite((Composite)this, 0);
        right.setLayout((Layout)new GridLayout(1, false));
        right.setLayoutData((Object)new GridData(1040));
        Label newColorLabel = new Label(left, 0);
        newColorLabel.setText(Messages.ColorDialog_newColorLabel);
        newColorLabel.setLayoutData((Object)new GridData(0x1000000, 1024, false, false));
        this.colorComposite = new Composite(left, 2048);
        this.colorComposite.setLayoutData((Object)new GridData(1808));
        GridData previewData = new GridData();
        previewData.widthHint = 120;
        previewData.heightHint = 50;
        previewData.verticalAlignment = 128;
        this.colorComposite.setLayoutData((Object)previewData);
        new Label(right, 0);
        this.additionalComponents = new Composite(right, 0);
        GridLayout additionalComponentLayout = new GridLayout(1, false);
        additionalComponentLayout.horizontalSpacing = 0;
        additionalComponentLayout.verticalSpacing = 0;
        additionalComponentLayout.marginHeight = 0;
        additionalComponentLayout.marginWidth = 0;
        this.additionalComponents.setLayout((Layout)additionalComponentLayout);
        this.additionalComponents.setLayoutData((Object)new GridData(1808));
        this.oldColorLabel = new Label(left, 0);
        this.oldColorLabel.setText(Messages.ColorDialog_oldColorLabel);
        GridData oldColorLabelData = new GridData(0x1000000, 128, false, false);
        oldColorLabelData.exclude = true;
        this.oldColorLabel.setLayoutData((Object)oldColorLabelData);
        this.oldColorLabel.setVisible(false);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ColorPreviewWidget.this.updatePreview();
            }
        });
        this.colorComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Rectangle rect = ColorPreviewWidget.this.colorComposite.getClientArea();
                int width = rect.width;
                int height = rect.height;
                gc.setAntialias(1);
                if (ColorPreviewWidget.this.oldColor != null) {
                    gc.setAlpha(255);
                    gc.setBackground(ColorPreviewWidget.this.getDisplay().getSystemColor(1));
                    gc.fillRectangle(0, 0, width, height / 2);
                    gc.setAlpha(ColorPreviewWidget.this.alphaNewColor);
                    gc.setBackground(ResourceManager.getColor((RGB)ColorPreviewWidget.this.newColor));
                    gc.fillRectangle(0, 0, width, height / 2);
                    gc.setAlpha(255);
                    gc.setBackground(ColorPreviewWidget.this.getDisplay().getSystemColor(1));
                    gc.fillRectangle(0, height / 2, width, height);
                    gc.setAlpha(ColorPreviewWidget.this.alphaOldColor);
                    gc.setBackground(ResourceManager.getColor((RGB)ColorPreviewWidget.this.oldColor));
                    gc.fillRectangle(0, height / 2, width, height);
                } else {
                    gc.setAlpha(255);
                    gc.setBackground(ColorPreviewWidget.this.getDisplay().getSystemColor(1));
                    gc.fillRectangle(0, 0, width, height);
                    gc.setAlpha(ColorPreviewWidget.this.alphaNewColor);
                    gc.setBackground(ResourceManager.getColor((RGB)ColorPreviewWidget.this.newColor));
                    gc.fillRectangle(0, 0, width, height);
                }
                gc.dispose();
            }
        });
    }

    public Composite getAdditionalComponentarea() {
        return this.additionalComponents;
    }

    public void setNewColor(RGB color, int alphaNewColor) {
        this.newColor = color;
        this.alphaNewColor = alphaNewColor;
        this.updatePreview();
    }

    public void setOldColor(RGB color, int alphaOldColor) {
        this.oldColor = color;
        this.alphaOldColor = alphaOldColor;
        boolean labelVisible = this.oldColor != null;
        ((GridData)this.oldColorLabel.getLayoutData()).exclude = !labelVisible;
        this.oldColorLabel.setVisible(labelVisible);
        this.updatePreview();
    }

    public void updatePreview() {
        if (this.newColor == null) {
            return;
        }
        this.colorComposite.redraw();
    }

    public void dispose() {
        super.dispose();
    }
}

