/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.color.chooser;

import com.jaspersoft.studio.property.color.chooser.IWidgetGovernor;
import com.jaspersoft.studio.utils.UIUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.ResourceCache;

public class ColorsSelectorWidget
extends Composite {
    private Point circlePosition = new Point(0, 0);
    private int sliderPosition = 0;
    private RGB selectedColorRGB = null;
    private float[] selectedColorHSB = new float[3];
    private Composite colorComposite;
    private Composite slider;
    private IWidgetGovernor governor;
    private int arrowWidth = 5;
    private Color borderColor = this.getDisplay().getSystemColor(23);
    private List<SelectionListener> selListeners = new ArrayList<SelectionListener>();
    private ResourceCache imagesCache = new ResourceCache();
    private Image canvasCache = null;
    private Image sliderCache = null;

    public ColorsSelectorWidget(Composite parent, int style, IWidgetGovernor governor, RGB initialColor) {
        super(parent, style);
        this.governor = governor;
        this.selectedColorRGB = initialColor;
        this.selectedColorHSB = initialColor.getHSB();
        this.setBackground(UIUtil.getColor("org.eclipse.ui.workbench.INFORMATION_BACKGROUND"));
        this.setLayout((Layout)new GridLayout(2, false));
        this.colorComposite = new Canvas((Composite)this, 2048);
        this.colorComposite.setLayoutData((Object)new GridData(1808));
        this.slider = new Canvas((Composite)this, 0);
        this.slider.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ColorsSelectorWidget.this.setSelectedColor(ColorsSelectorWidget.this.getSelectedColorRGB(), false);
                ColorsSelectorWidget.this.paintSlider(true);
            }
        });
        this.colorComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ColorsSelectorWidget.this.setSelectedColor(ColorsSelectorWidget.this.getSelectedColorRGB(), false);
                ColorsSelectorWidget.this.paintPad(true);
            }
        });
        GridData rangeData = new GridData(16384, 4, false, true);
        rangeData.widthHint = 20;
        this.slider.setLayoutData((Object)rangeData);
        this.colorComposite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ColorsSelectorWidget.this.padClicked(e);
            }
        });
        this.colorComposite.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if ((e.stateMask & 0x80000) != 0) {
                    ColorsSelectorWidget.this.padClicked(e);
                }
            }
        });
        this.colorComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                if (ColorsSelectorWidget.this.canvasCache != null && !ColorsSelectorWidget.this.canvasCache.isDisposed()) {
                    gc.drawImage(ColorsSelectorWidget.this.canvasCache, 0, 0);
                    if (ColorsSelectorWidget.this.circlePosition != null) {
                        gc.setForeground(ColorsSelectorWidget.this.getDisplay().getSystemColor(1));
                        gc.setAntialias(1);
                        gc.drawOval(ColorsSelectorWidget.this.circlePosition.x - 2, ColorsSelectorWidget.this.circlePosition.y - 2, 8, 8);
                        gc.setForeground(ColorsSelectorWidget.this.getDisplay().getSystemColor(2));
                        gc.drawOval(ColorsSelectorWidget.this.circlePosition.x - 1, ColorsSelectorWidget.this.circlePosition.y - 1, 6, 6);
                    }
                }
                gc.dispose();
            }
        });
        this.slider.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ColorsSelectorWidget.this.sliderClicked(e);
            }
        });
        this.slider.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle rect = ColorsSelectorWidget.this.slider.getBounds();
                int width = rect.width;
                GC gc = e.gc;
                if (ColorsSelectorWidget.this.sliderCache != null && !ColorsSelectorWidget.this.sliderCache.isDisposed()) {
                    gc.drawImage(ColorsSelectorWidget.this.sliderCache, 0, 0);
                    gc.setBackground(ColorsSelectorWidget.this.getDisplay().getSystemColor(2));
                    int[] nArray = new int[6];
                    nArray[1] = ColorsSelectorWidget.this.sliderPosition - 3;
                    nArray[2] = ColorsSelectorWidget.this.arrowWidth;
                    nArray[3] = ColorsSelectorWidget.this.sliderPosition;
                    nArray[5] = ColorsSelectorWidget.this.sliderPosition + 3;
                    gc.fillPolygon(nArray);
                    gc.fillPolygon(new int[]{width, ColorsSelectorWidget.this.sliderPosition - 3, width - ColorsSelectorWidget.this.arrowWidth, ColorsSelectorWidget.this.sliderPosition, width, ColorsSelectorWidget.this.sliderPosition + 3});
                }
                gc.dispose();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ColorsSelectorWidget.this.imagesCache != null) {
                    ColorsSelectorWidget.this.imagesCache.dispose();
                    ColorsSelectorWidget.this.imagesCache = null;
                }
                if (ColorsSelectorWidget.this.canvasCache != null) {
                    ColorsSelectorWidget.this.canvasCache.dispose();
                    ColorsSelectorWidget.this.canvasCache = null;
                }
                if (ColorsSelectorWidget.this.sliderCache != null) {
                    ColorsSelectorWidget.this.sliderCache.dispose();
                    ColorsSelectorWidget.this.sliderCache = null;
                }
            }
        });
    }

    public void setSelectedColor(float h, float s, float b, boolean callListener) {
        if (h < 0.0f || h > 360.0f || s < 0.0f || s > 1.0f || b < 0.0f || b > 1.0f) {
            return;
        }
        RGB color = new RGB(h, s, b);
        int[] relativePositions = this.governor.getXYSlider(new float[]{h, s, b});
        int relativeSlide = relativePositions[2];
        int newSliderPosition = this.getAbsoluteSliderFromRelative(relativeSlide);
        if (this.sliderPosition != newSliderPosition) {
            this.sliderPosition = newSliderPosition;
        }
        int relativeX = relativePositions[0];
        int relativeY = relativePositions[1];
        Point newCirclePosition = new Point(this.getAbsoluteXFromRelative(relativeX), this.getAbsoluteYFromRelative(relativeY));
        if (this.circlePosition != newCirclePosition) {
            this.circlePosition = new Point(this.getAbsoluteXFromRelative(relativeX), this.getAbsoluteYFromRelative(relativeY));
        }
        this.selectedColorRGB = color;
        this.selectedColorHSB = new float[]{h, s, b};
        this.paintSlider(false);
        this.paintPad(false);
        if (callListener) {
            this.callSelectionListeners();
        }
    }

    public void setSelectedColor(RGB color, boolean callListener) {
        if (color == null) {
            return;
        }
        int[] relativePositions = this.governor.getXYSlider(color);
        int relativeSlide = relativePositions[2];
        int newSliderPosition = this.getAbsoluteSliderFromRelative(relativeSlide);
        if (this.sliderPosition != newSliderPosition) {
            this.sliderPosition = newSliderPosition;
        }
        int relativeX = relativePositions[0];
        int relativeY = relativePositions[1];
        Point newCirclePosition = new Point(this.getAbsoluteXFromRelative(relativeX), this.getAbsoluteYFromRelative(relativeY));
        if (this.circlePosition != newCirclePosition) {
            this.circlePosition = new Point(this.getAbsoluteXFromRelative(relativeX), this.getAbsoluteYFromRelative(relativeY));
        }
        this.selectedColorRGB = color;
        this.selectedColorHSB = color.getHSB();
        this.paintSlider(false);
        this.paintPad(false);
        if (callListener) {
            this.callSelectionListeners();
        }
    }

    public RGB getSelectedColorRGB() {
        return this.selectedColorRGB;
    }

    public float[] getSelectedColorHSB() {
        return this.selectedColorHSB;
    }

    public void setGovernor(IWidgetGovernor newGovernor) {
        this.governor = newGovernor;
        this.paintPad(true);
        this.paintSlider(true);
        this.callSelectionListeners();
    }

    public void setSlider(int slider) {
        this.sliderPosition = slider;
        this.paintPad(true);
        this.paintSlider(false);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selListeners.add(listener);
    }

    private void padClicked(MouseEvent e) {
        this.updatePosition(e);
        this.paintPad(false);
        this.paintSlider(false);
        this.setSelectedColorFromImage();
        this.callSelectionListeners();
    }

    private void sliderClicked(MouseEvent e) {
        this.updateSlider(e);
        this.setSelectedColorFromImage();
        this.paintSlider(false);
        this.paintPad(true);
        this.callSelectionListeners();
    }

    private void setSelectedColorFromImage() {
        RGB color;
        Rectangle bounds = this.colorComposite.getBounds();
        float factorX = (float)this.governor.getPadMaxX() / (float)bounds.width;
        float factorY = (float)this.governor.getPadMaxY() / (float)bounds.height;
        int slider = Math.round((float)this.governor.getSliderMax() / (float)this.getSliderHeight() * (float)this.sliderPosition);
        this.selectedColorRGB = color = this.governor.getPadColor(Math.round((float)this.circlePosition.x * factorX), Math.round((float)this.circlePosition.y * factorY), slider);
        this.selectedColorHSB = this.selectedColorRGB.getHSB();
    }

    private void callSelectionListeners() {
        Event e = new Event();
        e.widget = this;
        SelectionEvent event = new SelectionEvent(e);
        event.data = this.selectedColorRGB;
        for (SelectionListener listener : this.selListeners) {
            listener.widgetSelected(event);
        }
    }

    private void updatePosition(MouseEvent e) {
        Rectangle rect = this.colorComposite.getClientArea();
        int x = Math.max(0, e.x);
        x = Math.min(x, rect.width - 1);
        int y = Math.max(0, e.y);
        y = Math.min(y, rect.height - 1);
        this.circlePosition = new Point(x, y);
    }

    private void updateSlider(MouseEvent e) {
        Rectangle rect = this.slider.getClientArea();
        int y = Math.max(0, e.y);
        this.sliderPosition = y = Math.min(y, rect.height);
    }

    private int getAbsoluteXFromRelative(int relativeX) {
        Rectangle rect = this.colorComposite.getClientArea();
        if (rect.width == 0) {
            return 0;
        }
        int padWidth = this.governor.getPadMaxX() - this.governor.getPadMinX();
        return relativeX * (rect.width - 1) / padWidth;
    }

    private int getAbsoluteYFromRelative(int relativeY) {
        Rectangle rect = this.colorComposite.getClientArea();
        if (rect.height == 0) {
            return 0;
        }
        int padHeight = this.governor.getPadMaxY() - this.governor.getPadMinY();
        return relativeY * (rect.height - 1) / padHeight;
    }

    private int getAbsoluteSliderFromRelative(int relativeSlider) {
        Rectangle rect = this.slider.getClientArea();
        if (rect.height == 0) {
            return 0;
        }
        int sliderHeight = this.governor.getSliderMax() - this.governor.getSliderMin();
        return relativeSlider * (rect.height - 1) / sliderHeight;
    }

    private int getSliderHeight() {
        Rectangle sliderRect = this.slider.getClientArea();
        return sliderRect.height;
    }

    private int getPadWidth() {
        Rectangle padRect = this.colorComposite.getClientArea();
        return padRect.width;
    }

    private int getPadHeight() {
        Rectangle padRect = this.colorComposite.getClientArea();
        return padRect.height;
    }

    private void paintCanvas(GC gc, int width, int height) {
        int padWidth = this.governor.getPadMaxX() - this.governor.getPadMinX();
        int padHeight = this.governor.getPadMaxY() - this.governor.getPadMinY();
        int[] relativePositions = this.governor.getXYSlider(this.selectedColorRGB);
        int slider = Math.round(relativePositions[2]);
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                float padX = (float)(i * padWidth) / (float)(width - 1);
                float padY = (float)(j * padHeight) / (float)(height - 1);
                gc.setForeground(this.imagesCache.getColor(this.governor.getPadColor(Math.round(padX), Math.round(padY), slider)));
                gc.drawPoint(i, j);
                ++j;
            }
            ++i;
        }
    }

    private void paintSlider(GC gc, int width, int height) {
        gc.setForeground(this.borderColor);
        gc.drawRectangle(this.arrowWidth, 0, width - this.arrowWidth * 2, height - 1);
        int padWidth = this.governor.getPadMaxX() - this.governor.getPadMinX();
        int padHeight = this.governor.getPadMaxY() - this.governor.getPadMinY();
        float padX = (float)(this.circlePosition.x * padWidth) / (float)(this.getPadWidth() - 1);
        float padY = (float)(this.circlePosition.y * padHeight) / (float)(this.getPadHeight() - 1);
        int sliderHeight = this.governor.getSliderMax() - this.governor.getSliderMin();
        int y = 0;
        while (y < height) {
            float actaulSlider = (float)sliderHeight / (float)this.getSliderHeight() * (float)y;
            RGB actualHueColor = this.governor.getSliderColor(Math.round(padX), Math.round(padY), Math.round(actaulSlider));
            int x = 0;
            while (x < width) {
                gc.setForeground(this.imagesCache.getColor(actualHueColor));
                gc.drawPoint(x, y);
                ++x;
            }
            ++y;
        }
    }

    private void paintSlider(boolean forceRepaint) {
        if (forceRepaint) {
            if (this.sliderCache != null) {
                this.sliderCache.dispose();
            }
            Rectangle bound = this.slider.getBounds();
            if (bound.width > 0 && bound.height > 0) {
                this.sliderCache = new Image((Device)Display.getCurrent(), bound.width, bound.height);
                GC gc = new GC((Drawable)this.sliderCache);
                this.paintSlider(gc, bound.width, bound.height);
                gc.dispose();
            }
        }
        this.slider.redraw();
    }

    private void paintPad(boolean forceRepaint) {
        if (forceRepaint) {
            if (this.canvasCache != null) {
                this.canvasCache.dispose();
            }
            Rectangle bound = this.colorComposite.getBounds();
            if (bound.width > 0 && bound.height > 0) {
                this.canvasCache = new Image((Device)Display.getCurrent(), bound.width, bound.height);
                GC gc = new GC((Drawable)this.canvasCache);
                this.paintCanvas(gc, bound.width, bound.height);
                gc.dispose();
            }
        }
        this.colorComposite.redraw();
    }
}

