/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.combomenu;

import com.jaspersoft.studio.property.combomenu.HelpProvider;
import com.jaspersoft.studio.property.combomenu.IMenuProvider;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.swt.ResourceManager;

public class ComboButton
extends Viewer {
    public static final int NORMAL = 0;
    public static final int NO_TEXT = 1;
    public static final int NO_IMAGE = 2;
    public static final int NO_ARROWS = 4;
    private static final boolean DRAWS_FOCUS = Util.isMac();
    protected static final int MARGIN = DRAWS_FOCUS ? 4 : 1;
    protected static final int CORNER_SIZE = 5;
    protected static final int BORDER = 3;
    protected static final int FOCUS_CORNER_SIZE = 3;
    protected static final int FOCUS_BORDER = 2;
    protected static final int IMAGE_TEXT_SPACING = 3;
    protected static final int CONTENT_ARROW_SPACING = 4;
    protected static final int ARROW_WIDTH = 7;
    protected static final int ARROW_HEIGHT = 4;
    protected static final int ARROWS_SPACING = 2;
    protected static final String ELLIPSIS = "...";
    private Composite control;
    private int style;
    private String text = null;
    private Image image = null;
    private Color textForeground = null;
    private Color textBackground = null;
    private boolean hovered = false;
    private boolean pressed = false;
    private Point textSize = null;
    private Point imageSize = null;
    private List<IOpenListener> openListeners = null;
    private IMenuProvider menuProvider;
    private Point cachedTextSize = null;
    private Point cachedImageSize = null;
    private String appliedText = null;
    private Rectangle bounds = null;
    private Rectangle contentArea = null;
    private Point arrowLoc = null;
    private Rectangle imgArea = null;
    private Rectangle textArea = null;

    public int getWidth() {
        Point imageSize = this.getImageSize();
        Point textSize = this.getTextSize();
        int width = MARGIN * 2 + imageSize.x + textSize.x + 6;
        if (this.hasArrows()) {
            width += 11;
        }
        if (imageSize.x != 0 && textSize.x != 0) {
            width += 3;
        }
        return width;
    }

    public ComboButton(Composite parent, int style, String biggerString, IMenuProvider menuProvider) {
        this.style = ComboButton.checkStyle(style, 0, 0, 1, 2) | ComboButton.checkStyle(style, 0, 4);
        this.menuProvider = menuProvider;
        this.control = new GraphicButton(parent, biggerString);
        this.hookControl((Control)this.control);
    }

    protected void hookControl(Control control) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        ComboButton.this.paint(event.gc, event.display);
                        break;
                    }
                    case 11: {
                        ComboButton.this.clearCaches();
                        break;
                    }
                    case 3: {
                        if (event.button != 1) break;
                        ComboButton.this.handleMousePress();
                        break;
                    }
                    case 4: {
                        if (event.button != 1) break;
                        ComboButton.this.handleMouseRelease();
                        break;
                    }
                    case 6: {
                        ComboButton.this.handleMouseEnter();
                        break;
                    }
                    case 7: {
                        ComboButton.this.handleMouseExit();
                        break;
                    }
                    case 1: {
                        ComboButton.this.handleKeyPress(event);
                        break;
                    }
                    case 15: {
                        ComboButton.this.handleFocusIn();
                        break;
                    }
                    case 0x1000051: {
                        break;
                    }
                    case 16: {
                        ComboButton.this.handleFocusOut();
                    }
                }
            }
        };
        control.addListener(9, listener);
        control.addListener(11, listener);
        control.addListener(3, listener);
        control.addListener(4, listener);
        control.addListener(6, listener);
        control.addListener(7, listener);
        control.addListener(1, listener);
        control.addListener(15, listener);
        control.addListener(16, listener);
    }

    protected void handleMousePress() {
        if (!this.getControl().isEnabled()) {
            return;
        }
        this.setHovered(false);
        this.fireOpen();
    }

    protected void handleMouseRelease() {
        if (!this.getControl().isEnabled()) {
            return;
        }
        this.setHovered(false);
    }

    protected void handleMouseEnter() {
        if (!this.getControl().isEnabled()) {
            return;
        }
        this.setHovered(true);
    }

    protected void handleMouseExit() {
        if (!this.getControl().isEnabled()) {
            return;
        }
        this.setHovered(false);
    }

    protected void handleFocusIn() {
        if (!this.getControl().isEnabled()) {
            return;
        }
        this.refreshControl();
    }

    protected void handleFocusOut() {
        if (!this.getControl().isEnabled()) {
            return;
        }
        this.setPressed(false);
        this.refreshControl();
    }

    protected void handleKeyPress(Event e) {
        if (!this.getControl().isEnabled()) {
            return;
        }
    }

    public void addOpenListener(IOpenListener listener) {
        if (this.openListeners == null) {
            this.openListeners = new ArrayList<IOpenListener>();
        }
        this.openListeners.add(listener);
    }

    public void removeOpenListener(IOpenListener listener) {
        if (this.openListeners == null) {
            return;
        }
        this.openListeners.remove(listener);
    }

    protected void fireOpen(final OpenEvent event) {
        if (this.openListeners == null) {
            return;
        }
        Object[] objectArray = this.openListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object l = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IOpenListener)l).open(event);
                }
            });
            ++n2;
        }
    }

    protected void fireOpen() {
        this.fireOpen(new OpenEvent((Viewer)this, this.getSelection()));
    }

    public Control getControl() {
        return this.control;
    }

    protected int getStyle() {
        return this.style;
    }

    public String getText() {
        return this.text;
    }

    public Image getImage() {
        return this.image;
    }

    public boolean hasText() {
        return this.text != null && (this.style & 1) == 0;
    }

    public boolean hasImage() {
        return this.image != null && (this.style & 2) == 0;
    }

    protected boolean hasArrows() {
        return (this.style & 4) == 0;
    }

    public Color getTextForeground() {
        return this.textForeground;
    }

    public Color getTextBackground() {
        return this.textBackground;
    }

    public void setTextForeground(Color c) {
        if (c == this.textForeground || c != null && c.equals((Object)this.textForeground)) {
            return;
        }
        this.textForeground = c;
        this.refreshControl();
    }

    public void setTextBackground(Color c) {
        if (c == this.textBackground || c != null && c.equals((Object)this.textBackground)) {
            return;
        }
        this.textBackground = c;
        this.refreshControl();
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setHovered(boolean hovered) {
        if (hovered == this.hovered) {
            return;
        }
        this.hovered = hovered;
        this.refreshControl();
    }

    public void setPressed(boolean pressed) {
        if (pressed == this.pressed) {
            return;
        }
        this.pressed = pressed;
        this.refreshControl();
    }

    public void setText(String text) {
        if (text == this.text || text != null && text.equals(this.text)) {
            return;
        }
        this.text = text;
        this.cachedTextSize = null;
        this.clearCaches();
        this.refreshControl();
    }

    public void setImage(Image image) {
        if (image == this.image) {
            return;
        }
        this.image = image;
        this.cachedImageSize = null;
        this.clearCaches();
        this.refreshControl();
    }

    public void setImage(ImageDescriptor imageDesc) {
        if (imageDesc != null) {
            Image image = ResourceManager.getImage((ImageDescriptor)imageDesc);
            if (image == this.image) {
                return;
            }
            this.image = image;
            this.cachedImageSize = null;
            this.clearCaches();
            this.refreshControl();
        }
    }

    public Point getTextSize() {
        if (this.textSize != null) {
            return this.textSize;
        }
        if (this.cachedTextSize == null) {
            this.cachedTextSize = this.calcTextSize();
        }
        return this.cachedTextSize;
    }

    public Point getImageSize() {
        if (this.imageSize != null) {
            return this.imageSize;
        }
        if (this.cachedImageSize == null) {
            this.cachedImageSize = this.calcImageSize();
        }
        return this.cachedImageSize;
    }

    public void setTextSize(Point size) {
        if (size == this.textSize || size != null && size.equals((Object)this.textSize)) {
            return;
        }
        this.textSize = size;
        this.cachedTextSize = null;
        this.refreshControl();
    }

    public void setImageSize(Point size) {
        if (size == this.imageSize || size != null && size.equals((Object)this.imageSize)) {
            return;
        }
        this.imageSize = size;
        this.cachedImageSize = null;
        this.refreshControl();
    }

    protected Point calcTextSize() {
        Point size;
        String string = this.getText();
        if (!this.hasText()) {
            if ((this.style & 1) != 0) {
                return new Point(0, 0);
            }
            string = "X";
        }
        GC gc = new GC((Drawable)this.getControl().getDisplay());
        try {
            gc.setFont(this.getControl().getFont());
            size = gc.stringExtent(string);
        }
        finally {
            gc.dispose();
        }
        if (size.x == 0 && this.hasText()) {
            size.x = 5;
        }
        return size;
    }

    public void setMaximumTextSize(String text) {
        this.cachedTextSize = this.calcTextSize(text);
    }

    protected Point calcTextSize(String text) {
        Point size;
        GC gc = new GC((Drawable)UIUtils.getDisplay());
        try {
            gc.setFont(UIUtils.getDisplay().getSystemFont());
            gc.getFont().getFontData()[0].setStyle(1);
            size = gc.stringExtent(text.concat("  "));
        }
        finally {
            gc.dispose();
        }
        if (size.x == 0 && this.hasText()) {
            size.x = 5;
        }
        return size;
    }

    protected Point calcImageSize() {
        Point size = new Point(0, 0);
        if (this.hasImage()) {
            Rectangle bounds = this.image.getBounds();
            size.x = Math.max(size.x, bounds.width);
            size.y = Math.max(size.y, bounds.height);
        }
        return size;
    }

    public void setEnabled(boolean enabled) {
        this.getControl().setEnabled(enabled);
        this.refreshControl();
    }

    public boolean isEnabled() {
        return this.getControl().isEnabled();
    }

    public String getAppliedText() {
        if (this.appliedText == null) {
            this.buildCaches();
        }
        return this.appliedText;
    }

    protected void clearCaches() {
        this.appliedText = null;
        this.bounds = null;
        this.contentArea = null;
        this.arrowLoc = null;
        this.imgArea = null;
        this.textArea = null;
    }

    protected void buildCaches() {
        this.bounds = this.control.getClientArea();
        this.bounds.x += MARGIN;
        this.bounds.y += MARGIN;
        this.bounds.width -= MARGIN * 2;
        this.bounds.height -= MARGIN * 2;
        int x1 = this.bounds.x + 3;
        int y1 = this.bounds.y + 3;
        int w1 = this.bounds.width - 6;
        int h1 = this.bounds.height - 6;
        boolean hasArrows = this.hasArrows();
        if (hasArrows) {
            this.arrowLoc = new Point(x1 + w1 + 1 - 7, y1 + (h1 - 8 - 2) / 2 - 1);
        }
        this.contentArea = new Rectangle(x1, y1, w1 - (hasArrows ? 11 : 0), h1);
        boolean hasImage = this.hasImage();
        boolean hasText = this.hasText();
        if (hasImage) {
            if (hasText) {
                Point imgSize = this.getImageSize();
                this.imgArea = new Rectangle(x1, y1, imgSize.x, h1);
            } else {
                this.imgArea = this.contentArea;
            }
        }
        if (hasText) {
            if (hasImage) {
                int w = this.imgArea.width + 3;
                this.textArea = new Rectangle(this.imgArea.x + w, y1, this.contentArea.width - w, h1);
            } else {
                this.textArea = this.contentArea;
            }
            int maxTextWidth = this.textArea.width;
            Point textSize = this.getTextSize();
            if (textSize.x > maxTextWidth) {
                GC gc = new GC((Drawable)this.getControl().getDisplay());
                try {
                    gc.setFont(this.getControl().getFont());
                    this.appliedText = String.valueOf(ComboButton.getSubString(gc, this.text, maxTextWidth - gc.stringExtent((String)ELLIPSIS).x)) + ELLIPSIS;
                }
                finally {
                    gc.dispose();
                }
            } else {
                this.appliedText = this.text;
            }
        }
    }

    protected void paint(GC gc, Display display) {
        Rectangle clipping;
        int h;
        int w;
        int y;
        int x;
        boolean hasBackgroundAndBorder;
        if (this.bounds == null) {
            this.buildCaches();
        }
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        boolean focused = this.getControl().isFocusControl();
        boolean bl = hasBackgroundAndBorder = this.pressed || this.hovered || focused;
        if (hasBackgroundAndBorder) {
            gc.setBackground(this.getBorderBackground(display));
            gc.fillRoundRectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, 5, 5);
        }
        if (focused) {
            x = this.contentArea.x - 2;
            y = this.contentArea.y - 2;
            w = this.contentArea.width + 4;
            h = this.contentArea.height + 4;
            gc.setBackground(this.getRealTextBackground(display));
            gc.fillRoundRectangle(x, y, w, h, 3, 3);
        }
        boolean hasImage = this.hasImage();
        boolean hasText = this.hasText();
        if (hasImage && ((clipping = gc.getClipping()) == null || clipping.intersects(this.imgArea))) {
            Point imgSize = this.getImageSize();
            x = this.imgArea.x + (this.imgArea.width - imgSize.x) / 2;
            y = this.imgArea.y + (this.imgArea.height - imgSize.y) / 2;
            gc.setClipping(this.imgArea);
            gc.drawImage(this.image, x, y);
            gc.setClipping(clipping);
        }
        if (hasText && ((clipping = gc.getClipping()) == null || clipping.intersects(this.textArea))) {
            String text = this.getAppliedText();
            gc.setFont(this.getControl().getFont());
            Point ext = gc.stringExtent(text);
            x = this.textArea.x;
            y = this.textArea.y + (this.textArea.height - ext.y) / 2;
            gc.setClipping(this.textArea);
            gc.setForeground(this.getRealTextForeground(display));
            gc.drawString(text, x, y, true);
            gc.setClipping(clipping);
        }
        if (this.hasArrows() && this.arrowLoc != null) {
            gc.setBackground(ColorConstants.black);
            x = this.arrowLoc.x + 3;
            y = this.arrowLoc.y + 8;
            int x1 = this.arrowLoc.x;
            int x2 = this.arrowLoc.x + 7;
            int y1 = y - 4;
            gc.fillPolygon(new int[]{x, y, x2, y1, x1 - 1, y1});
        }
        x = this.bounds.x;
        y = this.bounds.y;
        w = this.bounds.width;
        h = this.bounds.height;
        gc.setForeground(this.getBorderForeground(display, focused));
        gc.drawRoundRectangle(x, y, w, h, 5, 5);
    }

    private Color getRealTextForeground(Display display) {
        if (this.textForeground != null) {
            return this.textForeground;
        }
        if (!this.getControl().isEnabled()) {
            return display.getSystemColor(15);
        }
        return display.getSystemColor(24);
    }

    private Color getRealTextBackground(Display display) {
        if (this.textBackground != null) {
            return this.textBackground;
        }
        return display.getSystemColor(25);
    }

    private Color getBorderBackground(Display display) {
        if (this.pressed) {
            return display.getSystemColor(22);
        }
        return display.getSystemColor(19);
    }

    private Color getBorderForeground(Display display, boolean focused) {
        if (focused) {
            return display.getSystemColor(23);
        }
        return display.getSystemColor(18);
    }

    protected static int checkStyle(int style, int defaultValue, int ... bits) {
        int[] nArray = bits;
        int n = bits.length;
        int n2 = 0;
        while (n2 < n) {
            int bit = nArray[n2];
            int s = style & bit;
            if (s != 0) {
                return s;
            }
            ++n2;
        }
        return defaultValue;
    }

    protected static String getSubString(GC gc, String string, int maxWidth) {
        Point ext = gc.stringExtent(string);
        if (ext.x <= maxWidth || string.length() == 0) {
            return string;
        }
        return ComboButton.getSubString(gc, string.substring(0, string.length() - 1), maxWidth);
    }

    public Object getInput() {
        return null;
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this);
    }

    public void refresh() {
    }

    public void refreshControl() {
        this.getControl().redraw();
    }

    public void setInput(Object input) {
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public class GraphicButton
    extends Canvas {
        private HelpListener lastListener;
        private Point textSize;

        public GraphicButton(Composite parent, String biggerString) {
            super(parent, 0x20000000);
            this.lastListener = null;
            this.textSize = ComboButton.this.calcTextSize(biggerString.toUpperCase());
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            int width;
            this.checkWidget();
            if (changed) {
                ComboButton.this.clearCaches();
            }
            Point imageSize = ComboButton.this.getImageSize();
            boolean hasArrows = ComboButton.this.hasArrows();
            if (wHint != -1) {
                width = Math.max(wHint, MARGIN * 2);
            } else {
                width = MARGIN * 2 + imageSize.x + this.textSize.x + 6;
                if (hasArrows) {
                    width += 11;
                }
                if (imageSize.x != 0 && this.textSize.x != 0) {
                    width += 3;
                }
            }
            int minHeight = MARGIN * 2 + Math.max(imageSize.y, this.textSize.y) + 6;
            if (hasArrows) {
                minHeight = Math.max(minHeight, 10);
            }
            int height = minHeight;
            Rectangle trim = this.computeTrim(0, 0, width, height);
            return new Point(trim.width, trim.height);
        }

        public void addHelpListener(HelpListener listener) {
            HelpProvider contextHelp = new HelpProvider(ComboButton.this.menuProvider.getMenu());
            this.lastListener = contextHelp.setHelp(ComboButton.this.control.getData("org.eclipse.ui.help").toString());
        }

        public void removeHelpListener(HelpListener listener) {
            if (this.lastListener != null) {
                super.removeHelpListener(this.lastListener);
                this.lastListener = null;
            }
        }
    }
}

