/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.dataset.ExpressionWidget;
import java.sql.Connection;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DatasetRunWidget
implements IExpressionContextSetter {
    public static final String[] ITEMS = new String[]{Messages.WizardConnectionPage_noconnection_text, Messages.WizardConnectionPage_connection_text, Messages.WizardConnectionPage_datasource_text, Messages.WizardConnectionPage_mainreport_text, Messages.WizardConnectionPage_empty_connection_text};
    private JRDesignDatasetRun datasetrun;
    private Composite control;
    private StackLayout layout;
    private Composite emptyComposite;
    private Composite dsRunComposite;
    private ExpressionWidget cnExpr;
    private Combo cmb;
    private ExpressionContext expContext;

    public DatasetRunWidget(Composite parent) {
        this.createControl(parent);
    }

    public void setData(JRDesignDatasetRun datasetrun) {
        this.datasetrun = datasetrun;
        if (datasetrun != null) {
            if (datasetrun.getConnectionExpression() == null && datasetrun.getDataSourceExpression() == null) {
                this.cnExpr.setEnabled(false);
                this.cmb.select(0);
            } else if (datasetrun.getConnectionExpression() != null) {
                this.cnExpr.setEnabled(true);
                this.cnExpr.bindObject(datasetrun, "ConnectionExpression");
                if (datasetrun.getConnectionExpression() != null && datasetrun.getConnectionExpression().getText() != null && datasetrun.getConnectionExpression().getText().equals("$P{REPORT_CONNECTION}")) {
                    this.cmb.select(3);
                } else {
                    this.cmb.select(1);
                }
            } else if (datasetrun.getDataSourceExpression() != null) {
                this.cnExpr.setEnabled(true);
                this.cnExpr.bindObject(datasetrun, "DataSourceExpression");
                if (datasetrun.getDataSourceExpression() != null && datasetrun.getDataSourceExpression().getText() != null && datasetrun.getDataSourceExpression().getText().equals("new net.sf.jasperreports.engine.JREmptyDataSource()")) {
                    this.cmb.select(4);
                } else {
                    this.cmb.select(2);
                }
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.layout.topControl = enabled ? this.dsRunComposite : this.emptyComposite;
        this.control.layout();
    }

    public Control getControl() {
        return this.control;
    }

    public void createControl(Composite parent) {
        Composite cmp;
        this.control = cmp = new Composite(parent, 0);
        this.layout = new StackLayout();
        cmp.setLayout((Layout)this.layout);
        this.emptyComposite = new Composite(cmp, 0);
        this.dsRunComposite = new Composite(cmp, 0);
        this.dsRunComposite.setLayout((Layout)new GridLayout(3, false));
        this.cmb = new Combo(this.dsRunComposite, 2060);
        this.cmb.setItems(ITEMS);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.cmb.setLayoutData((Object)gd);
        this.cnExpr = new ExpressionWidget(this.dsRunComposite, "");
        this.layout.topControl = this.dsRunComposite;
        cmp.layout();
        this.cmb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int sel = DatasetRunWidget.this.cmb.getSelectionIndex();
                switch (sel) {
                    case 0: {
                        DatasetRunWidget.this.setNoConnection();
                        break;
                    }
                    case 1: {
                        DatasetRunWidget.this.setConnection("");
                        break;
                    }
                    case 2: {
                        DatasetRunWidget.this.setDatasource("");
                        break;
                    }
                    case 3: {
                        DatasetRunWidget.this.setConnection("$P{REPORT_CONNECTION}");
                        break;
                    }
                    case 4: {
                        DatasetRunWidget.this.setDatasource("new net.sf.jasperreports.engine.JREmptyDataSource()");
                    }
                }
            }
        });
    }

    private void setNoConnection() {
        if (this.datasetrun != null) {
            this.datasetrun.setConnectionExpression(null);
            this.datasetrun.setDataSourceExpression(null);
            this.setData(this.datasetrun);
        }
    }

    private void setDatasource(String exTxt) {
        if (this.datasetrun != null) {
            JRDesignExpression jde = (JRDesignExpression)this.datasetrun.getDataSourceExpression();
            if (jde == null) {
                jde = new JRDesignExpression();
            }
            jde.setValueClass(JRDataSource.class);
            jde.setText(exTxt);
            this.datasetrun.setConnectionExpression(null);
            this.datasetrun.setDataSourceExpression((JRExpression)jde);
            this.setData(this.datasetrun);
        }
    }

    private void setConnection(String exTxt) {
        if (this.datasetrun != null) {
            JRDesignExpression jde = (JRDesignExpression)this.datasetrun.getConnectionExpression();
            if (jde == null) {
                jde = new JRDesignExpression();
            }
            jde.setValueClass(Connection.class);
            jde.setText(exTxt);
            this.datasetrun.setConnectionExpression((JRExpression)jde);
            this.datasetrun.setDataSourceExpression(null);
            this.setData(this.datasetrun);
        }
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
        if (this.cnExpr != null) {
            this.cnExpr.setExpressionContext(this.expContext);
        }
    }
}

