/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.property.descriptor.expression.dialog.JRExpressionEditor;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ExpressionWidget {
    private String label;
    private ExpressionContext exprContext;
    private JRDesignExpression expression;
    private Text expText;
    private Label expLabel;
    private boolean isModMode = false;
    private Object obj;
    private String property;
    private Button expButton;

    public ExpressionWidget(Composite parent, String label) {
        this.label = label;
        this.createControl(parent);
        if (label != null) {
            this.expLabel.setText(label);
        }
    }

    public void setEnabled(boolean enabled) {
        this.expButton.setEnabled(enabled);
        this.expText.setEnabled(enabled);
        if (enabled) {
            this.expLabel.setForeground(ColorConstants.black);
        } else {
            this.expLabel.setForeground(this.expLabel.getDisplay().getSystemColor(33));
        }
    }

    private void createControl(Composite parent) {
        if (this.label != null) {
            this.expLabel = new Label(parent, 0);
        }
        this.expText = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        this.expText.setLayoutData((Object)gd);
        this.expText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExpressionWidget.this.setExpressionText(ExpressionWidget.this.expText.getText(), null);
            }
        });
        this.expButton = new Button(parent, 0x800008);
        this.expButton.setText("...");
        this.expButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
                    JRExpressionEditor wizard = new JRExpressionEditor();
                    wizard.setValue(ExpressionWidget.this.expression);
                    wizard.setExpressionContext(ExpressionWidget.this.exprContext);
                    WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog(Display.getDefault().getActiveShell(), wizard);
                    if (dialog.open() == 0) {
                        JRDesignExpression exprTmp = wizard.getValue();
                        if (exprTmp != null) {
                            ExpressionWidget.this.setExpressionText(exprTmp.getText(), exprTmp.getValueClassName());
                        } else {
                            ExpressionWidget.this.setExpression(exprTmp);
                        }
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void setExpression(JRDesignExpression exp) {
        this.expression = exp;
        this.setOnParent(exp);
        if (exp != null && exp.getText() != null) {
            if (!exp.getText().equals(this.expText.getText())) {
                this.expText.setText(exp.getText());
                this.expText.setToolTipText(this.expText.getText());
            }
        } else {
            this.expText.setText("");
            this.expText.setToolTipText("");
        }
    }

    protected void setOnParent(JRDesignExpression exp) {
        try {
            if (this.obj != null) {
                this.obj.getClass().getMethod("set" + this.property, JRExpression.class).invoke(this.obj, exp);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private void setExpressionText(String exptxt, String valueClass) {
        if (!this.isModMode) {
            this.isModMode = true;
            try {
                if (exptxt != null && !exptxt.isEmpty()) {
                    if (this.expression == null) {
                        this.expression = new JRDesignExpression();
                    }
                    this.expression.setText(exptxt);
                } else {
                    this.expression = null;
                }
                if (valueClass != null && this.expression != null) {
                    this.expression.setValueClassName(valueClass);
                }
                this.setExpression(this.expression);
            }
            finally {
                this.isModMode = false;
            }
        }
    }

    public void bindObject(Object obj, String property) {
        this.obj = obj;
        this.property = property;
        try {
            JRDesignExpression expr = null;
            if (obj != null) {
                expr = (JRDesignExpression)obj.getClass().getMethod("get" + property, new Class[0]).invoke(obj, new Object[0]);
            }
            this.setExpression(expr);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public void setExpressionContext(ExpressionContext exprContext) {
        this.exprContext = exprContext;
    }

    public boolean isEnabled() {
        return this.expButton.isEnabled() && this.expText.isEnabled();
    }

    public void setToolTipText(String text) {
        this.expText.setToolTipText(text);
        this.expLabel.setToolTipText(text);
    }
}

