/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.dialog;

import com.jaspersoft.studio.property.dataset.preview.DataPreviewTable;
import java.math.BigDecimal;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CopyDataDialog
extends ATitledDialog {
    private DataPreviewTable dpt;

    public CopyDataDialog(Shell parentShell, DataPreviewTable dpt) {
        super(parentShell);
        this.setTitle("Data");
        this.setDefaultSize(500, 400);
        this.dpt = dpt;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        Text txt = new Text(cmp, 2818);
        txt.setLayoutData((Object)new GridData(1808));
        txt.setText(this.getSQL());
        return cmp;
    }

    private String getSQL() {
        List<JRDesignField> fields = this.dpt.getFields();
        if (fields.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        StringBuffer tcol = new StringBuffer();
        String del = "";
        for (JRDesignField f : fields) {
            tcol.append(del).append("\"" + f.getName().replaceAll("\"", "\"\"") + "\"");
            del = " , ";
        }
        sb.append(tcol).append("\nFROM \n(VALUES \n");
        del = "";
        for (DataPreviewTable.DataPreviewBean it : this.dpt.getPreviewItems()) {
            sb.append(del).append("(");
            String rdel = "";
            int i = 0;
            while (i < fields.size()) {
                sb.append(rdel);
                Class vc = fields.get(i).getValueClass();
                String q = vc.isAssignableFrom(Integer.class) || vc.isAssignableFrom(Byte.class) || vc.isAssignableFrom(Short.class) || vc.isAssignableFrom(Long.class) || vc.isAssignableFrom(Boolean.class) ? "" : "'";
                Object v = it.getValue(i);
                if (v == null) {
                    sb.append("NULL");
                } else if (v instanceof Number && q.equals("'")) {
                    sb.append(q).append(new BigDecimal(v.toString()).stripTrailingZeros().toPlainString()).append(q);
                } else {
                    sb.append(q).append(v.toString().replaceAll("'", "''")).append(q);
                }
                rdel = ", ";
                ++i;
            }
            sb.append(")");
            del = ",\n";
        }
        sb.append("\n) s(");
        sb.append(tcol).append(")");
        return sb.toString();
    }
}

