/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.prm;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.dnd.NodeDragListener;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.model.parameter.MParameterSystem;
import com.jaspersoft.studio.property.dataset.DatasetUtil;
import com.jaspersoft.studio.property.dataset.dialog.AbstractModifyTable;
import com.jaspersoft.studio.property.dataset.fields.PropertiesDialog;
import com.jaspersoft.studio.property.dataset.fields.table.TColumn;
import com.jaspersoft.studio.property.dataset.fields.table.TColumnFactory;
import com.jaspersoft.studio.property.dataset.fields.table.column.CheckboxColumnSupport;
import com.jaspersoft.studio.property.dataset.fields.table.column.ExpressionColumnSupport;
import com.jaspersoft.studio.property.dataset.fields.table.column.JRPropertiesColumnSupport;
import com.jaspersoft.studio.property.dataset.fields.table.column.JRPropertyColumnSupport;
import com.jaspersoft.studio.property.dataset.fields.table.column.PropertyColumnSupport;
import com.jaspersoft.studio.property.descriptor.propexpr.JPropertyExpressionsCellEditor;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.cell.JRPropertyExpressionCellEditor;
import com.jaspersoft.studio.property.descriptor.propexpr.dialog.PropertyDialogHelper;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.IEditElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.utils.UIUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.annotations.properties.PropertyScope;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.type.ParameterEvaluationTimeEnum;
import net.sf.jasperreports.properties.PropertyMetadata;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.part.PluginTransfer;

public class ParametersTable
extends AbstractModifyTable {
    private TableViewer tviewer;
    private Composite composite;
    private JRDesignDataset dataset;
    private Color background;
    private boolean isMainDataset;
    private MDataset mdataset;
    private ToolItem bDA;
    private ToolItem bSystem;
    private DataAdapter da;
    private Map<JRParameter, PropertyChangeListener> map = new HashMap<JRParameter, PropertyChangeListener>();
    private Filter filter = new Filter();
    private List<TableViewerColumn> columns = new ArrayList<TableViewerColumn>();
    private PropertyChangeSupport propertyChangeSupport;
    private StackLayout layout;
    private Composite tblCmp;
    private Composite treeCmp;
    private Composite pcmp;
    private TreeViewer treeviewer;
    private List<TColumn> tcolumns = new ArrayList<TColumn>();
    private List<JRDesignParameter> params;

    public ParametersTable(Composite parent, JRDesignDataset dataset, Color background, boolean isMainDataset, MDataset mdataset) {
        this.mdataset = mdataset;
        this.background = background;
        this.isMainDataset = isMainDataset;
        this.dataset = dataset;
        this.createControl(parent);
        dataset.getPropertiesMap().getEventSupport().addPropertyChangeListener(evt -> {
            String pname = evt.getPropertyName();
            if (pname.equals("com.jaspersoft.studio.data.defaultdataadapter") || pname.equals("net.sf.jasperreports.data.adapter")) {
                this.refreshDataAdapter();
                this.refreshProperties(this.da);
                this.tviewer.refresh(true);
                this.treeviewer.refresh(true);
            }
        });
        if (dataset.getQuery() != null) {
            ((JRDesignQuery)dataset.getQuery()).getEventSupport().addPropertyChangeListener("language", evt -> UIUtils.getDisplay().asyncExec(() -> {
                ArrayList fields = dataset.getParametersList();
                if (fields == null) {
                    fields = new ArrayList();
                }
                this.setFields(fields);
            }));
        }
    }

    public Composite getControl() {
        return this.composite;
    }

    private void refreshDataAdapter() {
        this.da = DatasetUtil.refreshDataAdapter(this.mdataset.getJasperDesign(), this.dataset, this.mdataset.getJasperConfiguration());
    }

    private void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.composite.setBackground(this.background);
        this.composite.setBackgroundMode(2);
        this.createButtons();
        this.pcmp = new Composite(this.composite, 0);
        this.layout = new StackLayout();
        this.pcmp.setLayout((Layout)this.layout);
        this.pcmp.setLayoutData((Object)new GridData(1808));
        this.tblCmp = new Composite(this.pcmp, 0);
        this.tblCmp.setLayout((Layout)new GridLayout(2, false));
        this.createParametersTable(this.tblCmp);
        this.treeCmp = new Composite(this.pcmp, 0);
        this.treeCmp.setLayout((Layout)new GridLayout(2, false));
        this.createParametersTree(this.treeCmp);
        this.layout.topControl = this.tblCmp;
    }

    private void createButtons() {
        ToolBar buttons = new ToolBar(this.composite, 0x800000);
        buttons.setLayoutData((Object)new GridData(768));
        this.bSystem = new ToolItem(buttons, 32);
        this.bSystem.setImage(JaspersoftStudioPlugin.getInstance().getImage(MParameterSystem.getIconDescriptor().getIcon16()));
        this.bSystem.addListener(13, event -> {
            this.filter.setShowSystem(!this.bSystem.getSelection());
            this.tviewer.refresh();
            this.treeviewer.refresh();
        });
        this.bSystem.setToolTipText("Hide Built-In parameters");
        this.bSystem.setSelection(false);
        this.bDA = new ToolItem(buttons, 32);
        this.bDA.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/parameter-da-16.png"));
        this.bDA.addListener(13, event -> {
            if (this.bDA.getSelection()) {
                this.layout.topControl = this.treeCmp;
                this.refreshTree();
            } else {
                this.layout.topControl = this.tblCmp;
                this.refreshTable(this.dataset.getParametersList());
            }
            this.pcmp.layout();
        });
        this.bDA.setToolTipText("Show parameter properties");
    }

    private void createParametersTree(Composite parent) {
        Tree wtree = new Tree(parent, 68098);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        wtree.setLayoutData((Object)gd);
        wtree.setHeaderVisible(true);
        wtree.setLinesVisible(true);
        this.treeviewer = new TreeViewer(wtree);
        this.treeviewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                if (element instanceof JRDesignParameter) {
                    return !((JRDesignParameter)element).getPropertiesMap().isEmpty();
                }
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object element) {
                return this.getChildren(element);
            }

            public Object[] getChildren(Object element) {
                JRPropertiesMap pm;
                if (element instanceof Collection) {
                    ArrayList res = new ArrayList();
                    for (Object el : (Collection)element) {
                        if (el instanceof JRDesignParameter && !ParametersTable.this.filter.showSystem && ((JRDesignParameter)el).isSystemDefined()) continue;
                        res.add(el);
                    }
                    return res.toArray();
                }
                if (element instanceof JRDesignParameter && !(pm = ((JRDesignParameter)element).getPropertiesMap()).isEmpty()) {
                    Object[][] props = new Object[pm.getPropertyNames().length][3];
                    int i = 0;
                    String[] stringArray = pm.getPropertyNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        props[i] = new Object[]{key, pm.getProperty(key), element};
                        ++i;
                        ++n2;
                    }
                    return props;
                }
                return null;
            }
        });
        UIUtil.setViewerCellEditingOnDblClick(this.treeviewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeviewer, (int)2);
        TColumn c = new TColumn();
        c.setPropertyName("name");
        c.setLabel(Messages.ParametersTable_name);
        c.setValue(this.mdataset);
        TColumnFactory.addColumn(c, this.treeviewer);
        TColumn cde = new TColumn();
        cde.setPropertyName("defaultValueExpression");
        cde.setLabel(Messages.MParameter_default_value_expression);
        cde.setType("expression");
        cde.setValue(this.mdataset);
        TColumnFactory.addColumn(cde, this.treeviewer);
        c = new TColumn();
        c.setPropertyName("key");
        c.setLabel("Property");
        c.setType("text");
        c.setValue(this.mdataset);
        TColumnFactory.addColumn(c, this.treeviewer, (PropertyColumnSupport)new JRPropertyColumnSupport((ColumnViewer)this.treeviewer, c){

            @Override
            protected boolean canEdit(Object element) {
                return false;
            }

            @Override
            public String getText(Object element) {
                PropertyMetadata pm = DatasetUtil.getPmap(ParametersTable.this.mdataset.getJasperConfiguration()).get(super.getText(element));
                if (pm != null) {
                    return pm.getLabel();
                }
                return super.getText(element);
            }

            @Override
            public String getToolTipText(Object element) {
                PropertyMetadata pm;
                String tt = super.getToolTipText(element);
                String txt = super.getText(element);
                if (!txt.equals(tt.trim())) {
                    tt = String.valueOf(tt) + "\n" + super.getText(element);
                }
                if ((pm = DatasetUtil.getPmap(ParametersTable.this.mdataset.getJasperConfiguration()).get(super.getText(element))) != null && !Misc.isNullOrEmpty((String)pm.getDescription())) {
                    tt = String.valueOf(tt) + "\n\n" + pm.getDescription();
                }
                return tt;
            }

            @Override
            protected Object getValue(Object element) {
                if (element instanceof Object[]) {
                    return ((Object[])element)[0];
                }
                return "";
            }
        });
        c = new TColumn();
        c.setPropertyName("value");
        c.setLabel("Value");
        c.setType("text");
        c.setValue(this.mdataset);
        TColumnFactory.addColumn(c, this.treeviewer, (PropertyColumnSupport)new JRPropertyColumnSupport((ColumnViewer)this.treeviewer, c){
            private JRPropertyExpressionCellEditor ce;

            @Override
            protected CellEditor createCellEditor() {
                if (this.ce == null) {
                    this.ce = new JRPropertyExpressionCellEditor((Composite)this.viewer.getControl(), false, false, ParametersTable.this.mdataset.getJasperConfiguration()){

                        @Override
                        protected String getDialogTitle() {
                            PropertyExpressionDTO v = (PropertyExpressionDTO)this.getValue();
                            PropertyMetadata pm = DatasetUtil.getPmap((this).ParametersTable.this.mdataset.getJasperConfiguration()).get(v.getName());
                            if (pm != null) {
                                return pm.getLabel();
                            }
                            return super.getDialogTitle();
                        }
                    };
                }
                return this.ce;
            }

            @Override
            protected boolean canEdit(Object element) {
                return element instanceof Object[];
            }

            @Override
            protected Object getValue(Object element) {
                if (element instanceof Object[]) {
                    Object[] row = (Object[])element;
                    return new PropertyExpressionDTO(false, (String)row[0], (String)row[1], false);
                }
                return null;
            }

            @Override
            protected void setValue(Object element, Object value) {
                if (element instanceof Object[]) {
                    Object[] row = (Object[])element;
                    JRPropertiesMap pm = ((JRDesignParameter)row[2]).getPropertiesMap();
                    if (value instanceof PropertyExpressionDTO) {
                        value = ((PropertyExpressionDTO)value).getValue();
                    }
                    if (value == null || value.toString().isEmpty()) {
                        pm.removeProperty((String)row[0]);
                    } else {
                        pm.setProperty((String)row[0], (String)value);
                        row[1] = value;
                    }
                } else {
                    super.setValue(element, value);
                }
            }
        });
        Composite bGroup = new Composite(parent, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        bGroup.setBackground(this.background);
        Button baddprm = new Button(bGroup, 8);
        baddprm.setText("Add Parameter");
        baddprm.setLayoutData((Object)new GridData(770));
        baddprm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection sel = (StructuredSelection)ParametersTable.this.treeviewer.getSelection();
                JRDesignParameter p = new JRDesignParameter();
                p.setName(ParametersTable.this.getName());
                List prms = (List)ParametersTable.this.treeviewer.getInput();
                int indx = -1;
                Object obj = sel.getFirstElement();
                if (obj != null) {
                    indx = prms.indexOf(obj);
                }
                if (indx >= 0) {
                    prms.add(indx, p);
                    try {
                        ParametersTable.this.dataset.addParameter(indx, (JRParameter)p);
                    }
                    catch (JRException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    prms.add(p);
                    try {
                        ParametersTable.this.dataset.addParameter((JRParameter)p);
                    }
                    catch (JRException e1) {
                        e1.printStackTrace();
                    }
                }
                p.getPropertiesMap().getEventSupport().addPropertyChangeListener(evt -> {
                    ParametersTable.this.treeviewer.refresh(true);
                    ParametersTable.this.treeviewer.expandToLevel((Object)p, 1);
                });
                ParametersTable.this.fireModifyListeners();
                ParametersTable.this.treeviewer.refresh();
                ParametersTable.this.treeviewer.expandToLevel((Object)p, 2);
                ParametersTable.this.treeviewer.setSelection((ISelection)new StructuredSelection((Object)p));
                ParametersTable.this.treeviewer.reveal((Object)p);
            }
        });
        final Button badd = new Button(bGroup, 8);
        badd.setText("Add Property");
        badd.setEnabled(false);
        badd.setLayoutData((Object)new GridData(770));
        badd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPropertyDialog d;
                StructuredSelection sel = (StructuredSelection)ParametersTable.this.treeviewer.getSelection();
                Object obj = sel.getFirstElement();
                JRDesignParameter p = null;
                if (obj instanceof JRDesignParameter) {
                    p = (JRDesignParameter)obj;
                }
                if (obj instanceof Object[]) {
                    p = (JRDesignParameter)((Object[])obj)[2];
                }
                if ((d = new NewPropertyDialog(badd.getShell(), p)).open() == 0) {
                    String key = d.getKey();
                    String value = "";
                    PropertyMetadata pm = DatasetUtil.getPmap(ParametersTable.this.mdataset.getJasperConfiguration()).get(key);
                    if (pm != null) {
                        value = pm.getDefaultValue();
                    }
                    if (p != null) {
                        p.getPropertiesMap().setProperty(key, value);
                    }
                    ParametersTable.this.treeviewer.refresh();
                    ParametersTable.this.treeviewer.expandToLevel((Object)p, 2);
                    ParametersTable.this.treeviewer.setSelection((ISelection)new StructuredSelection((Object)p));
                    ParametersTable.this.treeviewer.reveal((Object)p);
                }
            }
        });
        Button bedit = new Button(bGroup, 8);
        bedit.setText("Edit");
        bedit.setEnabled(false);
        bedit.setLayoutData((Object)new GridData(770));
        SelectionAdapter editListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRDesignParameter pold;
                JRDesignParameter pclone;
                Object[] row;
                PropertyExpressionDTO v;
                StructuredSelection sel = (StructuredSelection)ParametersTable.this.treeviewer.getSelection();
                Object obj = sel.getFirstElement();
                if (obj instanceof JRDesignParameter) {
                    JRDesignParameter oldF = (JRDesignParameter)obj;
                    PropertiesDialog<JRDesignParameter> d = new PropertiesDialog<JRDesignParameter>(ParametersTable.this.tviewer.getTable().getShell(), (JRDesignParameter)oldF.clone(), ParametersTable.this.tcolumns, MParameter.getIconDescriptor().getDescription(), ParametersTable.this.mdataset.getJasperConfiguration());
                    if (d.open() == 0) {
                        int pos = ParametersTable.this.dataset.getParametersList().indexOf(oldF);
                        ParametersTable.this.dataset.removeParameter(oldF.getName());
                        try {
                            obj = d.getElement();
                            JRDesignParameter newP = (JRDesignParameter)obj;
                            if (pos >= 0 && pos < ParametersTable.this.dataset.getParametersList().size()) {
                                ParametersTable.this.dataset.addParameter(pos, (JRParameter)newP);
                            } else {
                                ParametersTable.this.dataset.addParameter((JRParameter)newP);
                            }
                            if (!oldF.getName().equals(newP.getName())) {
                                newP.getEventSupport().firePropertyChange("name", (Object)oldF.getName(), (Object)newP.getName());
                            }
                        }
                        catch (JRException ex) {
                            UIUtils.showError((Throwable)ex);
                        }
                        ParametersTable.this.params.clear();
                        ParametersTable.this.fillTree();
                    }
                } else if (obj instanceof Object[] && PropertyDialogHelper.showPropertyDialog(v = new PropertyExpressionDTO(false, (String)(row = (Object[])obj)[0], (String)row[1], false), (JRParameter)(pclone = (JRDesignParameter)(pold = (JRDesignParameter)row[2]).clone()), ParametersTable.this.mdataset.getJasperConfiguration())) {
                    String key;
                    String[] stringArray = pold.getPropertiesMap().getPropertyNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        key = stringArray[n2];
                        pold.getPropertiesMap().removeProperty(key);
                        ++n2;
                    }
                    stringArray = pclone.getPropertiesMap().getPropertyNames();
                    n = stringArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        key = stringArray[n2];
                        pold.getPropertiesMap().setProperty(key, pclone.getPropertiesMap().getProperty(key));
                        ++n2;
                    }
                    row[0] = v.getName();
                    row[1] = v.getValue();
                }
                ParametersTable.this.treeviewer.refresh();
                ParametersTable.this.treeviewer.expandToLevel(obj, 2);
                ParametersTable.this.treeviewer.setSelection((ISelection)new StructuredSelection(obj));
                ParametersTable.this.treeviewer.reveal(obj);
            }
        };
        bedit.addSelectionListener((SelectionListener)editListener);
        this.treeviewer.addDoubleClickListener(event -> {
            if (bedit.isEnabled()) {
                editListener.widgetSelected(null);
            }
        });
        Button bdel = new Button(bGroup, 8);
        bdel.setText(Messages.common_delete);
        bdel.setEnabled(false);
        bdel.setLayoutData((Object)new GridData(770));
        bdel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection sel = (StructuredSelection)ParametersTable.this.treeviewer.getSelection();
                List prms = (List)ParametersTable.this.treeviewer.getInput();
                for (Object obj : sel.toList()) {
                    if (obj instanceof JRDesignParameter) {
                        prms.remove(obj);
                        JRDesignParameter p = (JRDesignParameter)obj;
                        String[] stringArray = p.getPropertiesMap().getPropertyNames();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String key = stringArray[n2];
                            p.getPropertiesMap().removeProperty(key);
                            ++n2;
                        }
                        ParametersTable.this.dataset.removeParameter((JRParameter)((JRDesignParameter)obj));
                        continue;
                    }
                    if (!(obj instanceof Object[])) continue;
                    Object[] row = (Object[])obj;
                    ((JRDesignParameter)row[2]).getPropertiesMap().removeProperty((String)row[0]);
                }
                ParametersTable.this.treeviewer.refresh();
            }
        });
        this.treeviewer.addSelectionChangedListener(event -> {
            StructuredSelection sel = (StructuredSelection)this.treeviewer.getSelection();
            Object obj = sel.getFirstElement();
            badd.setEnabled(!sel.isEmpty() && (obj instanceof JRDesignParameter || obj instanceof Object[]));
            bedit.setEnabled(!sel.isEmpty());
            bdel.setEnabled(!sel.isEmpty());
        });
        this.treeviewer.addDragSupport(3, new Transfer[]{TemplateTransfer.getInstance(), PluginTransfer.getInstance()}, (DragSourceListener)new NodeDragListener((StructuredViewer)this.treeviewer));
        this.treeviewer.expandAll();
        this.params = new ArrayList<JRDesignParameter>();
        if (this.dataset.getParametersList() != null) {
            this.fillTree();
        }
        this.treeviewer.setInput(this.params);
    }

    private void fillTree() {
        for (JRParameter p : this.map.keySet()) {
            p.getPropertiesMap().getEventSupport().removePropertyChangeListener(this.map.get(p));
        }
        this.map.clear();
        for (JRParameter p : this.dataset.getParametersList()) {
            this.params.add((JRDesignParameter)p);
            JRParameter prm = p;
            PropertyChangeListener pcl = evt -> {
                if (this.treeviewer.getTree().isDisposed()) {
                    return;
                }
                this.treeviewer.refresh(true);
                this.treeviewer.expandToLevel((Object)prm, 1);
            };
            this.map.put(p, pcl);
            p.getPropertiesMap().getEventSupport().addPropertyChangeListener(pcl);
        }
    }

    private void createParametersTable(Composite parent) {
        this.wtable = new Table(parent, 68098);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        this.wtable.setLayoutData((Object)gd);
        this.wtable.setHeaderVisible(true);
        this.wtable.setLinesVisible(true);
        this.tviewer = new TableViewer(this.wtable);
        this.tviewer.setContentProvider((IContentProvider)new ListContentProvider());
        UIUtil.setViewerCellEditingOnDblClick(this.tviewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tviewer, (int)2);
        this.tviewer.setFilters(new ViewerFilter[]{this.filter});
        this.refreshDataAdapter();
        this.refreshProperties(this.da);
        Composite bGroup = new Composite(parent, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        bGroup.setBackground(this.background);
        new NewButton(){

            @Override
            protected void afterElementAdded(Object selement) {
                try {
                    ParametersTable.this.dataset.removeParameter((JRParameter)selement);
                    ParametersTable.this.dataset.addParameter((JRParameter)((JRDesignParameter)selement));
                    ParametersTable.this.fireModifyListeners();
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
        }.createNewButtons(bGroup, this.tviewer, (input, pos) -> {
            JRDesignParameter f = new JRDesignParameter();
            f.setName(this.getName());
            f.setValueClass(String.class);
            return f;
        });
        EditButton<JRDesignParameter> eb = new EditButton<JRDesignParameter>(){

            @Override
            public void setEnabled(boolean enable) {
                StructuredSelection s = (StructuredSelection)ParametersTable.this.tviewer.getSelection();
                super.setEnabled(enable && !s.isEmpty() && !((JRDesignParameter)s.getFirstElement()).isSystemDefined());
            }
        };
        eb.createEditButtons(bGroup, this.tviewer, new IEditElement<JRDesignParameter>(){

            @Override
            public void editElement(List<JRDesignParameter> input, int pos) {
                JRDesignParameter oldF = input.get(pos);
                PropertiesDialog<JRDesignParameter> d = new PropertiesDialog<JRDesignParameter>(ParametersTable.this.tviewer.getTable().getShell(), (JRDesignParameter)oldF.clone(), ParametersTable.this.tcolumns, MParameter.getIconDescriptor().getDescription(), ParametersTable.this.mdataset.getJasperConfiguration());
                if (d.open() == 0) {
                    ParametersTable.this.dataset.removeParameter((JRParameter)oldF);
                    try {
                        JRDesignParameter newP = d.getElement();
                        if (pos >= 0 && pos < ParametersTable.this.dataset.getParametersList().size()) {
                            ParametersTable.this.dataset.addParameter(pos, (JRParameter)newP);
                        } else {
                            ParametersTable.this.dataset.addParameter((JRParameter)newP);
                        }
                        if (!oldF.getName().equals(newP.getName())) {
                            newP.getEventSupport().firePropertyChange("name", (Object)oldF.getName(), (Object)newP.getName());
                        }
                        input.set(pos, d.getElement());
                    }
                    catch (JRException e) {
                        UIUtils.showError((Throwable)e);
                    }
                }
            }
        });
        eb.editOnDoubleClick();
        DeleteButton delb = new DeleteButton(){

            @Override
            protected void afterElementDeleted(Object element) {
                JRParameter todel = null;
                for (JRParameter p : ParametersTable.this.dataset.getParametersList()) {
                    if (!p.getName().equals(((JRDesignParameter)element).getName())) continue;
                    todel = p;
                    break;
                }
                if (todel != null) {
                    ParametersTable.this.dataset.removeParameter(todel);
                    ParametersTable.this.fireModifyListeners();
                }
            }
        };
        delb.createDeleteButton(bGroup, this.tviewer);
        ArrayList fields = this.dataset.getParametersList();
        if (fields == null) {
            fields = new ArrayList();
        }
        this.setFields(fields);
        this.tviewer.addSelectionChangedListener(event -> {
            StructuredSelection sel = (StructuredSelection)event.getSelection();
            if (!sel.isEmpty()) {
                JRDesignParameter prm = (JRDesignParameter)sel.getFirstElement();
                delb.setEnabled(!prm.isSystemDefined());
            }
        });
        this.tviewer.addDragSupport(3, new Transfer[]{TemplateTransfer.getInstance(), PluginTransfer.getInstance()}, (DragSourceListener)new NodeDragListener((StructuredViewer)this.tviewer));
    }

    public String getName() {
        List<JRDesignParameter> list = this.getParameters();
        String name = "Parameter";
        boolean match = false;
        String tmp = name;
        int i = 1;
        while (i < 100000) {
            tmp = String.valueOf(name) + i;
            for (JRDesignParameter f : list) {
                match = f.getName().equals(tmp);
                if (match) break;
            }
            if (!match) break;
            ++i;
        }
        return tmp;
    }

    private void createNameColumn() {
        TColumn c = new TColumn();
        c.setPropertyName("name");
        c.setLabel(Messages.ParametersTable_name);
        c.setDescription(Messages.MParameterSystem_name_description);
        c.setValue(this.mdataset);
        this.columns.add(TColumnFactory.addColumn(c, this.tviewer));
        this.tcolumns.add(c);
    }

    private void createIsForPrompt() {
        TColumn c = new TColumn();
        c.setPropertyName("forPrompting");
        c.setLabel(Messages.ParametersTable_isForPrompt);
        c.setDescription(Messages.MParameter_is_for_prompting_description);
        c.setPropertyType(Boolean.TYPE.getName());
        this.columns.add(TColumnFactory.addColumn(c, this.tviewer, (PropertyColumnSupport)new CheckboxColumnSupport((ColumnViewer)this.tviewer, c){

            @Override
            protected Object getValue(Object element) {
                JRDesignParameter p = (JRDesignParameter)element;
                if (p.isSystemDefined()) {
                    return null;
                }
                return super.getValue(element);
            }

            @Override
            public String getText(Object element) {
                return "";
            }

            @Override
            public Image getImage(Object element) {
                if (element instanceof JRDesignParameter) {
                    JRDesignParameter p = (JRDesignParameter)element;
                    if (!p.isSystemDefined() && p.isForPrompting()) {
                        return super.getImage(true);
                    }
                } else if (element instanceof Boolean) {
                    return super.getImage(element);
                }
                return null;
            }

            @Override
            protected boolean canEdit(Object element) {
                JRDesignParameter p = (JRDesignParameter)element;
                return !p.isSystemDefined() && super.canEdit(element);
            }
        }));
        this.tcolumns.add(c);
    }

    private void createTypeColumn() {
        TColumn c = new TColumn();
        c.setPropertyName("valueClassName");
        c.setLabel(Messages.ParametersTable_class);
        c.setDescription(Messages.MParameterSystem_class_description);
        c.setPropertyType(Class.class.getName());
        this.columns.add(TColumnFactory.addColumn(c, this.tviewer));
        this.tcolumns.add(c);
    }

    private void createNestedTypeColumn() {
        TColumn c = new TColumn();
        c.setPropertyName("nestedTypeName");
        c.setLabel(Messages.MParameter_nested_type_name);
        c.setDescription(Messages.MParameter_nested_type_name_description);
        c.setPropertyType(Class.class.getName());
        this.tcolumns.add(c);
    }

    private void createDefaultExpression() {
        TColumn c = new TColumn();
        c.setPropertyName("defaultValueExpression");
        c.setLabel(Messages.MParameter_default_value_expression);
        c.setDescription(Messages.MParameter_default_value_expression_description);
        c.setPropertyType(JRDesignExpression.class.getName());
        c.setValue(this.mdataset);
        this.columns.add(TColumnFactory.addColumn(c, this.tviewer, (PropertyColumnSupport)new ExpressionColumnSupport((ColumnViewer)this.tviewer, c){

            @Override
            protected boolean canEdit(Object element) {
                if (((JRDesignParameter)element).isSystemDefined()) {
                    return false;
                }
                return super.canEdit(element);
            }
        }));
        this.tcolumns.add(c);
    }

    private void createDescriptionColumn() {
        TColumn c = new TColumn();
        c.setPropertyName("description");
        c.setLabel(Messages.ParametersTable_description);
        c.setDescription(Messages.MParameter_description_description);
        c.setValue(this.dataset);
        this.columns.add(TColumnFactory.addColumn(c, this.tviewer));
        this.tcolumns.add(c);
    }

    private void createEvaluationTime() {
        TColumn c = new TColumn();
        c.setPropertyName("evaluationTime");
        c.setLabel(Messages.common_evaluation_time);
        c.setDescription(Messages.MParameter_3);
        c.setValue(this.dataset);
        c.setPropertyType(ParameterEvaluationTimeEnum.class.getName());
        c.setLabelEditable(false);
        this.columns.add(TColumnFactory.addColumn(c, this.tviewer, null));
        this.tcolumns.add(c);
    }

    private void createPropertiesColumn() {
        TColumn c = new TColumn();
        c.setPropertyName("properties");
        c.setLabel(Messages.common_properties);
        c.setDescription(Messages.MParameter_properties_description);
        c.setPropertyType(JRPropertiesMap.class.getName());
        c.setType("properties");
        c.setValue(this.mdataset);
        this.columns.add(TColumnFactory.addColumn(c, this.tviewer, (PropertyColumnSupport)new JRPropertiesColumnSupport((ColumnViewer)this.tviewer, c){

            @Override
            protected CellEditor getCellEditor(Object element) {
                return new JPropertyExpressionsCellEditor((Composite)this.viewer.getControl(), false);
            }

            @Override
            protected boolean canEdit(Object element) {
                return !((JRDesignParameter)element).isSystemDefined() && super.canEdit(element);
            }
        }));
        this.tcolumns.add(c);
    }

    public <T extends JRParameter> void setFields(List<T> fields) {
        this.refreshTable(new ArrayList<T>(fields));
        this.refreshTree();
    }

    protected <T extends JRParameter> void refreshTable(List<T> fields) {
        this.tviewer.setInput(fields);
        this.tviewer.refresh();
    }

    protected void refreshTree() {
        if (this.treeviewer != null) {
            this.params = new ArrayList<JRDesignParameter>();
            if (this.dataset.getParametersList() != null) {
                this.fillTree();
            }
            this.treeviewer.setInput(this.params);
            this.treeviewer.refresh();
            this.treeviewer.expandAll();
        }
    }

    public List<JRDesignParameter> getParameters() {
        ArrayList<JRDesignParameter> t = new ArrayList<JRDesignParameter>();
        for (JRParameter p : this.dataset.getParametersList()) {
            t.add((JRDesignParameter)p);
        }
        return t;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    private void refreshProperties(DataAdapter da) {
        for (TableViewerColumn tvc : this.columns) {
            tvc.getColumn().dispose();
        }
        this.columns.clear();
        this.tviewer.setColumnProperties(new String[0]);
        this.tviewer.setCellEditors(new CellEditor[0]);
        this.tviewer.getTable().setLayout((Layout)new TableLayout());
        this.tcolumns.clear();
        this.createNameColumn();
        if (this.isMainDataset) {
            this.createIsForPrompt();
        }
        this.createTypeColumn();
        this.createNestedTypeColumn();
        this.createDescriptionColumn();
        this.createDefaultExpression();
        this.createEvaluationTime();
        this.createPropertiesColumn();
        this.tviewer.getTable().layout(true);
    }

    public class Filter
    extends ViewerFilter {
        private boolean showSystem = true;

        public void setShowSystem(boolean showSystem) {
            this.showSystem = showSystem;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            JRDesignParameter p = (JRDesignParameter)element;
            return this.showSystem || !p.isSystemDefined();
        }
    }

    class NewPropertyDialog
    extends ATitledDialog {
        private JRDesignParameter p;
        private String key;

        public NewPropertyDialog(Shell shell, JRDesignParameter p) {
            super(shell);
            this.p = p;
            this.setTitle("New Property");
            this.setDescription("Add a property or select one provided by Data Adapter.");
        }

        public String getKey() {
            return this.key;
        }

        protected Control createDialogArea(Composite parent) {
            Composite cmp = (Composite)super.createDialogArea(parent);
            cmp.setLayout((Layout)new GridLayout());
            Label lbl = new Label(cmp, 0);
            lbl.setText("Property");
            final Text lprop = new Text(cmp, 2048);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            lprop.setLayoutData((Object)gd);
            lprop.addModifyListener(e -> {
                String string = this.key = lprop.getText();
            });
            final org.eclipse.swt.widgets.List cmb = new org.eclipse.swt.widgets.List(cmp, 2052);
            gd = new GridData(1808);
            gd.widthHint = 400;
            gd.heightHint = 300;
            cmb.setLayoutData((Object)gd);
            final ArrayList<String> items = new ArrayList<String>();
            Map<String, PropertyMetadata> pmap = DatasetUtil.getPmap(ParametersTable.this.mdataset.getJasperConfiguration());
            for (Map.Entry<String, PropertyMetadata> entry : pmap.entrySet()) {
                List scopes = entry.getValue().getScopes();
                if (scopes == null || !scopes.contains(PropertyScope.PARAMETER) || this.p.getPropertiesMap().containsProperty(entry.getKey())) continue;
                items.add(entry.getKey());
            }
            Collections.sort(items);
            for (String it : items) {
                cmb.add(pmap.get(it).getLabel());
            }
            cmb.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    lprop.setText((String)items.get(cmb.getSelectionIndex()));
                    NewPropertyDialog.this.key = lprop.getText();
                    NewPropertyDialog.this.close();
                }
            });
            cmb.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    lprop.setText((String)items.get(cmb.getSelectionIndex()));
                }
            });
            cmb.addListener(5, event -> {
                int itemTop = 0;
                int i = 0;
                while (i < cmb.getItemCount()) {
                    if (event.y >= itemTop && event.y <= itemTop + cmb.getItemHeight()) {
                        PropertyMetadata pm = DatasetUtil.getPmap(ParametersTable.this.mdataset.getJasperConfiguration()).get(items.get(cmb.getTopIndex() + i));
                        if (pm != null) {
                            cmb.setToolTipText(String.valueOf(pm.getName()) + "\n\n" + Misc.nvl((String)pm.getDescription()));
                        } else {
                            cmb.setToolTipText("");
                        }
                    }
                    itemTop += cmb.getItemHeight();
                    ++i;
                }
            });
            if (items.size() > 0) {
                cmb.select(0);
                lprop.setText((String)items.get(cmb.getSelectionIndex()));
            }
            return cmp;
        }
    }
}

