/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.sort;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.sortfield.MSortField;
import com.jaspersoft.studio.model.sortfield.command.wizard.SortFieldWizard;
import com.jaspersoft.studio.model.variable.MVariable;
import com.jaspersoft.studio.property.dataset.dialog.AbstractModifyTable;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.utils.UIUtil;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SortFieldsTable
extends AbstractModifyTable {
    private static final String[] orderEnumNames = EnumHelper.getEnumNames((NamedEnum[])SortOrderEnum.values(), NullEnum.NOTNULL);
    private TableViewer tviewer;
    private Composite composite;
    private JRDesignDataset dataset;
    private Color background;
    NamedEnumPropertyDescriptor<SortFieldTypeEnum> sfdesc = new NamedEnumPropertyDescriptor<SortFieldTypeEnum>(null, null, SortFieldTypeEnum.FIELD, NullEnum.NOTNULL);

    public SortFieldsTable(Composite parent, JRDesignDataset dataset, Color background) {
        this.background = background;
        this.dataset = dataset;
        this.createControl(parent);
    }

    public Composite getControl() {
        return this.composite;
    }

    private void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.composite.setBackground(this.background);
        this.composite.setBackgroundMode(2);
        this.wtable = new Table(this.composite, 68354);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        this.wtable.setLayoutData((Object)gd);
        this.wtable.setHeaderVisible(true);
        this.wtable.setLinesVisible(true);
        TableColumn[] col = new TableColumn[3];
        col[0] = new TableColumn(this.wtable, 0);
        col[0].setText(Messages.common_fieldNameLabel);
        col[0].pack();
        col[1] = new TableColumn(this.wtable, 0);
        col[1].setText(Messages.common_type);
        col[1].pack();
        col[2] = new TableColumn(this.wtable, 0);
        col[2].setText(Messages.common_order);
        col[2].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.wtable.setLayout((Layout)tlayout);
        this.tviewer = new TableViewer(this.wtable);
        this.tviewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tviewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
        this.attachCellEditors(this.tviewer, (Composite)this.wtable);
        UIUtil.setViewerCellEditingOnDblClick(this.tviewer);
        Composite bGroup = new Composite(this.composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        bGroup.setBackground(this.background);
        new NewButton(){

            @Override
            protected void afterElementAdded(Object selement) {
                try {
                    SortFieldsTable.this.dataset.removeSortField((JRSortField)selement);
                    SortFieldsTable.this.dataset.addSortField((JRSortField)selement);
                    SortFieldsTable.this.fireModifyListeners();
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
        }.createNewButtons(bGroup, this.tviewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                ArrayList<JRDesignSortField> fields = new ArrayList<JRDesignSortField>(SortFieldsTable.this.getFields());
                JRSortField[] jRSortFieldArray = SortFieldsTable.this.dataset.getSortFields();
                int n = jRSortFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JRSortField jRSortField = jRSortFieldArray[n2];
                    SortFieldsTable.this.dataset.removeSortField(jRSortField);
                    ++n2;
                }
                for (JRDesignSortField jRDesignSortField : fields) {
                    try {
                        SortFieldsTable.this.dataset.addSortField((JRSortField)jRDesignSortField);
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                    }
                }
                JRDesignSortField jRDesignSortField = MSortField.createJRSortField(SortFieldsTable.this.dataset);
                SortFieldWizard wizard = new SortFieldWizard();
                wizard.init(SortFieldsTable.this.dataset, jRDesignSortField);
                WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
                dialog.create();
                if (dialog.open() != 0) {
                    return null;
                }
                return jRDesignSortField;
            }
        });
        new DeleteButton(){

            @Override
            protected void afterElementDeleted(Object element) {
                if (element != null) {
                    SortFieldsTable.this.dataset.removeSortField((JRSortField)element);
                    SortFieldsTable.this.fireModifyListeners();
                }
            }
        }.createDeleteButton(bGroup, this.tviewer);
        new ListOrderButtons().createOrderButtons(bGroup, this.tviewer);
        ArrayList fields = this.dataset.getSortFieldsList();
        if (fields == null) {
            fields = new ArrayList();
        }
        this.tviewer.setInput(fields);
    }

    public List<JRDesignSortField> getFields() {
        return (List)this.tviewer.getInput();
    }

    private void attachCellEditors(TableViewer viewer, Composite parent) {
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (property.equals("NAME")) {
                    return false;
                }
                if (property.equals("TYPE")) {
                    return false;
                }
                return property.equals("ORDER");
            }

            public Object getValue(Object element, String property) {
                JRDesignSortField prop = (JRDesignSortField)element;
                if ("NAME".equals(property)) {
                    return prop.getName();
                }
                if ("TYPE".equals(property)) {
                    return SortFieldsTable.this.sfdesc.getIntValue(prop.getType());
                }
                if ("ORDER".equals(property)) {
                    return EnumHelper.getEnumIndexByTranslatedName(orderEnumNames, (NamedEnum)prop.getOrderValue());
                }
                return "";
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                JRDesignSortField field = (JRDesignSortField)tableItem.getData();
                if ("NAME".equals(property)) {
                    field.setName((String)value);
                } else if ("TYPE".equals(property)) {
                    field.setType(SortFieldsTable.this.sfdesc.getEnumValue(value));
                } else if ("ORDER".equals(property)) {
                    field.setOrder((SortOrderEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])SortOrderEnum.values(), (Object)value));
                }
                SortFieldsTable.this.tviewer.update(element, new String[]{property});
                SortFieldsTable.this.tviewer.refresh();
            }
        });
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor(parent), new ComboBoxCellEditor(parent, EnumHelper.getEnumNames((NamedEnum[])SortFieldTypeEnum.values(), NullEnum.NOTNULL)), new ComboBoxCellEditor(parent, EnumHelper.getEnumNames((NamedEnum[])SortOrderEnum.values(), NullEnum.NOTNULL), 8)});
        viewer.setColumnProperties(new String[]{"NAME", "TYPE", "ORDER"});
    }

    public void refresh() {
        this.tviewer.refresh();
    }

    private final class TLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            JRDesignSortField field = (JRDesignSortField)element;
            switch (columnIndex) {
                case 0: {
                    return field.getName();
                }
                case 1: {
                    return field.getType().getName();
                }
                case 2: {
                    if (field.getOrderValue() == null) break;
                    return field.getOrderValue().getName();
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            JRDesignSortField field = (JRDesignSortField)element;
            switch (columnIndex) {
                case 0: {
                    if (field.getType().equals((Object)SortFieldTypeEnum.FIELD)) {
                        return JaspersoftStudioPlugin.getInstance().getImage(MField.getIconDescriptor().getIcon16());
                    }
                    return JaspersoftStudioPlugin.getInstance().getImage(MVariable.getIconDescriptor().getIcon16());
                }
            }
            return null;
        }
    }
}

