/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.wizard;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IDatasetContainer;
import com.jaspersoft.studio.model.command.IQueryLanguageChanged;
import com.jaspersoft.studio.model.command.SyncDatasetRunCommand;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import com.jaspersoft.studio.model.dataset.command.DeleteDatasetCommand;
import com.jaspersoft.studio.property.dataset.wizard.InfoContainer;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.SyncDatasetRunParameters;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.query.QueryExecuterFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConnectToDatasetWizardPage
extends JSSHelpWizardPage {
    protected IQueryLanguageChanged syncExecuter = new IQueryLanguageChanged(){

        @Override
        public void syncDataset(JasperDesign jd, JRDesignDataset ds, String oldLang, String newLang) throws JRException {
            QueryExecuterFactory newFactory;
            Object[] builtInParameters;
            QueryExecuterFactory oldFactory;
            boolean isMainDataset;
            boolean bl = isMainDataset = ds == jd.getMainDataset();
            if (!isMainDataset && (oldFactory = ConnectToDatasetWizardPage.this.getFactory(oldLang)) != null && (builtInParameters = oldFactory.getBuiltinParameters()) != null) {
                int i = 0;
                while (i < builtInParameters.length) {
                    String parameterName = (String)builtInParameters[i];
                    ds.removeParameter(parameterName);
                    i += 2;
                }
            }
            if ((newFactory = ConnectToDatasetWizardPage.this.getFactory(newLang)) != null && (builtInParameters = newFactory.getBuiltinParameters()) != null) {
                this.setupDataset(ds, builtInParameters);
                if (!isMainDataset) {
                    ds = jd.getMainDesignDataset();
                    this.setupDataset(ds, builtInParameters);
                }
            }
        }

        protected void setupDataset(JRDesignDataset ds, Object[] builtInParameters) throws JRException {
            int i = 0;
            while (i < builtInParameters.length) {
                String parameterName = (String)builtInParameters[i];
                String paramterType = builtInParameters[i + 1].toString();
                ds.removeParameter(parameterName);
                if (!ds.getParametersMap().containsKey(parameterName)) {
                    JRDesignParameter p = new JRDesignParameter();
                    p.setName(parameterName);
                    p.setValueClassName(paramterType);
                    p.setForPrompting(false);
                    ds.addParameter((JRParameter)p);
                }
                i += 2;
            }
        }
    };
    protected static final HashMap<String, QueryExecuterFactory> factories = new HashMap();
    private MDataset connectedDataset;
    protected List<IDatasetContainer> runReferences;
    protected List<String> missingParamOnMain;
    protected List<String> missingParamOnDataset;
    protected List<String> removedParamOnDataset;
    protected Combo dataAdapterLanguage;
    protected Composite mainComposite;
    protected ScrolledComposite scrollComposite;
    private String[] availableLanguages;
    private List<JRQueryExecuterFactoryBundle> bundles;
    private SyncDatasetRunCommand command;
    private HashMap<MDatasetRun, InfoContainer> missingParamOnRun;
    private HashMap<MDatasetRun, InfoContainer> removedParamOnRun;
    private final HashMap<String, String> typeMap = new HashMap();

    public ConnectToDatasetWizardPage(MDataset connectedDataset) {
        super("connectionpage");
        this.setTitle(Messages.ConnectToDatasetWizardPage_dialogTitle);
        this.setDescription(Messages.ConnectToDatasetWizardPage_dialogDescription);
        this.connectedDataset = connectedDataset;
        JasperReportsConfiguration jConfig = connectedDataset.getJasperConfiguration();
        this.availableLanguages = ModelUtils.getQueryLanguagesOnly(jConfig);
        this.bundles = jConfig.getExtensions(JRQueryExecuterFactoryBundle.class);
    }

    public void createControl(Composite parent) {
        Composite pageContainer = new Composite(parent, 0);
        pageContainer.setLayout((Layout)new GridLayout(1, false));
        pageContainer.setLayoutData((Object)new GridData(1808));
        Composite comboContainer = new Composite(pageContainer, 0);
        comboContainer.setLayout((Layout)new GridLayout(2, false));
        comboContainer.setData((Object)new GridData(768));
        new Label(comboContainer, 0).setText(Messages.ConnectToDatasetWizardPage_languageLabel);
        this.dataAdapterLanguage = new Combo(comboContainer, 8);
        this.dataAdapterLanguage.setItems(this.availableLanguages);
        this.scrollComposite = new ScrolledComposite(pageContainer, 512);
        this.scrollComposite.setExpandVertical(true);
        this.scrollComposite.setLayoutData((Object)new GridData(1808));
        this.mainComposite = new Composite((Composite)this.scrollComposite, 0);
        this.scrollComposite.setContent((Control)this.mainComposite);
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        JRDesignDataset dataset = this.connectedDataset.getValue();
        int index = 0;
        if (dataset != null && dataset.getQuery() != null) {
            String queryLanguage = dataset.getQuery().getLanguage();
            int i = 0;
            while (i < this.availableLanguages.length) {
                String item = this.availableLanguages[i];
                if (ModelUtils.safeEquals(item, queryLanguage)) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        this.dataAdapterLanguage.select(index);
        this.dataAdapterLanguage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectToDatasetWizardPage.this.updateContent();
                ConnectToDatasetWizardPage.this.getContainer().updateButtons();
            }
        });
        this.updateContent();
        UIUtils.resizeAndCenterShell((Shell)parent.getShell(), (int)650, (int)550);
        this.setControl((Control)pageContainer);
    }

    protected void updateContent() {
        Control[] controlArray = this.mainComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        String datasetName = (String)this.connectedDataset.getPropertyActualValue("name");
        this.runReferences = DeleteDatasetCommand.getDatasetUsage(this.connectedDataset.getRoot().getChildren(), datasetName);
        List<String> neededParameters = this.getNeededParameters();
        List<String> removedParameters = this.getRemovedParameters();
        this.missingParamOnMain = this.getMissingParameterOnMainDataset(neededParameters);
        this.missingParamOnDataset = this.getMissingParameterOnDataset(neededParameters);
        this.missingParamOnRun = this.getMissingDatasetsRun(neededParameters);
        this.removedParamOnRun = this.getRemovedDatasetsRun(removedParameters, neededParameters);
        this.removedParamOnDataset = this.getRemovedParameterOnDataset(removedParameters, neededParameters);
        if (this.missingParamOnMain.isEmpty() && this.missingParamOnDataset.isEmpty() && this.missingParamOnRun.isEmpty() && this.removedParamOnRun.isEmpty() && this.removedParamOnDataset.isEmpty() && this.dataAdapterLanguage.getText().equals(this.getOldLanguage())) {
            new Label(this.mainComposite, 0).setText(Messages.ConnectToDatasetWizardPage_noChangesLabel);
        } else {
            this.createNotEmptyContent(this.mainComposite);
        }
        this.scrollComposite.setMinSize(this.mainComposite.computeSize(-1, -1));
        this.mainComposite.setSize(this.mainComposite.computeSize(-1, -1));
        this.scrollComposite.layout(true, true);
        this.command = this.regenerateCommand();
    }

    private SyncDatasetRunCommand regenerateCommand() {
        JRDesignDataset dataset = this.connectedDataset.getValue();
        String queryLanguage = null;
        if (dataset != null && dataset.getQuery() != null) {
            queryLanguage = dataset.getQuery().getLanguage();
        }
        return new SyncDatasetRunCommand(this.connectedDataset, this.dataAdapterLanguage.getText(), queryLanguage){

            @Override
            public void execute() {
                try {
                    ((JRDesignQuery)this.dataset.getValue().getQuery()).setLanguage(this.newLang);
                    ConnectToDatasetWizardPage.this.syncExecuter.syncDataset(this.dataset.getJasperDesign(), this.dataset.getValue(), this.oldLang, this.newLang);
                    SyncDatasetRunParameters.syncDataset(this.dataset, this.oldLang, this.newLang, true);
                }
                catch (JRException ex) {
                    UIUtils.showError((Throwable)ex);
                    JaspersoftStudioPlugin.getInstance().logError(ex);
                }
            }

            @Override
            public void undo() {
                try {
                    ((JRDesignQuery)this.dataset.getValue().getQuery()).setLanguage(this.oldLang);
                    ConnectToDatasetWizardPage.this.syncExecuter.syncDataset(this.dataset.getJasperDesign(), this.dataset.getValue(), this.newLang, this.oldLang);
                    SyncDatasetRunParameters.syncDataset(this.dataset, this.newLang, this.oldLang, true);
                }
                catch (JRException ex) {
                    UIUtils.showError((Throwable)ex);
                    JaspersoftStudioPlugin.getInstance().logError(ex);
                }
            }
        };
    }

    private QueryExecuterFactory getFactory(String language) {
        if (language == null) {
            return null;
        }
        if (factories.containsKey(language)) {
            return factories.get(language);
        }
        for (JRQueryExecuterFactoryBundle bundle : this.bundles) {
            try {
                QueryExecuterFactory factory = bundle.getQueryExecuterFactory(language);
                if (factory == null) continue;
                factories.put(language, factory);
                return factory;
            }
            catch (JRException e) {
                JaspersoftStudioPlugin.getInstance().logError(e);
            }
        }
        return null;
    }

    private void createNotEmptyContent(Composite mainComposite) {
        GridLayout listLayout;
        Composite parameterComposite;
        String newLanguage = this.dataAdapterLanguage.getText();
        String oldLanguage = this.getOldLanguage();
        if (!ModelUtils.safeEquals(oldLanguage, newLanguage)) {
            new Label(mainComposite, 0).setText(MessageFormat.format(Messages.ConnectToDatasetWizardPage_changedLanguageLabel, newLanguage));
        }
        if (!this.missingParamOnMain.isEmpty()) {
            new Label(mainComposite, 0).setText(Messages.ConnectToDatasetWizardPage_additionToMaindataset);
            parameterComposite = new Composite(mainComposite, 0);
            parameterComposite.setLayoutData((Object)new GridData(768));
            listLayout = new GridLayout(1, false);
            listLayout.marginLeft = 15;
            parameterComposite.setLayout((Layout)listLayout);
            for (String missingParam : this.missingParamOnMain) {
                new Label(parameterComposite, 0).setText(missingParam);
            }
        }
        if (!this.missingParamOnDataset.isEmpty()) {
            new Label(mainComposite, 0).setText(MessageFormat.format(Messages.ConnectToDatasetWizardPage_additionToSelectedDataset, this.connectedDataset.getValue().getName()));
            parameterComposite = new Composite(mainComposite, 0);
            parameterComposite.setLayoutData((Object)new GridData(768));
            listLayout = new GridLayout(1, false);
            listLayout.marginLeft = 15;
            parameterComposite.setLayout((Layout)listLayout);
            for (String missingParam : this.missingParamOnDataset) {
                new Label(parameterComposite, 0).setText(missingParam);
            }
        }
        if (!this.removedParamOnDataset.isEmpty()) {
            new Label(mainComposite, 0).setText(MessageFormat.format(Messages.ConnectToDatasetWizardPage_removedFromDataset, this.connectedDataset.getValue().getName()));
            parameterComposite = new Composite(mainComposite, 0);
            parameterComposite.setLayoutData((Object)new GridData(768));
            listLayout = new GridLayout(1, false);
            listLayout.marginLeft = 15;
            parameterComposite.setLayout((Layout)listLayout);
            for (String missingParam : this.removedParamOnDataset) {
                new Label(parameterComposite, 0).setText(missingParam);
            }
        }
        for (IDatasetContainer datasetRuns : this.runReferences) {
            for (MDatasetRun datasetRun : datasetRuns.getDatasetRunList()) {
                InfoContainer removedContainer;
                InfoContainer missingContainer = this.missingParamOnRun.get(datasetRun);
                if (missingContainer != null) {
                    IDatasetContainer element = missingContainer.getContainer();
                    String parentName = null;
                    if (element instanceof APropertyNode) {
                        APropertyNode nodeElement = (APropertyNode)((Object)element);
                        parentName = nodeElement.getDisplayText();
                    }
                    Label titleLabel = new Label(mainComposite, 0);
                    if (parentName != null) {
                        titleLabel.setText(MessageFormat.format(Messages.ConnectToDatasetWizardPage_additionToDatasetRun, parentName));
                    } else {
                        titleLabel.setText(Messages.ConnectToDatasetWizardPage_additionToDatasetRun2);
                    }
                    Composite parameterComposite2 = new Composite(mainComposite, 0);
                    parameterComposite2.setLayoutData((Object)new GridData(768));
                    GridLayout listLayout2 = new GridLayout(1, false);
                    listLayout2.marginLeft = 15;
                    parameterComposite2.setLayout((Layout)listLayout2);
                    for (String missingParam : missingContainer.getMissingParameters()) {
                        new Label(parameterComposite2, 0).setText(missingParam);
                    }
                }
                if ((removedContainer = this.removedParamOnRun.get(datasetRun)) == null) continue;
                IDatasetContainer element = removedContainer.getContainer();
                String parentName = null;
                if (element instanceof APropertyNode) {
                    APropertyNode nodeElement = (APropertyNode)((Object)element);
                    parentName = nodeElement.getDisplayText();
                }
                Label titleLabel = new Label(mainComposite, 0);
                if (parentName != null) {
                    titleLabel.setText(MessageFormat.format(Messages.ConnectToDatasetWizardPage_removedFromDatasetRun1, parentName));
                } else {
                    titleLabel.setText(Messages.ConnectToDatasetWizardPage_removedFromDatasetRun2);
                }
                Composite parameterComposite3 = new Composite(mainComposite, 0);
                parameterComposite3.setLayoutData((Object)new GridData(768));
                GridLayout listLayout3 = new GridLayout(1, false);
                listLayout3.marginLeft = 15;
                parameterComposite3.setLayout((Layout)listLayout3);
                for (String missingParam : removedContainer.getMissingParameters()) {
                    new Label(parameterComposite3, 0).setText(missingParam);
                }
            }
        }
    }

    private List<String> getMissingParameterOnMainDataset(List<String> neededParameters) {
        ArrayList<String> result = new ArrayList<String>();
        JasperDesign design = this.connectedDataset.getJasperDesign();
        for (String neededParameter : neededParameters) {
            if (design.getParametersMap().containsKey(neededParameter)) continue;
            result.add(neededParameter);
        }
        return result;
    }

    private List<String> getMissingParameterOnDataset(List<String> neededParameters) {
        ArrayList<String> result = new ArrayList<String>();
        Map parametersMap = this.connectedDataset.getValue().getParametersMap();
        for (String neededParameter : neededParameters) {
            if (parametersMap.containsKey(neededParameter)) continue;
            result.add(neededParameter);
        }
        return result;
    }

    private List<String> getRemovedParameterOnDataset(List<String> removedParameters, List<String> neededParameters) {
        ArrayList<String> result = new ArrayList<String>();
        Map parametersMap = this.connectedDataset.getValue().getParametersMap();
        for (String removedParameter : removedParameters) {
            if (!parametersMap.containsKey(removedParameter) || neededParameters.contains(removedParameter)) continue;
            result.add(removedParameter);
        }
        return result;
    }

    private List<String> getMissingParameterOnDatasetRun(MDatasetRun datasetRun, List<String> neededParameters) {
        ArrayList<String> result = new ArrayList<String>();
        JRDatasetParameter[] parameters = datasetRun.getValue().getParameters();
        HashSet<String> definedParameters = new HashSet<String>();
        JRDatasetParameter[] jRDatasetParameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            JRDatasetParameter parameter = jRDatasetParameterArray[n2];
            definedParameters.add(parameter.getName());
            ++n2;
        }
        for (String neededParameter : neededParameters) {
            if (definedParameters.contains(neededParameter)) continue;
            result.add(neededParameter);
        }
        return result;
    }

    private List<String> getRemovedParameterOnDatasetRun(MDatasetRun datasetRun, List<String> removedParameters, List<String> neededParameters) {
        ArrayList<String> result = new ArrayList<String>();
        JRDatasetParameter[] parameters = datasetRun.getValue().getParameters();
        HashSet<String> definedParameters = new HashSet<String>();
        JRDatasetParameter[] jRDatasetParameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String expText;
            JRDatasetParameter parameter = jRDatasetParameterArray[n2];
            String pname = parameter.getName();
            if (parameter.getExpression() != null && parameter.getExpression().getText() != null && (expText = parameter.getExpression().getText()).equals("$P{" + pname + "}")) {
                definedParameters.add(pname);
            }
            ++n2;
        }
        for (String removedParameter : removedParameters) {
            if (!definedParameters.contains(removedParameter) || neededParameters.contains(removedParameter)) continue;
            result.add(removedParameter);
        }
        return result;
    }

    private HashMap<MDatasetRun, InfoContainer> getMissingDatasetsRun(List<String> neededParameters) {
        HashMap<MDatasetRun, InfoContainer> result = new HashMap<MDatasetRun, InfoContainer>();
        for (IDatasetContainer container : this.runReferences) {
            List<MDatasetRun> runList = container.getDatasetRunList();
            for (MDatasetRun run : runList) {
                List<String> missingParametersName;
                InfoContainer missingParamters = result.get(run);
                if (missingParamters != null || (missingParametersName = this.getMissingParameterOnDatasetRun(run, neededParameters)).isEmpty()) continue;
                result.put(run, new InfoContainer(missingParametersName, container, run));
            }
        }
        return result;
    }

    private HashMap<MDatasetRun, InfoContainer> getRemovedDatasetsRun(List<String> removedParameters, List<String> neededParameters) {
        HashMap<MDatasetRun, InfoContainer> result = new HashMap<MDatasetRun, InfoContainer>();
        for (IDatasetContainer container : this.runReferences) {
            List<MDatasetRun> runList = container.getDatasetRunList();
            for (MDatasetRun run : runList) {
                List<String> removedParametersName;
                InfoContainer removedParamters = result.get(run);
                if (removedParamters != null || (removedParametersName = this.getRemovedParameterOnDatasetRun(run, removedParameters, neededParameters)).isEmpty()) continue;
                result.put(run, new InfoContainer(removedParametersName, container, run));
            }
        }
        return result;
    }

    protected String getParameterType(String parameterName) {
        String type = this.typeMap.get(parameterName);
        return type != null ? type : "java.lang.Object";
    }

    private String getOldLanguage() {
        JRDesignDataset dataset = this.connectedDataset.getValue();
        if (dataset != null && dataset.getQuery() != null) {
            return dataset.getQuery().getLanguage();
        }
        return "";
    }

    protected List<String> getNeededParameters() {
        Object[] builtInParameters;
        this.typeMap.clear();
        String language = this.dataAdapterLanguage.getText();
        QueryExecuterFactory factory = this.getFactory(language);
        ArrayList<String> parameters = new ArrayList<String>();
        if (factory != null && (builtInParameters = factory.getBuiltinParameters()) != null) {
            int i = 0;
            while (i < builtInParameters.length) {
                String parameterName = (String)builtInParameters[i];
                String paramterType = builtInParameters[i + 1].toString();
                parameters.add(parameterName);
                this.typeMap.put(parameterName, paramterType);
                i += 2;
            }
        }
        return parameters;
    }

    protected List<String> getRemovedParameters() {
        Object[] builtInParameters;
        String language;
        QueryExecuterFactory factory;
        JRDesignDataset dataset = this.connectedDataset.getValue();
        ArrayList<String> parameters = new ArrayList<String>();
        if (dataset != null && dataset.getQuery() != null && (factory = this.getFactory(language = dataset.getQuery().getLanguage())) != null && (builtInParameters = factory.getBuiltinParameters()) != null) {
            int i = 0;
            while (i < builtInParameters.length) {
                String parameterName = (String)builtInParameters[i];
                parameters.add(parameterName);
                i += 2;
            }
        }
        return parameters;
    }

    public boolean canFinish() {
        if (this.runReferences == null || this.missingParamOnMain == null || this.missingParamOnDataset == null || this.removedParamOnDataset == null) {
            return false;
        }
        return !this.missingParamOnDataset.isEmpty() || !this.missingParamOnMain.isEmpty() || !this.missingParamOnRun.isEmpty() || !this.removedParamOnDataset.isEmpty() || !this.removedParamOnRun.isEmpty() || !ModelUtils.safeEquals(this.getOldLanguage(), this.dataAdapterLanguage.getText());
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_CONNECT_TO_DOMAIN;
    }

    public SyncDatasetRunCommand getCommand() {
        return this.command;
    }
}

