/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.dataset.wizard;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSWizardPage;
import java.text.MessageFormat;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WizardDatasetNewPage
extends JSSWizardPage {
    public static final String DATASET_NAME = "wizard_dataset_name";
    public static final String DATASET_EMPTY = "wizard_dataset_empty";
    private boolean emptyDataset = false;
    private Text dsname;

    public JasperDesign getJasperDesign() {
        JasperReportsConfiguration config = (JasperReportsConfiguration)((Object)this.getSettings().get("jasperreports_configuration"));
        if (config != null) {
            return config.getJasperDesign();
        }
        return null;
    }

    public boolean isEmptyDataset() {
        return this.emptyDataset;
    }

    public WizardDatasetNewPage() {
        super("datasetpage");
        this.setTitle(Messages.common_dataset);
        this.setImageDescriptor(MDataset.getIconDescriptor().getIcon32());
        this.setDescription(Messages.WizardDatasetNewPage_description);
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_DATASET_NAME;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new FormLayout());
        Label lbl = new Label(composite, 0);
        FormData fd_lbl = new FormData();
        fd_lbl.left = new FormAttachment(0, 5);
        lbl.setLayoutData((Object)fd_lbl);
        lbl.setText(String.valueOf(Messages.WizardDatasetNewPage_dataset_name) + ":");
        this.dsname = new Text(composite, 2048);
        FormData fd_dsname = new FormData();
        fd_dsname.top = new FormAttachment(0, 0);
        fd_dsname.right = new FormAttachment(100, 0);
        fd_lbl.bottom = new FormAttachment((Control)this.dsname, 0, 1024);
        fd_dsname.left = new FormAttachment((Control)lbl, 5);
        this.dsname.setLayoutData((Object)fd_dsname);
        JasperDesign jd = this.getJasperDesign();
        if (jd != null) {
            this.dsname.setText(ModelUtils.getDefaultName(jd.getDatasetMap(), "Dataset"));
        }
        this.dsname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String dstext = WizardDatasetNewPage.this.dsname.getText();
                JasperDesign jd = WizardDatasetNewPage.this.getJasperDesign();
                if (dstext == null || dstext.trim().equals("")) {
                    WizardDatasetNewPage.this.setErrorMessage(Messages.WizardDatasetNewPage_validation_not_null);
                    WizardDatasetNewPage.this.setPageComplete(false);
                } else if (jd != null && jd.getDatasetMap().get(dstext) != null) {
                    String message = MessageFormat.format(Messages.WizardDatasetNewPage_name_already_exists, dstext);
                    WizardDatasetNewPage.this.setErrorMessage(message);
                    WizardDatasetNewPage.this.setPageComplete(false);
                } else {
                    WizardDatasetNewPage.this.setPageComplete(true);
                    WizardDatasetNewPage.this.setErrorMessage(null);
                    WizardDatasetNewPage.this.setMessage(WizardDatasetNewPage.this.getDescription());
                    WizardDatasetNewPage.this.storeSettings();
                }
            }
        });
        final Button fromConn = new Button(composite, 16);
        FormData fd_fromConn = new FormData();
        fd_fromConn.left = new FormAttachment((Control)lbl, 0, 16384);
        fromConn.setLayoutData((Object)fd_fromConn);
        fromConn.setText(Messages.WizardDatasetNewPage_create_new_dataset);
        fromConn.setSelection(true);
        fromConn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardDatasetNewPage.this.emptyDataset = !fromConn.getSelection();
                WizardDatasetNewPage.this.storeSettings();
                WizardDatasetNewPage.this.getWizard().getContainer().updateButtons();
            }
        });
        Button empty = new Button(composite, 16);
        fd_fromConn.bottom = new FormAttachment((Control)empty, -30);
        FormData fd_empty = new FormData();
        fd_empty.top = new FormAttachment(0, 120);
        fd_empty.left = new FormAttachment((Control)lbl, 0, 16384);
        empty.setLayoutData((Object)fd_empty);
        empty.setText(Messages.WizardDatasetNewPage_create_an_empty_dataset);
        empty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardDatasetNewPage.this.emptyDataset = !fromConn.getSelection();
                WizardDatasetNewPage.this.storeSettings();
                WizardDatasetNewPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.storeSettings();
    }

    public void storeSettings() {
        if (this.getSettings() == null) {
            return;
        }
        this.getSettings().put(DATASET_NAME, this.dsname.getText());
        this.getSettings().put(DATASET_EMPTY, this.emptyDataset);
    }
}

