/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.classname;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.ATextDialogCellEditor;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ClassTypeCellEditor
extends ATextDialogCellEditor {
    private List<Class<?>> classes;

    public void setClasses(List<Class<?>> classes) {
        this.classes = classes;
    }

    public ClassTypeCellEditor(Composite parent) {
        super(parent);
    }

    public ClassTypeCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected Object openDialogBox(Control cellEditorWindow) {
        return ClassTypeCellEditor.getJavaClassDialog(cellEditorWindow.getShell(), this.classes);
    }

    public static String getJavaClassDialog(Shell shell, List<Class<?>> classes) {
        try {
            IJavaProject jprj;
            IType t;
            IProject prj;
            IJavaSearchScope searchScope = SearchEngine.createWorkspaceScope();
            if (classes != null && !classes.isEmpty() && (prj = ((IFileEditorInput)SelectionHelper.getActiveJRXMLEditor().getEditorInput()).getFile().getProject()) != null && (t = (jprj = JavaCore.create((IProject)prj)).findType(classes.get(0).getName())) != null) {
                ITypeHierarchy hierarchy = t.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                IType[] subTypes = hierarchy.getAllSubtypes(t);
                searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])subTypes);
            }
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)searchScope, (int)256, (boolean)false);
            dialog.setTitle(Messages.ClassTypeCellEditor_open_type);
            dialog.setMessage(Messages.ClassTypeCellEditor_dialog_message);
            if (dialog.open() == 0 && dialog.getResult() != null && dialog.getResult().length > 0) {
                IType bt = (IType)dialog.getResult()[0];
                return bt.getFullyQualifiedName();
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }
}

