/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.classname;

import com.jaspersoft.studio.property.descriptor.classname.ClassTypeCellEditor;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ClassTypeComboCellEditor
extends CellEditor {
    public static String[] DEFAULT_ITEMS = new String[]{"java.lang.Integer", "java.lang.Long", "java.lang.Double", "java.lang.String", "java.lang.Short", "java.lang.Boolean", "java.lang.Float", "java.math.BigDecimal", "java.sql.Time", "java.sql.Timestamp", "java.sql.Date", "java.util.Date"};
    private Button button;
    private CCombo combo;
    private Composite editor;
    private List<Class<?>> classes;
    private Object value;

    static {
        Arrays.sort(DEFAULT_ITEMS);
    }

    public ClassTypeComboCellEditor(Composite parent) {
        super(parent);
    }

    protected Control createControl(Composite parent) {
        this.editor = new Composite(parent, this.getStyle());
        this.editor.setLayout((Layout)new DialogCellLayout());
        this.combo = new CCombo(this.editor, 0);
        this.combo.setItems(DEFAULT_ITEMS);
        this.combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    ClassTypeComboCellEditor.this.fireCancelEditor();
                } else if (e.character == '\r') {
                    String newValue = ClassTypeComboCellEditor.this.combo.getText();
                    ClassTypeComboCellEditor.this.applyValueAndDeactivate(newValue);
                }
            }
        });
        this.combo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        final FocusAdapter focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                String newValue = ClassTypeComboCellEditor.this.combo.getText();
                if (newValue != null) {
                    boolean newValidState = ClassTypeComboCellEditor.this.isCorrect(newValue);
                    ClassTypeComboCellEditor.this.setValueValid(newValidState);
                    if (newValidState) {
                        ClassTypeComboCellEditor.this.markDirty();
                        ClassTypeComboCellEditor.this.doSetValue(newValue);
                    }
                    if (!ClassTypeComboCellEditor.this.button.isFocusControl()) {
                        ClassTypeComboCellEditor.this.fireApplyEditorValue();
                        ClassTypeComboCellEditor.this.deactivate();
                    }
                }
            }
        };
        this.combo.addFocusListener((FocusListener)focusListener);
        this.button = new Button(this.editor, 8);
        this.button.setText("...");
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClassTypeComboCellEditor.this.combo.removeFocusListener((FocusListener)focusListener);
                String newValue = ClassTypeCellEditor.getJavaClassDialog(UIUtils.getShell(), ClassTypeComboCellEditor.this.classes);
                ClassTypeComboCellEditor.this.combo.addFocusListener((FocusListener)focusListener);
                ClassTypeComboCellEditor.this.applyValueAndDeactivate(newValue);
            }
        });
        return this.editor;
    }

    private void applyValueAndDeactivate(Object newValue) {
        if (newValue != null) {
            boolean newValidState = this.isCorrect(newValue);
            this.setValueValid(newValidState);
            if (newValidState) {
                this.markDirty();
                this.doSetValue(newValue);
            } else {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), newValue.toString()));
            }
            this.fireApplyEditorValue();
            this.deactivate();
        } else {
            this.deactivate();
        }
    }

    protected void doSetFocus() {
        this.combo.setFocus();
    }

    protected Object doGetValue() {
        return this.value;
    }

    protected void doSetValue(Object value) {
        this.value = value;
        this.updateContents(value);
    }

    protected void updateContents(Object value) {
        this.combo.setText(Misc.nvl((Object)value, (String)""));
    }

    public void setClasses(List<Class<?>> classes) {
        this.classes = classes;
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = ClassTypeComboCellEditor.this.button.computeSize(-1, -1, force);
            if (ClassTypeComboCellEditor.this.combo != null) {
                ClassTypeComboCellEditor.this.combo.setBounds(0, 0, bounds.width - size.x, bounds.height);
            }
            ClassTypeComboCellEditor.this.button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = ClassTypeComboCellEditor.this.combo.computeSize(-1, -1, force);
            Point buttonSize = ClassTypeComboCellEditor.this.button.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

