/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.color;

import com.jaspersoft.studio.property.color.chooser.ColorDialog;
import com.jaspersoft.studio.property.descriptor.EditableDialogCellEditor;
import com.jaspersoft.studio.utils.AlfaRGB;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ColorCellEditor
extends EditableDialogCellEditor {
    private static final int GAP = 6;
    private Composite composite;
    protected Label rgbLabel;

    public ColorCellEditor(Composite parent) {
        this(parent, 0);
    }

    public ColorCellEditor(Composite parent, int style) {
        super(parent, style);
        this.doSetValue(AlfaRGB.getFullyOpaque(new RGB(0, 0, 0)));
    }

    protected Control createContents(Composite cell) {
        Color bg = cell.getBackground();
        this.composite = new Composite(cell, this.getStyle());
        this.composite.setBackground(bg);
        this.composite.setLayout((Layout)new ColorCellLayout());
        this.rgbLabel = new Label(this.composite, 16384);
        this.rgbLabel.setBackground(bg);
        this.rgbLabel.setFont(cell.getFont());
        return this.composite;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        AlfaRGB newARGB;
        ColorDialog dialog = new ColorDialog(cellEditorWindow.getShell());
        AlfaRGB argb = (AlfaRGB)this.getValue();
        if (argb != null) {
            dialog.setRGB(argb);
        }
        if ((newARGB = dialog.openAlfaRGB()) != null) {
            return newARGB;
        }
        return argb;
    }

    protected void updateContents(Object value) {
        AlfaRGB argb = (AlfaRGB)value;
        if (argb == null) {
            this.rgbLabel.setText("");
        } else {
            RGB rgb = argb.getRgb();
            this.rgbLabel.setText("RGB (" + rgb.red + "," + rgb.green + "," + rgb.blue + ") Transparency: " + argb.getAlfa());
        }
    }

    private class ColorCellLayout
    extends Layout {
        private ColorCellLayout() {
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point rgbSize = ColorCellEditor.this.rgbLabel.computeSize(-1, -1, force);
            return new Point(6 + rgbSize.x, rgbSize.y);
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point rgbSize = ColorCellEditor.this.rgbLabel.computeSize(-1, -1, force);
            int ty = (bounds.height - rgbSize.y) / 2;
            if (ty < 0) {
                ty = 0;
            }
            ColorCellEditor.this.rgbLabel.setBounds(5, ty, bounds.width - 6, bounds.height);
        }
    }
}

