/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.color;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import java.awt.Color;
import net.sf.jasperreports.chartthemes.simple.ColorProvider;
import net.sf.jasperreports.chartthemes.simple.GradientPaintProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.swt.ResourceCache;

public class ColorLabelProvider
extends LabelProvider {
    protected NullEnum canBeNull;
    private ResourceCache imagesCache = new ResourceCache();

    public ColorLabelProvider(NullEnum canBeNull) {
        this.canBeNull = canBeNull;
    }

    public Image getImage(Object element) {
        return this.getImage(element, 16, 16);
    }

    private RGB getBlendedColor(RGB color, int alphaInt) {
        float alpha = (float)alphaInt / 255.0f;
        int outRed = Math.round(alpha * (float)color.red + (1.0f - alpha) * 255.0f);
        int outGreen = Math.round(alpha * (float)color.green + (1.0f - alpha) * 255.0f);
        int outBlue = Math.round(alpha * (float)color.blue + (1.0f - alpha) * 255.0f);
        return new RGB(outRed, outGreen, outBlue);
    }

    public Image getImage(Object element, int width, int height) {
        int alfa = 255;
        if (element == null) {
            return JaspersoftStudioPlugin.getInstance().getImage("icons/resources/nocolor.png");
        }
        Display display = Display.getCurrent();
        if (element instanceof ColorProvider) {
            element = Colors.getRGB4AWTColor(((ColorProvider)element).getColor());
        }
        if (element instanceof AlfaRGB) {
            AlfaRGB alfaRGB = (AlfaRGB)element;
            element = alfaRGB.getRgb();
            alfa = alfaRGB.getAlfa();
        }
        if (element instanceof Color) {
            Color awtColor = (Color)element;
            element = new RGB(awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
            alfa = awtColor.getAlpha();
        }
        if (element instanceof RGB) {
            RGB rgb = (RGB)element;
            String key = String.valueOf(rgb.toString()) + Integer.toString(width) + "_" + Integer.toString(height) + "_" + Integer.toString(alfa);
            Image result = this.imagesCache.getImage(key);
            if (result == null) {
                RGB black = new RGB(0, 0, 0);
                if (alfa < 255) {
                    rgb = this.getBlendedColor(rgb, alfa);
                }
                PaletteData dataPalette = new PaletteData(new RGB[]{black, black, rgb});
                ImageData data = new ImageData(width, height, 4, dataPalette);
                data.transparentPixel = 0;
                int y = 0;
                while (y < data.height) {
                    int x = 0;
                    while (x < data.width) {
                        if (x == 0 || y == 0 || x == data.width - 1 || y == data.height - 1) {
                            data.setPixel(x, y, 1);
                        } else {
                            data.setPixel(x, y, 2);
                        }
                        ++x;
                    }
                    ++y;
                }
                result = new Image((Device)display, data);
                this.imagesCache.storeImage(key, result);
            }
            return result;
        }
        if (element instanceof GradientPaintProvider) {
            Image newImage = new Image((Device)display, width, height);
            GC gc = new GC((Drawable)newImage);
            try {
                gc.setForeground(Colors.getSWT4AWTColor(((GradientPaintProvider)element).getColor1()));
                gc.setBackground(Colors.getSWT4AWTColor(((GradientPaintProvider)element).getColor2()));
                gc.fillGradientRectangle(0, 0, width, height, false);
                gc.setForeground(display.getSystemColor(2));
                gc.drawRectangle(0, 0, width - 1, height - 1);
            }
            finally {
                gc.dispose();
            }
            return newImage;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        if (element instanceof Color) {
            element = Colors.getRGB4AWTColor((Color)element);
        }
        if (element instanceof ColorProvider) {
            element = Colors.getRGB4AWTColor(((ColorProvider)element).getColor());
        }
        if (element instanceof AlfaRGB) {
            element = ((AlfaRGB)element).getRgb();
        }
        if (element instanceof RGB) {
            RGB rgb = (RGB)element;
            return String.valueOf(rgb.red) + "," + rgb.green + "," + rgb.blue;
        }
        if (element instanceof GradientPaintProvider) {
            return String.valueOf(this.getText(((GradientPaintProvider)element).getColor1())) + " - " + this.getText(((GradientPaintProvider)element).getColor2());
        }
        return "";
    }

    public void dispose() {
        super.dispose();
        this.imagesCache.dispose();
    }
}

