/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.expression;

import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.dataset.DatasetPropertyExpressionDTO;
import com.jaspersoft.studio.model.dataset.DatasetPropertyExpressionsDTO;
import com.jaspersoft.studio.property.descriptor.expression.ExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.dialog.HintsPropertiesList;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.WItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.ItemPropertyLayoutData;
import com.jaspersoft.studio.widgets.framework.ui.AbstractExpressionPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.BigDecimalPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ClassItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ColorPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ComboItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.FloatPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.IntegerPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.JRDataAdapterPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.JSSDataAdapterPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.LocaleComboPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.TextPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.TimezoneComboPropertyDescription;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.engine.DatasetPropertyExpression;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.DesignDatasetPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignPropertyExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;
import net.sf.jasperreports.engine.type.PropertyEvaluationTimeEnum;
import net.sf.jasperreports.properties.PropertyMetadata;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class ASPropertyExpressionWidget
extends ASPropertyWidget<ExpressionPropertyDescriptor> {
    private String propertyName;
    private PropertyExpressionDTO dto;
    private WItemProperty wip;
    private Object element;

    public ASPropertyExpressionWidget(Composite parent, AbstractSection section, ExpressionPropertyDescriptor pDescriptor, String propertyName) {
        super(parent, section, pDescriptor);
        this.propertyName = propertyName;
        this.createComponent(parent);
        if (this.getControl() != null) {
            this.setupFocusControl((IPropertyDescriptor)pDescriptor, this.getControl());
        }
    }

    @Override
    protected void createComponent(Composite parent) {
        if (this.propertyName != null) {
            this.element = this.section.getElement().getValue();
            List<PropertyMetadata> propertiesInfo = HintsPropertiesList.getPropertiesMetadata(this.element, this.section.getElement().getExpressionContext());
            PropertyMetadata propertyInfo = null;
            for (PropertyMetadata property : propertiesInfo) {
                if (!this.propertyName.equalsIgnoreCase(property.getName())) continue;
                propertyInfo = property;
                break;
            }
            ItemPropertyDescription<?> ipd = this.getWidget(propertyInfo);
            this.wip = new WItemProperty(parent, 0, ipd, new IPropertyEditor(){

                @Override
                public String getPropertyValue(String propertyName) {
                    PropertyExpressionDTO dto1 = ASPropertyExpressionWidget.this.getValue();
                    if (!dto1.isExpression()) {
                        return ASPropertyExpressionWidget.this.getValue().getValue();
                    }
                    return null;
                }

                @Override
                public JRExpression getPropertyValueExpression(String propertyName) {
                    PropertyExpressionDTO dto1 = ASPropertyExpressionWidget.this.getValue();
                    if (dto1.isExpression()) {
                        return ASPropertyExpressionWidget.this.getValue().getValueAsExpression();
                    }
                    return null;
                }

                @Override
                public void createUpdateProperty(String propertyName, String value, JRExpression valueExpression) {
                    PropertyExpressionDTO dto1 = ASPropertyExpressionWidget.this.getValue();
                    dto1.setValue(value);
                    dto1.setExpression(false);
                    if (valueExpression != null) {
                        dto1.setExpression(true);
                        dto1.setValue(valueExpression.getText());
                    }
                    SetDtoCommand command = new SetDtoCommand(dto1);
                    CommandStack cs = ASPropertyExpressionWidget.this.section.getEditDomain().getCommandStack();
                    cs.execute((Command)command);
                }

                @Override
                public void removeProperty(String propertyName) {
                    ASPropertyExpressionWidget.this.removePropertyExpression(ASPropertyExpressionWidget.this.element, propertyName);
                }
            });
            this.wip.setLayoutData(new GridData(768));
            ItemPropertyLayoutData wipLayoutData = new ItemPropertyLayoutData();
            wipLayoutData.leftMargin = 0;
            this.wip.setContentLayoutData(wipLayoutData);
            this.wip.updateWidget(false);
        }
    }

    @Override
    public void setData(APropertyNode pnode, Object value) {
        this.dto = null;
        this.element = pnode.getValue();
        this.getValue();
        if (this.wip != null) {
            this.wip.updateWidget();
        }
    }

    @Override
    public Control getControl() {
        return this.wip;
    }

    @Override
    public Control getControlToBorder() {
        return this.wip != null ? this.wip.getControl() : null;
    }

    protected ItemPropertyDescription<?> getWidget(PropertyMetadata propertyMetadata) {
        String propertyType;
        AbstractExpressionPropertyDescription ipd = null;
        String string = propertyType = propertyMetadata.getValueType() != null ? propertyMetadata.getValueType() : String.class.getName();
        if (propertyType.equals(Boolean.class.getName())) {
            ipd = new ComboItemPropertyDescription<Boolean>(this.propertyName, propertyMetadata.getLabel(), propertyMetadata.getDescription(), false, Boolean.valueOf(Boolean.parseBoolean(propertyMetadata.getDefaultValue())), new String[]{"", "true", "false"});
        } else if (this.propertyName.equals("net.sf.jasperreports.data.adapter") || propertyType.equals(DataAdapter.class.getName())) {
            ipd = new JRDataAdapterPropertyDescription(this.propertyName, propertyMetadata.getLabel(), propertyMetadata.getDescription(), false, this.section.getElement().getJasperConfiguration());
        } else if (propertyType.equals(String.class.getName())) {
            ipd = new TextPropertyDescription<String>(this.propertyName, propertyMetadata.getLabel(), propertyMetadata.getDescription(), false, propertyMetadata.getDefaultValue());
        } else if (propertyType.equals(Class.class.getName())) {
            ipd = new ClassItemPropertyDescription(this.propertyName, propertyMetadata.getLabel(), propertyMetadata.getDescription(), false, propertyMetadata.getDefaultValue(), new String[0]);
        } else if (propertyType.equals(Integer.class.getName()) || propertyType.equals(Long.class.getName())) {
            ipd = new IntegerPropertyDescription(this.propertyName, propertyMetadata.getLabel(), propertyMetadata.getDescription(), false, propertyMetadata.getDefaultValue() != null ? Integer.valueOf(Integer.parseInt(propertyMetadata.getDefaultValue())) : null, null, null);
        } else if (propertyType.equals(BigDecimal.class.getName()) || propertyType.equals(Double.class.getName())) {
            ipd = new BigDecimalPropertyDescription(this.propertyName, propertyMetadata.getLabel(), propertyMetadata.getDescription(), false, propertyMetadata.getDefaultValue() != null ? new BigDecimal(propertyMetadata.getDefaultValue()) : null, null, null);
        } else if (propertyType.equals(Float.class.getName())) {
            ipd = new FloatPropertyDescription(this.propertyName, propertyMetadata.getLabel(), propertyMetadata.getDescription(), false, propertyMetadata.getDefaultValue() != null ? Float.valueOf(Float.parseFloat(propertyMetadata.getDefaultValue())) : null, null, null);
        } else if (propertyType.equals(Color.class.getName())) {
            ipd = new ColorPropertyDescription<Object>(this.propertyName, propertyMetadata.getLabel(), propertyMetadata.getDescription(), false, (propertyMetadata.getDefaultValue() != null ? Color.decode(propertyMetadata.getDefaultValue()) : null));
        } else if (propertyType.equals(TimeZone.class.getName())) {
            ipd = new TimezoneComboPropertyDescription(this.propertyName, propertyMetadata.getLabel(), propertyMetadata.getDescription(), false, propertyMetadata.getDefaultValue());
        } else if (propertyType.equals(Locale.class.getName())) {
            ipd = new LocaleComboPropertyDescription(this.propertyName, propertyMetadata.getLabel(), propertyMetadata.getDescription(), false, propertyMetadata.getDefaultValue());
        } else if (propertyType.equals("jssDA")) {
            ipd = new JSSDataAdapterPropertyDescription(this.propertyName, propertyMetadata.getLabel(), propertyMetadata.getDescription(), false, this.section.getElement().getJasperConfiguration());
        } else {
            try {
                Class<?> clazz = Class.forName(propertyType);
                if (clazz.isEnum()) {
                    ?[] obj = clazz.getEnumConstants();
                    String[] items = new String[obj.length];
                    int i = 0;
                    while (i < obj.length) {
                        items[i] = obj[i].toString();
                        ++i;
                    }
                    ipd = new ComboItemPropertyDescription<String>(this.propertyName, propertyMetadata.getLabel(), propertyMetadata.getDescription(), false, propertyMetadata.getDefaultValue(), items);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (ipd == null) {
                ipd = new TextPropertyDescription<String>(this.propertyName, propertyMetadata.getLabel(), propertyMetadata.getDescription(), false, propertyMetadata.getDefaultValue());
            }
        }
        return ipd;
    }

    public void setValue(Object value) {
        this.dto = null;
        if (this.element instanceof JRPropertiesHolder) {
            JRPropertiesHolder field = (JRPropertiesHolder)this.element;
            if (this.isPropertyExpressions(this.element) && value instanceof PropertyExpressionDTO) {
                PropertyExpressionDTO dto1 = (PropertyExpressionDTO)value;
                if (dto1.isExpression()) {
                    if (dto1.getValue() == null || dto1.getValue().isEmpty()) {
                        this.removePropertyExpression(this.element, this.propertyName);
                    } else {
                        this.removePropertyExpression(this.element, this.propertyName);
                        if (dto1 instanceof DatasetPropertyExpressionDTO) {
                            this.addPropertyExpression(this.element, this.propertyName, dto1.getValueAsExpression(), ((DatasetPropertyExpressionDTO)dto1).getEvalTime());
                        } else {
                            this.addPropertyExpression(this.element, this.propertyName, dto1.getValueAsExpression(), null);
                        }
                    }
                } else {
                    this.removePropertyExpression(this.element, this.propertyName);
                    if (dto1.getValue() == null || dto1.getValue().isEmpty()) {
                        field.getPropertiesMap().removeProperty(this.propertyName);
                    } else {
                        field.getPropertiesMap().setProperty(this.propertyName, dto1.getValue());
                    }
                }
            } else if (value == null || value.toString().isEmpty()) {
                field.getPropertiesMap().removeProperty(this.propertyName);
            } else {
                field.getPropertiesMap().setProperty(this.propertyName, value.toString());
            }
        } else if (this.element instanceof PropertyExpressionsDTO) {
            PropertyExpressionDTO dto12;
            PropertyExpressionsDTO d = (PropertyExpressionsDTO)this.element;
            for (PropertyExpressionDTO dto12 : d.getProperties()) {
                if (!dto12.getName().equals(this.propertyName)) continue;
                dto12.setExpression(value instanceof JRDesignExpression);
                dto12.setValue(value instanceof JRDesignExpression ? ((JRDesignExpression)value).getText() : value.toString());
                return;
            }
            dto12 = null;
            if (this.element instanceof DatasetPropertyExpressionsDTO) {
                if (value instanceof PropertyExpressionDTO) {
                    PropertyExpressionDTO pedto = (PropertyExpressionDTO)value;
                    dto12 = new DatasetPropertyExpressionDTO(pedto.isExpression(), this.propertyName, pedto.isExpression() ? pedto.getValueAsExpression().toString() : pedto.getValue(), pedto.isSimpleText(), PropertyEvaluationTimeEnum.LATE);
                } else {
                    String pValue;
                    boolean isExpr = value instanceof JRDesignExpression;
                    String string = pValue = isExpr ? ((JRDesignExpression)value).getText() : value.toString();
                    boolean isSimpleText = isExpr ? ExpressionTypeEnum.SIMPLE_TEXT == ((JRDesignExpression)value).getType() : false;
                    dto12 = new DatasetPropertyExpressionDTO(isExpr, this.propertyName, pValue, isSimpleText, PropertyEvaluationTimeEnum.LATE);
                }
            } else if (value instanceof PropertyExpressionDTO) {
                dto12 = (PropertyExpressionDTO)value;
            } else {
                String pValue;
                boolean isExpr = value instanceof JRDesignExpression;
                String string = pValue = isExpr ? ((JRDesignExpression)value).getText() : value.toString();
                boolean isSimpleText = isExpr ? ExpressionTypeEnum.SIMPLE_TEXT == ((JRDesignExpression)value).getType() : false;
                dto12 = new PropertyExpressionDTO(isExpr, this.propertyName, pValue, isSimpleText);
            }
            ((PropertyExpressionsDTO)this.element).getProperties().add(dto12);
        } else if (this.element instanceof JRPropertiesMap) {
            JRPropertiesMap map = (JRPropertiesMap)this.element;
            map.setProperty(this.propertyName, (String)value);
        }
    }

    protected PropertyExpressionDTO getValue() {
        if (this.dto != null) {
            return this.dto;
        }
        if (this.element instanceof JRPropertiesHolder) {
            JRPropertyExpression[] pexps;
            JRPropertiesHolder field = (JRPropertiesHolder)this.element;
            boolean isExpression = false;
            boolean isSimpleText = false;
            String value = field.getPropertiesMap().getProperty(this.propertyName);
            if (this.isPropertyExpressions(this.element) && (pexps = this.getPropertyExpressions(this.element)) != null) {
                JRPropertyExpression[] jRPropertyExpressionArray = pexps;
                int n = pexps.length;
                int n2 = 0;
                while (n2 < n) {
                    JRPropertyExpression pe = jRPropertyExpressionArray[n2];
                    if (pe.getName().equals(this.propertyName) && pe.getValueExpression() != null) {
                        isExpression = true;
                        value = pe.getValueExpression().getText();
                        boolean bl = isSimpleText = ExpressionTypeEnum.SIMPLE_TEXT == pe.getValueExpression().getType();
                        if (pe instanceof DatasetPropertyExpression) {
                            this.dto = new DatasetPropertyExpressionDTO(isExpression, this.propertyName, value, isSimpleText, ((DatasetPropertyExpression)pe).getEvaluationTime());
                            return this.dto;
                        }
                    }
                    ++n2;
                }
            }
            return new PropertyExpressionDTO(isExpression, this.propertyName, value, isSimpleText);
        }
        if (this.element instanceof PropertyExpressionsDTO) {
            PropertyExpressionsDTO d = (PropertyExpressionsDTO)this.element;
            for (PropertyExpressionDTO pe : d.getProperties()) {
                if (!pe.getName().equals(this.propertyName)) continue;
                this.dto = pe;
                return this.dto;
            }
        } else if (this.element instanceof JRPropertiesMap) {
            JRPropertiesMap field = (JRPropertiesMap)this.element;
            String value = field.getProperty(this.propertyName);
            return new PropertyExpressionDTO(false, this.propertyName, value, false);
        }
        this.dto = new PropertyExpressionDTO(false, this.propertyName, "", false);
        return this.dto;
    }

    public boolean isPropertyExpressions(Object element) {
        return element instanceof JRDesignField || element instanceof JRElement || element instanceof JRReport || element instanceof JRDataset || element instanceof PropertyExpressionsDTO;
    }

    public JRPropertyExpression[] getPropertyExpressions(Object element) {
        if (element instanceof JRDesignField) {
            return ((JRField)element).getPropertyExpressions();
        }
        if (element instanceof JRElement) {
            return ((JRElement)element).getPropertyExpressions();
        }
        if (element instanceof JRReport) {
            return ((JRReport)element).getPropertyExpressions();
        }
        if (element instanceof JRDataset) {
            return ((JRDataset)element).getPropertyExpressions();
        }
        return null;
    }

    public void removePropertyExpression(Object element, String name) {
        if (element instanceof JRDesignField) {
            ((JRDesignField)element).removePropertyExpression(name);
        } else if (element instanceof JRElement) {
            ((JRDesignElement)element).removePropertyExpression(name);
        } else if (element instanceof JasperDesign) {
            ((JasperDesign)element).removePropertyExpression(name);
        } else if (element instanceof JRDesignDataset) {
            ((JRDesignDataset)element).removePropertyExpression(name);
        } else if (element instanceof PropertyExpressionsDTO) {
            PropertyExpressionsDTO d = (PropertyExpressionsDTO)element;
            PropertyExpressionDTO toDel = null;
            for (PropertyExpressionDTO dto1 : d.getProperties()) {
                if (!dto1.getName().equals(name)) continue;
                toDel = dto1;
                break;
            }
            if (toDel != null) {
                d.getProperties().remove(toDel);
            }
        }
    }

    public void addPropertyExpression(Object element, String name, JRExpression exp, PropertyEvaluationTimeEnum pet) {
        if (element instanceof JRDesignField) {
            JRDesignPropertyExpression pe = new JRDesignPropertyExpression();
            pe.setName(this.propertyName);
            pe.setValueExpression(exp);
            ((JRDesignField)element).addPropertyExpression((JRPropertyExpression)pe);
        } else if (element instanceof JRElement) {
            JRDesignPropertyExpression pe = new JRDesignPropertyExpression();
            pe.setName(this.propertyName);
            pe.setValueExpression(exp);
            ((JRDesignElement)element).addPropertyExpression((JRPropertyExpression)pe);
        } else if (element instanceof JasperDesign) {
            DesignDatasetPropertyExpression pe = new DesignDatasetPropertyExpression();
            pe.setName(this.propertyName);
            pe.setValueExpression(exp);
            pe.setEvaluationTime(pet);
            ((JasperDesign)element).addPropertyExpression((DatasetPropertyExpression)pe);
        } else if (element instanceof JRDesignDataset) {
            DesignDatasetPropertyExpression pe = new DesignDatasetPropertyExpression();
            pe.setName(this.propertyName);
            pe.setValueExpression(exp);
            pe.setEvaluationTime(pet);
            ((JRDesignDataset)element).addPropertyExpression((DatasetPropertyExpression)pe);
        }
    }

    private class SetDtoCommand
    extends Command {
        private Object newValue;
        private PropertyExpressionDTO oldValue;

        public SetDtoCommand(Object newValue) {
            this.newValue = newValue;
        }

        public void execute() {
            this.oldValue = ASPropertyExpressionWidget.this.getValue();
            ASPropertyExpressionWidget.this.setValue(this.newValue);
            ASPropertyExpressionWidget.this.section.getElement().propertyChange(new PropertyChangeEvent(ASPropertyExpressionWidget.this.section.getElement().getValue(), "PROPERTY_MAP", this.newValue, this.oldValue));
        }

        public void undo() {
            ASPropertyExpressionWidget.this.setValue(this.oldValue);
            ASPropertyExpressionWidget.this.section.getElement().propertyChange(new PropertyChangeEvent(ASPropertyExpressionWidget.this.section.getElement().getValue(), "PROPERTY_MAP", this.newValue, this.oldValue));
        }

        public void redo() {
            ASPropertyExpressionWidget.this.setValue(this.newValue);
            ASPropertyExpressionWidget.this.section.getElement().propertyChange(new PropertyChangeEvent(ASPropertyExpressionWidget.this.section.getElement().getValue(), "PROPERTY_MAP", this.newValue, this.oldValue));
        }
    }
}

