/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.expression;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.property.descriptor.JSSDialogCellEditor;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionLabelProvider;
import com.jaspersoft.studio.property.descriptor.expression.dialog.JRExpressionEditor;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class JRExpressionCellEditor
extends JSSDialogCellEditor {
    private ExpressionContext expContext;
    private JRExpressionLabelProvider labelProvider;

    public JRExpressionCellEditor(Composite parent, ExpressionContext expContext) {
        super(parent, true);
        this.expContext = expContext;
    }

    public JRExpressionCellEditor(Composite parent, int style, ExpressionContext expContext) {
        super(parent, style, true);
        this.expContext = expContext;
    }

    @Override
    protected Object openDialogBox(Control cellEditorWindow) {
        if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
            JRExpressionEditor wizard = new JRExpressionEditor();
            JRDesignExpression originalValue = (JRDesignExpression)this.getValue();
            wizard.setValue(originalValue);
            wizard.setExpressionContext(this.expContext);
            WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog(cellEditorWindow.getShell(), wizard);
            dialog.create();
            if (dialog.open() == 0) {
                JRDesignExpression value = wizard.getValue();
                return value;
            }
            return originalValue;
        }
        return null;
    }

    @Override
    protected void updateContents(Object value) {
        if (this.getDefaultLabel() == null) {
            return;
        }
        if (this.labelProvider == null) {
            this.labelProvider = new JRExpressionLabelProvider();
        }
        String text = this.labelProvider.getText(value);
        this.getDefaultLabel().setText(text);
    }

    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }
}

