/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.expression.dialog;

import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorComposite;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupport;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.editor.expression.ExpressionStatus;
import com.jaspersoft.studio.editor.expression.IExpressionStatusChangeListener;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.ClassType;
import com.jaspersoft.studio.utils.RecentExpressions;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class JRExpressionPage
extends JSSHelpWizardPage {
    private JRDesignExpression value;
    private StyledText queryText;
    private ClassType valueType;
    private ExpressionEditorComposite contributedComposite;
    private ExpressionContext exprContext;

    public JRDesignExpression getValue() {
        if (this.contributedComposite != null) {
            JRDesignExpression expression = (JRDesignExpression)this.contributedComposite.getExpression();
            if (expression != null && !Misc.nvl((String)expression.getText()).equals("")) {
                RecentExpressions.addNewExpression(expression.getText());
            }
            return expression;
        }
        return this.value;
    }

    public void setValue(JRDesignExpression value) {
        this.value = value != null ? (JRDesignExpression)value.clone() : new JRDesignExpression();
    }

    public void setExpressionContext(ExpressionContext exprContext) {
        this.exprContext = exprContext;
        ExpressionEditorSupportUtil.setCurrentExpressionContext(this.exprContext);
    }

    protected JRExpressionPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.common_expression_editor);
        this.setDescription(Messages.JRExpressionPage_description);
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_EXPRESSION_EDITOR;
    }

    public void createControl(Composite parent) {
        ExpressionEditorSupport editorSupportForReportLanguage = ExpressionEditorSupportUtil.getEditorSupport(this.exprContext);
        if (editorSupportForReportLanguage != null) {
            this.contributedComposite = editorSupportForReportLanguage.createExpressionEditorComposite(parent);
            this.contributedComposite.setExpressionContext(this.getExpressionContext());
            this.contributedComposite.addExpressionStatusChangeListener(new IExpressionStatusChangeListener(){

                @Override
                public void statusChanged(ExpressionStatus status) {
                    JRExpressionPage.this.setErrorMessage(null);
                    switch (status) {
                        case INFO: {
                            JRExpressionPage.this.setMessage(Messages.JRExpressionPage_description);
                            break;
                        }
                        case ERROR: {
                            JRExpressionPage.this.setMessage(status.getShortDescription(), 3);
                            break;
                        }
                        case WARNING: {
                            JRExpressionPage.this.setMessage(status.getShortDescription(), 2);
                        }
                    }
                }
            });
            this.contributedComposite.setExpression((JRExpression)this.value);
            this.setControl((Control)this.contributedComposite);
        } else {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            this.setControl((Control)composite);
            Label lbl1 = new Label(composite, 0);
            lbl1.setText("Value Class Name");
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            lbl1.setLayoutData((Object)gd);
            this.valueType = new ClassType(composite, Messages.JRExpressionPage_1);
            this.valueType.addListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    JRExpressionPage.this.value.setValueClassName(JRExpressionPage.this.valueType.getClassType());
                }
            });
            Label lbl2 = new Label(composite, 0);
            lbl2.setText(String.valueOf(Messages.common_expression) + ":");
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            lbl2.setLayoutData((Object)gd);
            this.queryText = new StyledText(composite, 2048);
            gd = new GridData(1808);
            gd.horizontalSpan = 2;
            this.queryText.setLayoutData((Object)gd);
            this.setWidgets();
            this.queryText.setFocus();
            this.queryText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    JRExpressionPage.this.value.setText(JRExpressionPage.this.queryText.getText());
                }
            });
        }
    }

    private ExpressionContext getExpressionContext() {
        if (this.exprContext == null) {
            this.exprContext = ExpressionEditorSupportUtil.getReportExpressionContext();
        }
        return this.exprContext;
    }

    private void setWidgets() {
        this.queryText.setText(Misc.nvl((Object)this.value.getText(), (String)""));
        this.valueType.setClassType(this.value.getValueClassName());
    }
}

