/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.jrQuery;

import com.jaspersoft.studio.model.MQuery;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.property.dataset.dialog.DatasetDialog;
import com.jaspersoft.studio.property.descriptor.ATextDialogRWCellEditor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.jrQuery.JRQueryLabelProvider;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JRQueryCellEditor
extends ATextDialogRWCellEditor {
    private LabelProvider labelProvider;

    public JRQueryCellEditor(Composite parent) {
        this(parent, 0);
    }

    public JRQueryCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected Object openDialogBox(Control cellEditorWindow) {
        MQuery mquery = (MQuery)this.getValue();
        MDataset mdataset = mquery.getMdataset();
        Shell shell = cellEditorWindow.getShell();
        DatasetDialog dlg = new DatasetDialog(shell, mdataset, mquery.getJasperConfiguration(), null);
        if (dlg.open() == 0) {
            return dlg.getCommand();
        }
        return null;
    }

    @Override
    protected void updateContents(Object value) {
        if (this.getDefaultLabel() == null) {
            return;
        }
        if (this.labelProvider == null) {
            this.labelProvider = new JRQueryLabelProvider(NullEnum.NULL);
        }
        String text = this.labelProvider.getText(value);
        this.getDefaultLabel().setText(text);
    }

    protected Object doGetValue() {
        Object val = super.doGetValue();
        if (this.isDirty() && val instanceof MQuery) {
            MQuery m = (MQuery)val;
            JRDesignQuery dexpr = m.getValue();
            if (dexpr == null) {
                dexpr = new JRDesignQuery();
                dexpr.setLanguage("sql");
                m.setValue(dexpr);
            }
            final JRDesignQuery e = dexpr;
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    e.setText(JRQueryCellEditor.this.text.getText());
                }
            });
            return new MQuery((JRQuery)dexpr, m.getMdataset());
        }
        return val;
    }

    protected void doSetValue(Object value) {
        super.doSetValue(value);
        if (value instanceof MQuery) {
            MQuery expression = (MQuery)value;
            this.text.removeModifyListener(this.getModifyListener());
            String pvalue = (String)expression.getPropertyValue("text");
            if (pvalue == null) {
                pvalue = "";
            }
            this.text.setText(pvalue);
            this.text.addModifyListener(this.getModifyListener());
        }
    }
}

