/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.pattern.dialog;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.pattern.dialog.APattern;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DatePattern
extends APattern {
    protected List<String> dList;
    protected org.eclipse.swt.widgets.List list;

    public DatePattern(Composite parent, String value) {
        super(parent, new SimpleDateFormat(), new Date(), value);
        this.setDescription(Messages.DatePattern_description);
    }

    @Override
    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Label l = new Label(container, 0);
        l.setText(Messages.DatePattern_template_formats);
        this.list = new org.eclipse.swt.widgets.List(container, 2048);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 3;
        gd.heightHint = 200;
        gd.widthHint = 100;
        this.list.setLayoutData((Object)gd);
        SimpleDateFormat f = (SimpleDateFormat)this.getFormatter();
        for (String s : this.getDefaults()) {
            f.applyPattern(s);
            this.list.add(f.format(this.getSample()));
        }
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatePattern.this.formatChanged();
            }
        });
        return container;
    }

    protected List<String> getDefaults() {
        if (this.dList == null) {
            this.dList = new ArrayList<String>();
            this.dList.add("M/d/yy");
            this.dList.add("MMM d, yyyy");
            this.dList.add("MMMM d, yyyy");
            this.dList.add("M/d/yy h:mm a");
            this.dList.add("MMM d, yyyy h:mm:ss a");
            this.dList.add("MMM d, yyyy h:mm:ss a z");
            this.setPattern(this.dList.get(0));
        }
        return this.dList;
    }

    @Override
    protected void formatChanged() {
        int sel = this.list.getSelectionIndex();
        if (sel >= 0) {
            this.setPattern(this.dList.get(sel));
        }
        super.formatChanged();
    }
}

