/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.property.descriptor.pattern.dialog;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.descriptor.pattern.dialog.APattern;
import com.jaspersoft.studio.property.descriptor.pattern.dialog.CurrencyPattern;
import com.jaspersoft.studio.property.descriptor.pattern.dialog.CustomPattern;
import com.jaspersoft.studio.property.descriptor.pattern.dialog.DatePattern;
import com.jaspersoft.studio.property.descriptor.pattern.dialog.NumericPattern;
import com.jaspersoft.studio.property.descriptor.pattern.dialog.PercentagePattern;
import com.jaspersoft.studio.property.descriptor.pattern.dialog.ScientificPattern;
import com.jaspersoft.studio.property.descriptor.pattern.dialog.TimePattern;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class PatternPage
extends JSSHelpWizardPage
implements PropertyChangeListener {
    private String value;
    private List list;
    private Map<String, APattern> map;
    private Text patternText;
    private Text sampleLabel;
    private APattern pattern;
    private Label descriptionLabel;
    private StackLayout stackLayout;
    private Composite configComposite;
    private APattern lastSelectedPattern;
    private boolean datePatterns = true;
    private boolean numberPatterns = true;

    public String getValue() {
        return this.value;
    }

    @Override
    public void performHelp() {
    }

    public void setValue(String value) {
        this.value = value == null ? "" : value;
    }

    public APattern getPattern() {
        if (this.pattern == null) {
            this.pattern = new CustomPattern(this.configComposite, this.value, new MessageFormat(this.value), null, this.getValue());
        }
        return this.pattern;
    }

    protected PatternPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.PatternPage_format_pattern);
        this.setDescription(Messages.PatternPage_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.list = new List(composite, 2052);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 3;
        gd.heightHint = 200;
        gd.widthHint = 100;
        this.list.setLayoutData((Object)gd);
        Composite patternGroup = new Composite(composite, 0);
        gd = new GridData(770);
        gd.widthHint = 200;
        patternGroup.setLayoutData((Object)gd);
        patternGroup.setLayout((Layout)new GridLayout(1, true));
        new Label(patternGroup, 0).setText(Messages.common_pattern);
        this.patternText = new Text(patternGroup, 2052);
        this.patternText.setText(this.getValue() != null ? this.getValue() : "");
        gd = new GridData(768);
        this.patternText.setLayoutData((Object)gd);
        this.sampleLabel = new Text(patternGroup, 0x1800008);
        this.sampleLabel.setBackground(composite.getDisplay().getSystemColor(1));
        gd = new GridData(770);
        this.sampleLabel.setLayoutData((Object)gd);
        this.configComposite = new Composite(composite, 0);
        gd = new GridData(1808);
        gd.widthHint = 200;
        gd.heightHint = 200;
        this.configComposite.setLayoutData((Object)gd);
        this.stackLayout = new StackLayout();
        this.configComposite.setLayout((Layout)this.stackLayout);
        this.createPatterns(this.configComposite);
        for (String key : this.map.keySet()) {
            this.list.add(key);
        }
        this.descriptionLabel = new Label(composite, 64);
        gd = new GridData(4);
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        gd.heightHint = 30;
        this.descriptionLabel.setLayoutData((Object)gd);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int sel = PatternPage.this.list.getSelectionIndex();
                if (sel >= 0) {
                    APattern p = PatternPage.this.map.get(PatternPage.this.list.getItem(sel));
                    if (PatternPage.this.lastSelectedPattern != null && PatternPage.this.lastSelectedPattern != p) {
                        p.setValue(PatternPage.this.lastSelectedPattern.getValue());
                    }
                    PatternPage.this.lastSelectedPattern = p;
                    PatternPage.this.descriptionLabel.setText(Misc.nvl((String)p.getDescription()));
                    PatternPage.this.descriptionLabel.pack();
                    PatternPage.this.stackLayout.topControl = p.getControl();
                    PatternPage.this.configComposite.layout();
                }
            }
        });
        this.patternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                APattern pa = PatternPage.this.getPattern();
                pa.setPattern(PatternPage.this.patternText.getText());
                PatternPage.this.processFormat(pa);
            }
        });
    }

    public boolean isDatePatterns() {
        return this.datePatterns;
    }

    public void setDatePatterns(boolean datePatterns) {
        this.datePatterns = datePatterns;
    }

    public boolean isNumberPatterns() {
        return this.numberPatterns;
    }

    public void setNumberPatterns(boolean numberPatterns) {
        this.numberPatterns = numberPatterns;
    }

    public void createPatterns(Composite parent) {
        this.map = new HashMap<String, APattern>();
        this.createDatePatterns(parent);
        this.createNumberPatterns(parent);
        for (String key : this.map.keySet()) {
            this.map.get(key).getPropertyChangeSupport().addPropertyChangeListener(this);
        }
    }

    private void createNumberPatterns(Composite parent) {
        if (this.numberPatterns) {
            this.map.put(Messages.PatternPage_number, new NumericPattern(parent, this.getValue()));
            this.map.put(Messages.PatternPage_currency, new CurrencyPattern(parent, this.getValue()));
            this.map.put(Messages.common_percentage, new PercentagePattern(parent, this.getValue()));
            this.map.put(Messages.PatternPage_scientific, new ScientificPattern(parent, this.getValue()));
        }
    }

    private void createDatePatterns(Composite parent) {
        if (this.datePatterns) {
            this.map.put(Messages.PatternPage_date, new DatePattern(parent, this.getValue()));
            this.map.put(Messages.common_time, new TimePattern(parent, this.getValue()));
        }
    }

    private void processFormat(APattern p) {
        try {
            if (p.getFormatter() != null && p.getSample() != null) {
                this.setErrorMessage(null);
                Format formatter = p.getFormatter();
                if (formatter instanceof SimpleDateFormat) {
                    ((SimpleDateFormat)formatter).applyPattern(p.getPattern());
                } else if (formatter instanceof DecimalFormat) {
                    ((DecimalFormat)formatter).applyPattern(p.getPattern());
                }
                this.sampleLabel.setText(formatter.format(p.getSample()));
            }
            this.setValue(p.getPattern());
        }
        catch (Exception ex) {
            this.setErrorMessage(ex.getMessage());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        APattern p = (APattern)evt.getSource();
        APattern pa = this.getPattern();
        pa.setPattern(p.getPattern());
        pa.setFormatter(p.getFormatter());
        pa.setSample(p.getSample());
        this.patternText.setText(p.getPattern());
        this.processFormat(p);
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_PATTERN;
    }
}

